/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme.stroke;

import com.jaspersoft.studio.components.chart.model.theme.stroke.StrokeWidget;
import java.awt.BasicStroke;
import java.awt.Stroke;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StrokeDialog
extends PersistentLocationDialog {
    private BasicStroke value;
    private Text twidth;
    private Text tdash;
    private Text tdashphase;
    private StrokeWidget sw;

    public StrokeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Stroke");
    }

    public Stroke getValue() {
        return this.value;
    }

    public void setValue(Stroke value) {
        this.value = (BasicStroke)value;
    }

    private void setValidator(Text txt) {
        txt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    if (!e.text.trim().isEmpty()) {
                        new Float(e.text);
                    }
                }
                catch (Exception exception) {
                    e.doit = false;
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(3, false));
        new Label(cmp, 0).setText("Line Width");
        this.twidth = new Text(cmp, 133120);
        this.setValidator(this.twidth);
        GridData gd = new GridData(770);
        gd.minimumWidth = 100;
        this.twidth.setLayoutData((Object)gd);
        this.twidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    float[] fArray;
                    float w = new Float(StrokeDialog.this.twidth.getText()).floatValue();
                    if (StrokeDialog.this.value != null) {
                        fArray = StrokeDialog.this.value.getDashArray();
                    } else {
                        float[] fArray2 = new float[1];
                        fArray = fArray2;
                        fArray2[0] = 1.0f;
                    }
                    float[] df = fArray;
                    float dph = StrokeDialog.this.value != null ? StrokeDialog.this.value.getDashPhase() : 1.0f;
                    StrokeDialog.this.value = new BasicStroke(w, 1, 1, 1.0f, df, dph);
                    StrokeDialog.this.handleValueChanged();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.sw = new StrokeWidget(cmp, 0);
        gd = new GridData(1808);
        gd.verticalSpan = 3;
        gd.minimumHeight = 200;
        gd.minimumWidth = 200;
        this.sw.setLayoutData(gd);
        Label lbl = new Label(cmp, 0);
        lbl.setText("Dash Size");
        lbl.setLayoutData((Object)new GridData(2));
        this.tdash = new Text(cmp, 133120);
        this.setValidator(this.tdash);
        this.tdash.setLayoutData((Object)new GridData(770));
        this.tdash.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    float w = StrokeDialog.this.value != null ? StrokeDialog.this.value.getLineWidth() : 1.0f;
                    float df = new Float(StrokeDialog.this.tdash.getText()).floatValue();
                    float dph = StrokeDialog.this.value != null ? StrokeDialog.this.value.getDashPhase() : 1.0f;
                    StrokeDialog.this.value = new BasicStroke(w, 1, 1, 1.0f, new float[]{df}, dph);
                    StrokeDialog.this.handleValueChanged();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        lbl = new Label(cmp, 0);
        lbl.setText("Dash Phase");
        lbl.setLayoutData((Object)new GridData(2));
        this.tdashphase = new Text(cmp, 133120);
        this.setValidator(this.tdashphase);
        this.tdashphase.setLayoutData((Object)new GridData(770));
        this.tdashphase.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    float[] fArray;
                    float w;
                    float f = w = StrokeDialog.this.value != null ? StrokeDialog.this.value.getLineWidth() : 1.0f;
                    if (StrokeDialog.this.value != null) {
                        fArray = StrokeDialog.this.value.getDashArray();
                    } else {
                        float[] fArray2 = new float[1];
                        fArray = fArray2;
                        fArray2[0] = 1.0f;
                    }
                    float[] df = fArray;
                    float dph = new Float(StrokeDialog.this.tdashphase.getText()).floatValue();
                    StrokeDialog.this.value = new BasicStroke(w, 1, 1, 1.0f, df, dph);
                    StrokeDialog.this.handleValueChanged();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        if (this.value != null) {
            this.twidth.setText(new Float(this.value.getLineWidth()).toString());
            float[] d = this.value.getDashArray();
            if (d != null && d.length > 0) {
                this.tdash.setText(new Float(d[0]).toString());
            }
            this.tdashphase.setText(new Float(this.value.getDashPhase()).toString());
        }
        this.handleValueChanged();
        return cmp;
    }

    private void handleValueChanged() {
        if (this.value == null) {
            return;
        }
        this.sw.setStroke(this.value);
        this.sw.setTBounds();
    }
}

