/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.property.descriptor;

import com.jaspersoft.studio.components.chart.property.widget.CustomizerWidgetsDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class ChartCustomizerDefinition {
    private String name;
    private CustomizerWidgetsDescriptor definition;
    private String classDefinition;
    private String key;
    private boolean isPropertiesCustomizer;

    public ChartCustomizerDefinition(CustomizerWidgetsDescriptor definition, String key) {
        this.definition = definition;
        this.name = definition.getLabel();
        this.classDefinition = null;
        this.isPropertiesCustomizer = true;
        this.key = key;
    }

    public ChartCustomizerDefinition(String classDefinition, String key, boolean isPropertiesCustmizer) {
        this.definition = null;
        this.classDefinition = classDefinition;
        try {
            this.name = JRClassLoader.loadClassForName((String)classDefinition).getSimpleName();
        }
        catch (Exception exception) {
            String[] splitClassname = classDefinition.split("\\.");
            this.name = splitClassname[splitClassname.length - 1];
        }
        this.key = key;
        this.isPropertiesCustomizer = isPropertiesCustmizer;
    }

    public boolean isOnlyClass() {
        return this.classDefinition != null;
    }

    public WidgetsDescriptor getDescriptor() {
        return this.definition;
    }

    public String getCustomizerClass() {
        if (this.isOnlyClass()) {
            return this.classDefinition;
        }
        return this.definition.getCustomizerClass();
    }

    public String toString() {
        if (this.isOnlyClass()) {
            return String.valueOf(this.name) + "[user defined]";
        }
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getRawClass() {
        return this.classDefinition;
    }

    public boolean isPropertiesCustomizer() {
        return this.isPropertiesCustomizer;
    }

    public ChartCustomizerDefinition clone() {
        if (this.isOnlyClass()) {
            return new ChartCustomizerDefinition(this.classDefinition, this.key, this.isPropertiesCustomizer());
        }
        return new ChartCustomizerDefinition(this.definition, this.key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChartCustomizerDefinition) {
            ChartCustomizerDefinition o2 = (ChartCustomizerDefinition)obj;
            return ModelUtils.safeEquals((Object)this.key, (Object)o2.key) && ModelUtils.safeEquals((Object)((Object)this.definition), (Object)((Object)o2.definition)) && ModelUtils.safeEquals((Object)this.classDefinition, (Object)o2.classDefinition);
        }
        return false;
    }
}

