/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.model.chartAxis.command.ChartAxesWizardPage;
import com.jaspersoft.studio.components.chart.wizard.ChartDataPage;
import com.jaspersoft.studio.components.chart.wizard.ChartTypeWizardPage;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizard;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import org.eclipse.jface.wizard.IWizardPage;

public class ChartWizard
extends JSSWizard
implements IExpressionContextSetter {
    private ChartTypeWizardPage page0;
    private ChartDataPage step1a;
    private ChartAxesWizardPage step1b;
    private MGraphicElement chart;
    private JRDesignElementDataset edataset;
    private ExpressionContext expContext;
    private int width;
    private int height;
    private boolean skipFirstPage = false;

    public ChartWizard(MGraphicElement chart, JRDesignElementDataset edataset, boolean skipFirstPage) {
        this(chart, edataset);
        this.skipFirstPage = skipFirstPage;
        this.setNeedsProgressMonitor(false);
    }

    public ChartWizard(MGraphicElement chart, JRDesignElementDataset edataset) {
        this.setWindowTitle(Messages.common_chart_wizard);
        this.chart = chart;
        this.edataset = edataset;
        JRDesignElement jrChart = chart.getValue();
        this.width = jrChart.getWidth();
        this.height = jrChart.getHeight();
    }

    public void addPages() {
        if (this.chart instanceof MChart) {
            this.page0 = new ChartTypeWizardPage((MChart)this.chart);
            this.addPage((IWizardPage)this.page0);
        }
        this.step1a = new ChartDataPage(this.chart.getValue(), this.edataset, this.getConfig());
        this.step1a.setExpressionContext(this.expContext);
        this.addPage((IWizardPage)this.step1a);
        this.step1b = new ChartAxesWizardPage();
    }

    public MGraphicElement getChart() {
        JRDesignElement jrChart = this.chart.getValue();
        jrChart.setWidth(this.width);
        jrChart.setHeight(this.height);
        return this.chart;
    }

    public IWizardPage getStartingPage() {
        if (this.skipFirstPage && this.page0 != null) {
            this.page0.setLastPageShown(true);
            return this.step1a;
        }
        return super.getStartingPage();
    }

    public boolean performFinish() {
        if (this.page0 != null) {
            boolean finished = this.page0.isPageComplete() && this.step1a.isPageComplete();
            this.page0.finishPage();
            return finished;
        }
        return this.step1a.isPageComplete();
    }

    public void setConfig(JasperReportsConfiguration config, boolean disposeConfig) {
        super.setConfig(config, disposeConfig);
        if (this.chart != null) {
            this.chart.setJasperConfiguration(config);
        }
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        if (this.step1a != null) {
            this.step1a.setExpressionContext(expContext);
        }
    }

    public void fixLastPage(boolean isMultiAxis) {
        IWizardPage[] pages = this.getPages();
        if (pages[pages.length - 1] instanceof ChartDataPage) {
            if (isMultiAxis) {
                this.removePage((IWizardPage)this.step1a);
                this.addPage((IWizardPage)this.step1b);
            }
        } else if (pages[pages.length - 1] instanceof ChartAxesWizardPage) {
            if (!isMultiAxis) {
                this.removePage((IWizardPage)this.step1b);
                this.addPage((IWizardPage)this.step1a);
            }
        } else {
            throw new RuntimeException("Use case not expected!");
        }
    }

    public byte getChoseAxis() {
        if (this.step1b != null) {
            return this.step1b.getChartAxis();
        }
        return 0;
    }
}

