/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.action;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.model.command.EditChartCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ChartWizardAction
extends ACachedSelectionAction {
    public static final String ID = "charteditaction";

    public ChartWizardAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    public Command createCommand() {
        List charts = this.editor.getSelectionCache().getSelectionModelForType(MChart.class);
        if (charts.isEmpty()) {
            return null;
        }
        for (Object chart : charts) {
            MChart n = (MChart)((Object)chart);
            if (n.getValue().getChartType() == 19) continue;
            ANode parent = n.getParent();
            if (parent instanceof MFrame) {
                return new EditChartCommand((MFrame)parent, n);
            }
            if (parent instanceof MBand) {
                return new EditChartCommand((MBand)parent, n);
            }
            if (!(parent instanceof MElementGroup)) continue;
            return new EditChartCommand((MElementGroup)parent, n);
        }
        return null;
    }

    public void run() {
        this.execute(this.command);
    }

    protected void init() {
        super.init();
        this.setText(Messages.commoneditAction);
        this.setToolTipText(Messages.commoneditToolTip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }
}

