/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperlinkPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.SeriesDialog;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.TimePeriodSerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.text.MessageFormat;
import java.util.List;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodSeries;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DSTimePeriod
extends ADSComponent {
    private JRDesignTimePeriodDataset dataset;
    private ExpressionWidget labelWidget;
    private ExpressionWidget valueWidget;
    private ExpressionWidget starDate;
    private ExpressionWidget endDate;
    private Combo seriesCombo;
    private Button hyperlinkBtn;

    public DSTimePeriod(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return "Time Period Dataset";
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignTimePeriodDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignTimePeriodDataset)eDataset;
        this.setSeries(0);
    }

    private void setSeries(int selection) {
        List seriesList = this.dataset.getSeriesList();
        if (!seriesList.isEmpty()) {
            String[] srnames = new String[seriesList.size()];
            int i = 0;
            while (i < seriesList.size()) {
                JRTimePeriodSeries cs = (JRTimePeriodSeries)seriesList.get(i);
                JRExpression se = cs.getSeriesExpression();
                srnames[i] = se != null && se.getText() != null ? se.getText() : "";
                ++i;
            }
            this.seriesCombo.setItems(srnames);
            this.seriesCombo.select(selection);
            this.handleSelectSeries(selection);
            this.hyperlinkBtn.setEnabled(true);
        } else {
            this.seriesCombo.setItems(new String[0]);
            this.hyperlinkBtn.setEnabled(false);
            this.hyperlinkBtn.setText(Messages.DSCategory_hyperlinkButtonDisabled);
            this.handleSelectSeries(-1);
        }
    }

    private void handleSelectSeries(int selection) {
        JRTimePeriodSeries serie = null;
        if (selection >= 0 && selection < this.dataset.getSeriesList().size()) {
            serie = (JRTimePeriodSeries)this.dataset.getSeriesList().get(selection);
        }
        this.valueWidget.bindObject(serie, "ValueExpression");
        this.starDate.bindObject(serie, "StartDateExpression");
        this.endDate.bindObject((Object)serie, "EndDateExpression");
        this.labelWidget.bindObject((Object)serie, "LabelExpression");
        this.hyperlinkBtn.setText(MessageFormat.format(Messages.DSCategory_defineHyperlinkButtton, this.seriesCombo.getText()));
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        Label lbl = new Label(yCompo, 0);
        lbl.setText(Messages.DSCategory_seriesLabel);
        this.seriesCombo = new Combo(yCompo, 2056);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.seriesCombo.setLayoutData((Object)gd);
        this.seriesCombo.setItems(new String[]{"series 1"});
        this.seriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DSTimePeriod.this.handleSelectSeries(DSTimePeriod.this.seriesCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button btn = new Button(yCompo, 0x800008);
        btn.setText("...");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimePeriodSerie serie = new TimePeriodSerie();
                SeriesDialog<JRTimePeriodSeries> dlg = new SeriesDialog<JRTimePeriodSeries>(btn.getShell(), serie);
                dlg.setExpressionContext(DSTimePeriod.this.expContext);
                List oldList = DSTimePeriod.this.dataset.getSeriesList();
                int oldsel = DSTimePeriod.this.seriesCombo.getSelectionIndex();
                JRTimePeriodSeries selected = null;
                if (oldsel >= 0) {
                    selected = (JRTimePeriodSeries)oldList.get(oldsel);
                }
                serie.setList(oldList);
                if (dlg.open() == 0) {
                    List<JRTimePeriodSeries> newlist = serie.getList();
                    JRTimePeriodSeries[] jRTimePeriodSeriesArray = DSTimePeriod.this.dataset.getSeries();
                    int n = jRTimePeriodSeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRTimePeriodSeries item = jRTimePeriodSeriesArray[n2];
                        DSTimePeriod.this.dataset.removeTimePeriodSeries(item);
                        ++n2;
                    }
                    for (JRTimePeriodSeries item : serie.getList()) {
                        DSTimePeriod.this.dataset.addTimePeriodSeries(item);
                    }
                    int sel = selected != null && newlist.indexOf(selected) >= 0 ? newlist.indexOf(selected) : 0;
                    DSTimePeriod.this.setSeries(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.hyperlinkBtn = new Button(yCompo, 0x800008);
        this.hyperlinkBtn.setSelection(false);
        this.hyperlinkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = DSTimePeriod.this.seriesCombo.getSelectionIndex();
                JRDesignTimePeriodSeries serie = null;
                if (selection >= 0 && selection < DSTimePeriod.this.dataset.getSeriesList().size()) {
                    serie = (JRDesignTimePeriodSeries)DSTimePeriod.this.dataset.getSeriesList().get(selection);
                }
                if (serie != null) {
                    MHyperLink hyperLinkElement = null;
                    JRHyperlink hyperlink = serie.getItemHyperlink();
                    hyperLinkElement = hyperlink != null ? DSTimePeriod.this.createHyperlinkModel((JRHyperlink)hyperlink.clone()) : DSTimePeriod.this.createHyperlinkModel((JRHyperlink)new JRDesignHyperlink());
                    HyperlinkPage dlg = new HyperlinkPage(DSTimePeriod.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, DSTimePeriod.this.seriesCombo.getText(), serie.getItemHyperlink() != null);
                    int operationResult = dlg.open();
                    if (operationResult == 0) {
                        serie.setItemHyperlink((JRHyperlink)dlg.getElement().getValue());
                    } else if (operationResult == 7) {
                        serie.setItemHyperlink(null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.valueWidget = new ExpressionWidget(yCompo, Messages.DSCategory_valueLabel);
        return yCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.starDate = new ExpressionWidget(yCompo, Messages.DSTimePeriod_startDateLabel);
        this.endDate = new ExpressionWidget(yCompo, Messages.DSTimePeriod_endDateLabel);
        return yCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.labelWidget = new ExpressionWidget(yCompo, Messages.DSCategory_labelLabel);
        return yCompo;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.endDate.setExpressionContext(expContext);
        this.labelWidget.setExpressionContext(expContext);
        this.starDate.setExpressionContext(expContext);
        this.valueWidget.setExpressionContext(expContext);
    }
}

