/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperlinkPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.SeriesDialog;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.TimeSerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.text.MessageFormat;
import java.util.List;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DSTimeSeries
extends ADSComponent {
    private JRDesignTimeSeriesDataset dataset;
    private ExpressionWidget valueWidget;
    private ExpressionWidget timePeriod;
    private ExpressionWidget labelWidget;
    private Combo seriesCombo;
    private Combo timePeriodCombo;
    private Button hyperlinkBtn;

    public DSTimeSeries(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return Messages.DSTimeSeries_0;
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignTimeSeriesDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignTimeSeriesDataset)eDataset;
        this.setSeries(0);
        TimePeriodEnum tpe = this.dataset.getTimePeriodValue();
        if (tpe == null) {
            this.timePeriodCombo.select(5);
        } else {
            TimePeriodEnum[] tpevalues = TimePeriodEnum.values();
            int i = 0;
            while (i < tpevalues.length) {
                if (tpe.equals((Object)tpevalues[i])) {
                    this.timePeriodCombo.select(i + 1);
                    break;
                }
                ++i;
            }
        }
    }

    private void setSeries(int selection) {
        List seriesList = this.dataset.getSeriesList();
        if (!seriesList.isEmpty()) {
            String[] srnames = new String[seriesList.size()];
            int i = 0;
            while (i < seriesList.size()) {
                JRTimeSeries cs = (JRTimeSeries)seriesList.get(i);
                JRExpression se = cs.getSeriesExpression();
                srnames[i] = se != null && se.getText() != null ? se.getText() : "";
                ++i;
            }
            this.seriesCombo.setItems(srnames);
            this.seriesCombo.select(selection);
            this.hyperlinkBtn.setEnabled(true);
            this.handleSelectSeries(selection);
        } else {
            this.seriesCombo.setItems(new String[0]);
            this.hyperlinkBtn.setEnabled(false);
            this.hyperlinkBtn.setText(Messages.DSCategory_hyperlinkButtonDisabled);
            this.handleSelectSeries(-1);
        }
    }

    private void handleSelectSeries(int selection) {
        JRTimeSeries serie = null;
        if (selection >= 0 && selection < this.dataset.getSeriesList().size()) {
            serie = (JRTimeSeries)this.dataset.getSeriesList().get(selection);
        }
        this.valueWidget.bindObject(serie, "ValueExpression");
        this.timePeriod.bindObject(serie, "TimePeriodExpression");
        this.labelWidget.bindObject((Object)serie, "LabelExpression");
        this.hyperlinkBtn.setText(MessageFormat.format(Messages.DSCategory_defineHyperlinkButtton, this.seriesCombo.getText()));
        this.valueWidget.setEnabled(serie != null);
        this.timePeriod.setEnabled(serie != null);
        this.labelWidget.setEnabled(serie != null);
        this.hyperlinkBtn.setEnabled(serie != null);
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        Label lbl = new Label(yCompo, 0);
        lbl.setText(Messages.DSCategory_seriesLabel);
        this.seriesCombo = new Combo(yCompo, 2056);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.seriesCombo.setLayoutData((Object)gd);
        this.seriesCombo.setItems(new String[]{"series 1"});
        this.seriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DSTimeSeries.this.handleSelectSeries(DSTimeSeries.this.seriesCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button btn = new Button(yCompo, 0x800008);
        btn.setText("...");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimeSerie serie = new TimeSerie();
                SeriesDialog<JRTimeSeries> dlg = new SeriesDialog<JRTimeSeries>(btn.getShell(), serie);
                dlg.setExpressionContext(DSTimeSeries.this.expContext);
                List oldList = DSTimeSeries.this.dataset.getSeriesList();
                int oldsel = DSTimeSeries.this.seriesCombo.getSelectionIndex();
                JRTimeSeries selected = null;
                if (oldsel >= 0) {
                    selected = (JRTimeSeries)oldList.get(oldsel);
                }
                serie.setList(oldList);
                if (dlg.open() == 0) {
                    List<JRTimeSeries> newlist = serie.getList();
                    JRTimeSeries[] jRTimeSeriesArray = DSTimeSeries.this.dataset.getSeries();
                    int n = jRTimeSeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRTimeSeries item = jRTimeSeriesArray[n2];
                        DSTimeSeries.this.dataset.removeTimeSeries(item);
                        ++n2;
                    }
                    for (JRTimeSeries item : serie.getList()) {
                        DSTimeSeries.this.dataset.addTimeSeries(item);
                    }
                    int sel = selected != null && newlist.indexOf(selected) >= 0 ? newlist.indexOf(selected) : 0;
                    DSTimeSeries.this.setSeries(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.hyperlinkBtn = new Button(yCompo, 0x800008);
        this.hyperlinkBtn.setSelection(false);
        this.hyperlinkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = DSTimeSeries.this.seriesCombo.getSelectionIndex();
                JRDesignTimeSeries serie = null;
                if (selection >= 0 && selection < DSTimeSeries.this.dataset.getSeriesList().size()) {
                    serie = (JRDesignTimeSeries)DSTimeSeries.this.dataset.getSeriesList().get(selection);
                }
                if (serie != null) {
                    MHyperLink hyperLinkElement = null;
                    JRHyperlink hyperlink = serie.getItemHyperlink();
                    hyperLinkElement = hyperlink != null ? DSTimeSeries.this.createHyperlinkModel((JRHyperlink)hyperlink.clone()) : DSTimeSeries.this.createHyperlinkModel((JRHyperlink)new JRDesignHyperlink());
                    HyperlinkPage dlg = new HyperlinkPage(DSTimeSeries.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, DSTimeSeries.this.seriesCombo.getText(), serie.getItemHyperlink() != null);
                    int operationResult = dlg.open();
                    if (operationResult == 0) {
                        serie.setItemHyperlink((JRHyperlink)dlg.getElement().getValue());
                    } else if (operationResult == 7) {
                        serie.setItemHyperlink(null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.valueWidget = new ExpressionWidget(yCompo, Messages.DSTimeSeries_valueLabel);
        return yCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        this.timePeriod = new ExpressionWidget(yCompo, Messages.DSTimeSeries_timePeriodExpression);
        Label lbl = new Label(yCompo, 0);
        lbl.setText(Messages.DSTimeSeries_timePeriodLabel);
        this.timePeriodCombo = new Combo(yCompo, 2060);
        this.timePeriodCombo.setItems(EnumHelper.getEnumNames((NamedEnum[])TimePeriodEnum.values(), (NullEnum)NullEnum.NULL));
        this.timePeriodCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DSTimeSeries.this.timePeriodCombo.getSelectionIndex() == 0) {
                    DSTimeSeries.this.dataset.setTimePeriod(null);
                } else {
                    TimePeriodEnum tpe = TimePeriodEnum.values()[DSTimeSeries.this.timePeriodCombo.getSelectionIndex() - 1];
                    DSTimeSeries.this.dataset.setTimePeriod(tpe);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.labelWidget = new ExpressionWidget(yCompo, Messages.DSTimeSeries_labelExpression);
        return yCompo;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.labelWidget.setExpressionContext(expContext);
        this.timePeriod.setExpressionContext(expContext);
        this.valueWidget.setExpressionContext(expContext);
    }
}

