/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog;

import com.jaspersoft.studio.components.chart.ContextHelpIDs;
import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.property.descriptor.ChartCustomizerDefinition;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.components.chart.property.widget.CustomizerDefinitionManager;
import com.jaspersoft.studio.components.chart.property.widget.CustomizerWidgetsDescriptor;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.CustomizerNewWizard;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.EditClassPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.EditCustomizerPage;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRChartPlot;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectCustomizerPage
extends JSSHelpWizardPage {
    private ChartCustomizerDefinition valueSelection = null;
    private String definitionKey;
    private List<CustomizerWidgetsDescriptor> tableInput;
    private CustomizerWidgetsDescriptor userDefinedEntry;
    private TableViewer table;
    private JRChartPlot selectedChartPlot;
    private Combo showAllElements;
    private JasperReportsConfiguration jConfig;
    private int currentChartCustmizers = 0;

    public SelectCustomizerPage(JasperReportsConfiguration jConfig, String definitionKey, CustomizerPropertyExpressionsDTO dto, JRChartPlot selectedChartPlot) {
        super("customizerTypeSelection");
        this.jConfig = jConfig;
        this.tableInput = new ArrayList<CustomizerWidgetsDescriptor>(CustomizerDefinitionManager.getCustomizerDefinitions(jConfig));
        this.userDefinedEntry = new CustomizerWidgetsDescriptor(){

            @Override
            public boolean isPlotSupported(JRChartPlot plot) {
                return true;
            }
        };
        this.userDefinedEntry.setLabel(Messages.SelectCustomizerPage_customzierClassEntry);
        this.tableInput.add(this.userDefinedEntry);
        this.definitionKey = definitionKey;
        this.selectedChartPlot = selectedChartPlot;
        this.currentChartCustmizers = dto.getCustomizersNumber();
    }

    protected void createTableArea(Composite parent) {
        this.table = new TableViewer(parent, 67588);
        GridData tableData = new GridData(1808);
        this.table.getTable().setLayoutData((Object)tableData);
        this.table.setContentProvider((IContentProvider)new CompatibleContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new CustomizerLabelProvier());
        this.table.setInput(this.tableInput);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() != null) {
                    CustomizerWidgetsDescriptor selCustomizer = (CustomizerWidgetsDescriptor)((Object)selection.getFirstElement());
                    SelectCustomizerPage.this.valueSelection = new ChartCustomizerDefinition(selCustomizer, SelectCustomizerPage.this.definitionKey);
                }
                SelectCustomizerPage.this.validate();
            }
        });
    }

    protected void validate() {
        ISelection seletion = this.table.getSelection();
        if (seletion == null || seletion.isEmpty()) {
            this.setErrorMessage(Messages.SelectCustomizerPage_errorNoSelection);
        } else {
            this.setErrorMessage(null);
            CustomizerWidgetsDescriptor desc = (CustomizerWidgetsDescriptor)((Object)((StructuredSelection)seletion).getFirstElement());
            if (desc != this.userDefinedEntry && desc.getCustomizerClass() != null) {
                String fullClassName = desc.getCustomizerClass();
                try {
                    this.jConfig.getClassLoader().loadClass(fullClassName);
                }
                catch (Exception exception) {
                    String className = this.getClassName(fullClassName);
                    String baseMessage = Messages.SelectCustomizerPage_warningInvalidClass;
                    this.setMessage(MessageFormat.format(baseMessage, className), 2);
                    this.getContainer().updateButtons();
                    return;
                }
            }
            if (desc != this.userDefinedEntry) {
                this.setMessage(Messages.SelectCustomizerPage_pageMessageConfigurableCustomizer);
            } else if (this.currentChartCustmizers > 0) {
                this.setMessage(Messages.SelectCustomizerPage_pageMessageMultiCustomizers);
            } else {
                this.setMessage(Messages.SelectCustomizerPage_pageMessage);
            }
        }
        this.getContainer().updateButtons();
    }

    private String getClassName(String fullClassName) {
        int separatorIndex = fullClassName.lastIndexOf(46);
        if (separatorIndex != -1) {
            return fullClassName.substring(separatorIndex + 1);
        }
        return fullClassName;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.SelectCustomizerPage_pageTitle);
        this.setMessage(Messages.SelectCustomizerPage_pageMessage);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createTableArea(container);
        Composite comboContainer = new Composite(container, 0);
        GridData comboContainerData = new GridData();
        comboContainerData.horizontalAlignment = 0x1000000;
        comboContainer.setLayoutData((Object)comboContainerData);
        comboContainer.setLayout((Layout)new RowLayout());
        Label comboText = new Label(comboContainer, 0);
        comboText.setText(Messages.SelectCustomizerPage_comboLabel);
        this.showAllElements = new Combo(comboContainer, 8);
        this.showAllElements.setItems(new String[]{Messages.SelectCustomizerPage_comboEntryCompatible, Messages.SelectCustomizerPage_comboEntryAll});
        this.showAllElements.select(0);
        this.showAllElements.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCustomizerPage.this.table.refresh();
            }
        });
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
        }
    }

    public boolean isUsingCustomDefinition() {
        return this.valueSelection != null && this.valueSelection.getDescriptor() == this.userDefinedEntry;
    }

    public ChartCustomizerDefinition getSelectedDefinition() {
        return this.valueSelection;
    }

    public boolean isPageComplete() {
        return this.getSelectedDefinition() != null && this.getErrorMessage() == null;
    }

    public boolean canFlipToNextPage() {
        WidgetsDescriptor descriptor;
        boolean value = this.isPageComplete();
        if (value && (descriptor = this.getSelectedDefinition().getDescriptor()) != this.userDefinedEntry && !descriptor.hasWidgets()) {
            value = false;
        }
        return value;
    }

    public IWizardPage getNextPage() {
        if (this.isUsingCustomDefinition()) {
            CustomizerNewWizard parentWizard = (CustomizerNewWizard)this.getWizard();
            EditClassPage editClassPage = parentWizard.getEditClassPage();
            editClassPage.setRawClass("");
            return editClassPage;
        }
        CustomizerNewWizard parentWizard = (CustomizerNewWizard)this.getWizard();
        EditCustomizerPage editCustmizerPage = parentWizard.getEditCustomizerPage();
        editCustmizerPage.setEditedElement(this.getSelectedDefinition());
        return editCustmizerPage;
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_SELECT_CUSTOMIZER;
    }

    private class CompatibleContentProvider
    extends ListContentProvider {
        private CompatibleContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof List) {
                if (SelectCustomizerPage.this.showAllElements != null && !SelectCustomizerPage.this.showAllElements.isDisposed() && SelectCustomizerPage.this.showAllElements.getSelectionIndex() == 1) {
                    return ((List)inputElement).toArray();
                }
                ArrayList result = new ArrayList();
                for (Object element : (List)inputElement) {
                    CustomizerWidgetsDescriptor desc = (CustomizerWidgetsDescriptor)((Object)element);
                    if (!desc.isPlotSupported(SelectCustomizerPage.this.selectedChartPlot)) continue;
                    result.add(element);
                }
                return result.toArray();
            }
            return new Object[0];
        }
    }

    private class CustomizerLabelProvier
    extends ColumnLabelProvider
    implements ITableColorProvider {
        private CustomizerLabelProvier() {
        }

        public Color getForeground(Object element, int columnIndex) {
            CustomizerWidgetsDescriptor desc = (CustomizerWidgetsDescriptor)((Object)element);
            if (desc != SelectCustomizerPage.this.userDefinedEntry && desc.getCustomizerClass() != null) {
                String className = desc.getCustomizerClass();
                try {
                    SelectCustomizerPage.this.jConfig.getClassLoader().loadClass(className);
                }
                catch (Exception exception) {
                    return ColorConstants.orange;
                }
                catch (Error error) {
                    return ColorConstants.orange;
                }
            }
            return ColorConstants.black;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

