/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.widget;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.property.descriptor.ChartCustomizerDefinition;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.CustomizerEditWizard;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.CustomizerNewWizard;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.properties.view.SectionContainerComposite;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationWizardDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRChartPlot;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.SWTResourceManager;

public abstract class ChartCustomizerWidget {
    private Composite controlsContainer;
    private SectionContainerComposite container;
    private List<ChartCustomizerDefinition> selectedCustomizers;
    private TableViewer customizerTable;
    private CustomizerPropertyExpressionsDTO currentDTO = null;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private MChart selectedElement;
    private JasperReportsConfiguration jConfig;

    public ChartCustomizerWidget(Composite parent) {
        if (parent instanceof SectionContainerComposite) {
            this.controlsContainer = this.createSection(parent, "Chart Customizers", true);
            this.container = (SectionContainerComposite)parent;
        } else {
            this.controlsContainer = new Composite(parent, 0);
            this.controlsContainer.setLayoutData((Object)new GridData(1808));
            this.controlsContainer.setLayout((Layout)new GridLayout(1, false));
            this.container = null;
        }
        Composite proxyContainer = new Composite(this.controlsContainer, 0);
        GridLayout proxyContainerData = new GridLayout(2, false);
        proxyContainerData.horizontalSpacing = 0;
        proxyContainerData.verticalSpacing = 0;
        proxyContainerData.marginWidth = 0;
        proxyContainerData.marginHeight = 0;
        proxyContainer.setLayout((Layout)proxyContainerData);
        GridData gd = new GridData(768);
        proxyContainer.setLayoutData((Object)gd);
        this.buildTableArea(proxyContainer);
    }

    public void update(MChart selectedElement, CustomizerPropertyExpressionsDTO dto) {
        this.selectedElement = selectedElement;
        this.jConfig = selectedElement.getJasperConfiguration();
        this.currentDTO = dto;
        this.selectedCustomizers = this.currentDTO.getDefinedCustomizers();
        this.customizerTable.setInput(this.selectedCustomizers);
    }

    protected void createNewButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button newButton = new Button(parent, 8);
        newButton.setLayoutData((Object)buttonsData);
        newButton.setText(com.jaspersoft.studio.messages.Messages.common_add);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartCustomizerDefinition definition;
                String uniqueKey = ChartCustomizerWidget.this.getPropertyDTO().getUniqueKey();
                JRChartPlot selectedPlot = ChartCustomizerWidget.this.selectedElement.getValue().getPlot();
                CustomizerPropertyExpressionsDTO dto = new CustomizerPropertyExpressionsDTO(ChartCustomizerWidget.this.getPropertyDTO().clone(), ChartCustomizerWidget.this.getPropertyDTO().getPnode());
                CustomizerNewWizard wizard = new CustomizerNewWizard(uniqueKey, ChartCustomizerWidget.this.getExpressionContext(), dto, ChartCustomizerWidget.this.jConfig, selectedPlot);
                String title = Messages.ChartCustomizerWidget_selectDialogTitle;
                wizard.setWindowTitle(title);
                PersistentLocationWizardDialog dialog = new PersistentLocationWizardDialog(UIUtils.getShell(), (IWizard)wizard);
                dialog.setStoreSetting(false);
                dialog.setDefaultSize(650, 500);
                if (dialog.open() == 0 && (definition = wizard.getDefinition()) != null) {
                    ChartCustomizerWidget.this.selectedCustomizers.add(definition);
                    dto.addCustomizer(definition);
                    ChartCustomizerWidget.this.changePropertyOn("multiCustomizerProperty", dto, (APropertyNode)ChartCustomizerWidget.this.selectedElement);
                    ChartCustomizerWidget.this.currentDTO = dto;
                    ChartCustomizerWidget.this.customizerTable.refresh();
                }
            }
        });
    }

    protected Button createEditButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button editButton = new Button(parent, 8);
        editButton.setLayoutData((Object)buttonsData);
        editButton.setText(com.jaspersoft.studio.messages.Messages.common_edit);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartCustomizerWidget.this.editAction();
            }
        });
        editButton.setEnabled(false);
        return editButton;
    }

    protected Button createDeleteButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button deleteButton = new Button(parent, 8);
        deleteButton.setLayoutData((Object)buttonsData);
        deleteButton.setText(com.jaspersoft.studio.messages.Messages.common_remove);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizerPropertyExpressionsDTO dto = ChartCustomizerWidget.this.getPropertyDTO();
                StructuredSelection selection = (StructuredSelection)ChartCustomizerWidget.this.customizerTable.getSelection();
                if (selection != null && selection.size() > 0) {
                    ChartCustomizerDefinition definition = (ChartCustomizerDefinition)selection.getFirstElement();
                    ChartCustomizerWidget.this.selectedCustomizers.remove(definition);
                    dto.deleteCustomizer(definition, true);
                    ChartCustomizerWidget.this.changePropertyOn("multiCustomizerProperty", dto, (APropertyNode)ChartCustomizerWidget.this.selectedElement);
                }
                ChartCustomizerWidget.this.customizerTable.refresh();
            }
        });
        deleteButton.setEnabled(false);
        return deleteButton;
    }

    protected Button createUpButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button upButton = new Button(parent, 8);
        upButton.setLayoutData((Object)buttonsData);
        upButton.setText(com.jaspersoft.studio.messages.Messages.common_up);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)ChartCustomizerWidget.this.customizerTable.getSelection();
                if (selection != null && selection.size() > 0) {
                    ChartCustomizerDefinition definition = (ChartCustomizerDefinition)selection.getFirstElement();
                    int index = ChartCustomizerWidget.this.selectedCustomizers.indexOf(definition);
                    ChartCustomizerWidget.this.selectedCustomizers.remove(index);
                    ChartCustomizerWidget.this.selectedCustomizers.add(--index, definition);
                    ChartCustomizerWidget.this.rebuildPositionsList();
                    ChartCustomizerWidget.this.changePropertyOn("multiCustomizerProperty", ChartCustomizerWidget.this.getPropertyDTO(), (APropertyNode)ChartCustomizerWidget.this.selectedElement);
                    ChartCustomizerWidget.this.customizerTable.refresh();
                    ChartCustomizerWidget.this.updateButtonEnablemenet(definition);
                }
            }
        });
        upButton.setEnabled(false);
        return upButton;
    }

    protected Button createDownButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button downButton = new Button(parent, 8);
        downButton.setLayoutData((Object)buttonsData);
        downButton.setText(com.jaspersoft.studio.messages.Messages.common_down);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)ChartCustomizerWidget.this.customizerTable.getSelection();
                if (selection != null && selection.size() > 0) {
                    ChartCustomizerDefinition definition = (ChartCustomizerDefinition)selection.getFirstElement();
                    int index = ChartCustomizerWidget.this.selectedCustomizers.indexOf(definition);
                    ChartCustomizerWidget.this.selectedCustomizers.remove(index);
                    ChartCustomizerWidget.this.selectedCustomizers.add(++index, definition);
                    ChartCustomizerWidget.this.rebuildPositionsList();
                    ChartCustomizerWidget.this.changePropertyOn("multiCustomizerProperty", ChartCustomizerWidget.this.getPropertyDTO(), (APropertyNode)ChartCustomizerWidget.this.selectedElement);
                    ChartCustomizerWidget.this.customizerTable.refresh();
                    ChartCustomizerWidget.this.updateButtonEnablemenet(definition);
                }
            }
        });
        downButton.setEnabled(false);
        return downButton;
    }

    protected void rebuildPositionsList() {
        CustomizerPropertyExpressionsDTO dto = this.getPropertyDTO();
        for (ChartCustomizerDefinition definition : this.selectedCustomizers) {
            dto.deleteCustomizer(definition, false);
        }
        for (ChartCustomizerDefinition definition : this.selectedCustomizers) {
            dto.addProperty("net.sf.jasperreports.customizer.class." + definition.getKey(), definition.getCustomizerClass(), false, false);
        }
    }

    private void buildTableArea(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridData gd = new GridData(768);
        cmp.setLayoutData((Object)gd);
        GridLayout cmpLayout = new GridLayout(2, false);
        cmpLayout.horizontalSpacing = 3;
        cmpLayout.verticalSpacing = 0;
        cmpLayout.marginWidth = 0;
        cmpLayout.marginHeight = 0;
        cmp.setLayout((Layout)cmpLayout);
        Table tbl = new Table(cmp, 2052);
        tbl.setLinesVisible(false);
        tbl.setHeaderVisible(false);
        gd = new GridData(768);
        gd.heightHint = 150;
        tbl.setLayoutData((Object)gd);
        this.customizerTable = new TableViewer(tbl);
        this.customizerTable.setContentProvider((IContentProvider)new ListContentProvider());
        this.customizerTable.setLabelProvider((IBaseLabelProvider)new CustomizerLabelProvier());
        this.selectedCustomizers = new ArrayList<ChartCustomizerDefinition>();
        this.customizerTable.setInput(this.selectedCustomizers);
        Composite bcmp = new Composite(cmp, 0);
        GridLayout bcmpLayout = new GridLayout(1, false);
        bcmpLayout.horizontalSpacing = 0;
        bcmpLayout.verticalSpacing = 2;
        bcmpLayout.marginWidth = 0;
        bcmpLayout.marginHeight = 0;
        bcmp.setLayout((Layout)bcmpLayout);
        gd = new GridData(2);
        gd.widthHint = 100;
        bcmp.setLayoutData((Object)gd);
        this.createNewButton(bcmp);
        this.editButton = this.createEditButton(bcmp);
        this.deleteButton = this.createDeleteButton(bcmp);
        this.upButton = this.createUpButton(bcmp);
        this.downButton = this.createDownButton(bcmp);
        this.customizerTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    if (selection.size() > 0) {
                        ChartCustomizerDefinition definition = (ChartCustomizerDefinition)selection.getFirstElement();
                        ChartCustomizerWidget.this.updateButtonEnablemenet(definition);
                    } else {
                        ChartCustomizerWidget.this.updateButtonEnablemenet(null);
                    }
                }
                finally {
                    if (ChartCustomizerWidget.this.container != null) {
                        ChartCustomizerWidget.this.container.refreshPageComposite();
                    }
                }
            }
        });
        this.customizerTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChartCustomizerWidget.this.editAction();
            }
        });
    }

    protected void updateButtonEnablemenet(ChartCustomizerDefinition definition) {
        if (definition == null) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            if (!definition.isOnlyClass() && !definition.getDescriptor().hasWidgets()) {
                this.editButton.setEnabled(false);
            } else {
                this.editButton.setEnabled(true);
            }
            this.deleteButton.setEnabled(true);
            int selectionIndex = this.selectedCustomizers.indexOf(definition);
            this.upButton.setEnabled(selectionIndex > 0);
            this.downButton.setEnabled(selectionIndex < this.selectedCustomizers.size() - 1);
        }
    }

    protected void editAction() {
        StructuredSelection selection = (StructuredSelection)this.customizerTable.getSelection();
        if (!selection.isEmpty()) {
            ChartCustomizerDefinition definition;
            ChartCustomizerDefinition editElement = (ChartCustomizerDefinition)selection.getFirstElement();
            if (!editElement.isOnlyClass() && !editElement.getDescriptor().hasWidgets()) {
                return;
            }
            CustomizerPropertyExpressionsDTO dto = new CustomizerPropertyExpressionsDTO(this.getPropertyDTO().clone(), this.getPropertyDTO().getPnode());
            CustomizerEditWizard wizard = new CustomizerEditWizard(editElement, this.getExpressionContext(), dto, this.jConfig);
            PersistentLocationWizardDialog dialog = new PersistentLocationWizardDialog(UIUtils.getShell(), (IWizard)wizard);
            String title = Messages.ChartCustomizerWidget_editDialogTitle;
            wizard.setWindowTitle(title);
            dialog.setStoreSetting(false);
            dialog.setDefaultSize(650, 500);
            if (dialog.open() == 0 && (definition = wizard.getDefinition()) != null) {
                dto.updateCustomizerClass(definition);
                this.changePropertyOn("multiCustomizerProperty", dto, (APropertyNode)this.selectedElement);
                this.currentDTO = dto;
                this.selectedCustomizers = this.getPropertyDTO().getDefinedCustomizers();
                this.customizerTable.setInput(this.selectedCustomizers);
            }
        }
    }

    public Control getControl() {
        return this.controlsContainer;
    }

    private ExpressionContext getExpressionContext() {
        return ModelUtils.getElementExpressionContext(null, (ANode)this.selectedElement);
    }

    public CustomizerPropertyExpressionsDTO getPropertyDTO() {
        return this.currentDTO;
    }

    protected Composite createSection(Composite parent, String text, boolean expandable) {
        int style = 64;
        if (expandable) {
            style |= 4;
        }
        Section section = new Section(parent, style);
        section.titleBarTextMarginWidth = 0;
        section.setFont(SWTResourceManager.getBoldFont((Font)section.getFont()));
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
            section.setLayoutData((Object)gd);
        }
        section.setText(text);
        section.setSeparatorControl((Control)new Label((Composite)section, 258));
        Composite cmp = new Composite((Composite)section, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 4;
        layout.marginWidth = 2;
        cmp.setLayout((Layout)layout);
        section.setClient((Control)cmp);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (ChartCustomizerWidget.this.container != null) {
                    ChartCustomizerWidget.this.container.refreshPageComposite();
                }
            }
        });
        return cmp;
    }

    public abstract void changePropertyOn(String var1, CustomizerPropertyExpressionsDTO var2, APropertyNode var3);

    private class CustomizerLabelProvier
    extends ColumnLabelProvider
    implements ITableColorProvider {
        private CustomizerLabelProvier() {
        }

        public Color getForeground(Object element, int columnIndex) {
            return ColorConstants.black;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

