/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chartspider.model;

import com.jaspersoft.studio.components.chart.ChartNodeIconDescriptor;
import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.model.text.MFontUtil;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.FontPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.DoublePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.EdgePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.FloatPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.SpinnerPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.components.charts.ChartDataset;
import net.sf.jasperreports.components.charts.ChartPlot;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.StandardChartSettings;
import net.sf.jasperreports.components.spiderchart.StandardSpiderDataset;
import net.sf.jasperreports.components.spiderchart.StandardSpiderPlot;
import net.sf.jasperreports.components.spiderchart.type.SpiderRotationEnum;
import net.sf.jasperreports.components.spiderchart.type.TableOrderEnum;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MSpiderChart
extends MGraphicElement
implements IDatasetContainer {
    public static final long serialVersionUID = 10200L;
    private IPropertyDescriptor[] descriptors;
    private MHyperLink mHyperLink;
    private static IIconDescriptor iconDescriptor;
    private MFont tFont;
    private MFont stFont;
    private MFont lFont;
    private MFont plFont;
    private RComboBoxPropertyDescriptor evaluationGroupNameD;
    private static EdgePropertyDescriptor titlePositionD;
    private static EdgePropertyDescriptor legendPositionD;
    private static NamedEnumPropertyDescriptor<EvaluationTimeEnum> evaluationTimeD;
    private static NamedEnumPropertyDescriptor<SpiderRotationEnum> rotation;
    private static NamedEnumPropertyDescriptor<TableOrderEnum> tableOrder;

    public MSpiderChart() {
    }

    public MSpiderChart(ANode parent, JRDesignComponentElement jrObject, int newIndex) {
        super(parent, (JRDesignElement)jrObject, newIndex);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new ChartNodeIconDescriptor("spiderchart");
        }
        return iconDescriptor;
    }

    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MSpiderChart.getIconDescriptor().getTitle() : p;
    }

    public ImageDescriptor getImagePath() {
        return MSpiderChart.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MSpiderChart.getIconDescriptor().getToolTip();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        titlePositionD = new EdgePropertyDescriptor((Object)"titlePosition", Messages.MChart_title_position, NullEnum.NULL);
        titlePositionD.setDescription(Messages.MChart_title_position_description);
        desc.add((IPropertyDescriptor)titlePositionD);
        legendPositionD = new EdgePropertyDescriptor((Object)"legendPosition", Messages.MChart_legend_position, NullEnum.NULL);
        legendPositionD.setDescription(Messages.MChart_legend_position_description);
        desc.add((IPropertyDescriptor)legendPositionD);
        ColorPropertyDescriptor titleColorD = new ColorPropertyDescriptor((Object)"titleColor", Messages.MChart_title_color, NullEnum.INHERITED);
        titleColorD.setDescription(Messages.MChart_title_color_description);
        desc.add((IPropertyDescriptor)titleColorD);
        JRExpressionPropertyDescriptor titleExprD = new JRExpressionPropertyDescriptor((Object)"titleExpression", Messages.MChart_title_expression);
        titleExprD.setDescription(Messages.MChart_title_expression_description);
        desc.add((IPropertyDescriptor)titleExprD);
        ColorPropertyDescriptor subtitleColorD = new ColorPropertyDescriptor((Object)"subtitleColor", Messages.MChart_subtitle_color, NullEnum.INHERITED);
        subtitleColorD.setDescription(Messages.MChart_subtitle_color_description);
        desc.add((IPropertyDescriptor)subtitleColorD);
        JRExpressionPropertyDescriptor subtitleExprD = new JRExpressionPropertyDescriptor((Object)"subtitleExpression", Messages.MChart_subtitle_expression);
        subtitleExprD.setDescription(Messages.MChart_subtitle_expression_description);
        desc.add((IPropertyDescriptor)subtitleExprD);
        ColorPropertyDescriptor legendColorD = new ColorPropertyDescriptor((Object)"legendColor", Messages.MChart_legend_color, NullEnum.INHERITED);
        legendColorD.setDescription(Messages.MChart_legend_color_description);
        desc.add((IPropertyDescriptor)legendColorD);
        ColorPropertyDescriptor legendBackColorD = new ColorPropertyDescriptor((Object)"legendBackgroundColor", Messages.MChart_legend_background_color, NullEnum.INHERITED);
        legendBackColorD.setDescription(Messages.MChart_legend_background_color_description);
        desc.add((IPropertyDescriptor)legendBackColorD);
        ClassTypePropertyDescriptor classD = new ClassTypePropertyDescriptor((Object)"customizerClass", Messages.MChart_customizer_class);
        classD.setDescription(Messages.MChart_customizer_class_description);
        desc.add((IPropertyDescriptor)classD);
        CheckBoxPropertyDescriptor showLegendD = new CheckBoxPropertyDescriptor((Object)"showLegend", Messages.MChart_show_legend, NullEnum.NULL);
        showLegendD.setDescription(Messages.MChart_show_legend_description);
        desc.add((IPropertyDescriptor)showLegendD);
        RWComboBoxPropertyDescriptor rendererTypeD = new RWComboBoxPropertyDescriptor((Object)"renderType", Messages.MChart_renderer_type, new String[]{"", "draw", "image", "svg"}, NullEnum.NULL);
        rendererTypeD.setDescription(Messages.MChart_renderer_type_description);
        desc.add((IPropertyDescriptor)rendererTypeD);
        FontPropertyDescriptor titleFontD = new FontPropertyDescriptor((Object)"titleFont", Messages.MChart_title_font);
        titleFontD.setDescription(Messages.MChart_title_font_description);
        desc.add((IPropertyDescriptor)titleFontD);
        FontPropertyDescriptor subtitleFontD = new FontPropertyDescriptor((Object)"subtitleFont", Messages.MChart_subtitle_font);
        subtitleFontD.setDescription(Messages.MChart_subtitle_font_description);
        desc.add((IPropertyDescriptor)subtitleFontD);
        FontPropertyDescriptor legendFontD = new FontPropertyDescriptor((Object)"legendFont", Messages.MChart_legend_font);
        legendFontD.setDescription(Messages.MChart_legend_font_description);
        desc.add((IPropertyDescriptor)legendFontD);
        evaluationTimeD = new NamedEnumPropertyDescriptor((Object)"evaluationTime", Messages.MChart_evaluation_time, (Enum)EvaluationTimeEnum.AUTO, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(Messages.MChart_evaluation_time_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        this.evaluationGroupNameD = new RComboBoxPropertyDescriptor((Object)"evaluationGroup", Messages.MChart_evaluation_group, new String[]{""});
        this.evaluationGroupNameD.setDescription(Messages.MChart_evaluation_group_description);
        desc.add((IPropertyDescriptor)this.evaluationGroupNameD);
        JRExpressionPropertyDescriptor anchorNameExp = new JRExpressionPropertyDescriptor((Object)"anchorNameExpression", com.jaspersoft.studio.messages.Messages.MTextField_anchorNameLabel);
        anchorNameExp.setDescription(com.jaspersoft.studio.messages.Messages.MTextField_anchorNameDescription);
        desc.add((IPropertyDescriptor)anchorNameExp);
        JRExpressionPropertyDescriptor bookmarkLevelExp = new JRExpressionPropertyDescriptor((Object)"bookmarkLevelExpression", com.jaspersoft.studio.messages.Messages.MTextField_bookmarkLevelExpression);
        bookmarkLevelExp.setDescription(com.jaspersoft.studio.messages.Messages.MTextField_bookmarkLevelExpressionDescription);
        desc.add((IPropertyDescriptor)bookmarkLevelExp);
        SpinnerPropertyDescriptor bookmarkLevel = new SpinnerPropertyDescriptor((Object)"bookmarkLevel", com.jaspersoft.studio.messages.Messages.MTextField_bookmarkLevelLabel);
        bookmarkLevel.setDescription(com.jaspersoft.studio.messages.Messages.MTextField_bookmarkLevelDescription);
        bookmarkLevel.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chart_bookmarkLevel"));
        desc.add((IPropertyDescriptor)bookmarkLevel);
        if (this.mHyperLink == null) {
            this.mHyperLink = new MHyperLink(null);
        }
        this.mHyperLink.createPropertyDescriptors(desc);
        ColorPropertyDescriptor axLineColorD = new ColorPropertyDescriptor((Object)"axisLineColor", Messages.MSpiderChart_axisLineColorTitle, NullEnum.INHERITED);
        axLineColorD.setDescription(Messages.MSpiderChart_axisLineColorDesc);
        desc.add((IPropertyDescriptor)axLineColorD);
        axLineColorD.setCategory(Messages.MChart_plot);
        FloatPropertyDescriptor axLineWidthD = new FloatPropertyDescriptor((Object)"axisLineWidth", Messages.MSpiderChart_axisLineWidthTitle);
        axLineWidthD.setBounds(0.0f, 9999999.0f);
        axLineWidthD.setDescription(Messages.MSpiderChart_axisLineWidthDescription);
        desc.add((IPropertyDescriptor)axLineWidthD);
        axLineWidthD.setCategory(Messages.MChart_plot);
        JRExpressionPropertyDescriptor maxValExpr = new JRExpressionPropertyDescriptor((Object)"maxValueExpression", Messages.MSpiderChart_maxValueExpTitle);
        maxValExpr.setDescription(Messages.MSpiderChart_maxValueExpDescription);
        desc.add((IPropertyDescriptor)maxValExpr);
        rotation = new NamedEnumPropertyDescriptor((Object)"rotation", Messages.MChart_title_position, (Enum)SpiderRotationEnum.CLOCKWISE, NullEnum.NULL);
        rotation.setDescription(Messages.MChart_title_position_description);
        desc.add((IPropertyDescriptor)rotation);
        tableOrder = new NamedEnumPropertyDescriptor((Object)"tableOrder", Messages.MSpiderChart_tableOrderTitle, (Enum)TableOrderEnum.BY_ROW, NullEnum.NULL);
        tableOrder.setDescription(Messages.MSpiderChart_tableOrderTitledescription);
        desc.add((IPropertyDescriptor)tableOrder);
        CheckBoxPropertyDescriptor webFilled = new CheckBoxPropertyDescriptor((Object)"webFilled", Messages.MSpiderChart_webFilledTitle, NullEnum.NULL);
        webFilled.setDescription(Messages.MSpiderChart_webFilledDescription);
        desc.add((IPropertyDescriptor)webFilled);
        DoublePropertyDescriptor startAngle = new DoublePropertyDescriptor((Object)"startAngle", Messages.MSpiderChart_startAngleTitle);
        startAngle.setDescription(Messages.MSpiderChart_startAngleDescription);
        desc.add((IPropertyDescriptor)startAngle);
        DoublePropertyDescriptor headPercent = new DoublePropertyDescriptor((Object)"headPercent", Messages.MSpiderChart_headPercentTitle);
        headPercent.setDescription(Messages.MSpiderChart_headPercentDescription);
        headPercent.setBounds(0.0, 100.0);
        desc.add((IPropertyDescriptor)headPercent);
        DoublePropertyDescriptor interiorGap = new DoublePropertyDescriptor((Object)"interiorGap", Messages.MSpiderChart_interiorGapTitle);
        interiorGap.setDescription(Messages.MSpiderChart_interiorGapDescription);
        desc.add((IPropertyDescriptor)interiorGap);
        startAngle.setCategory(Messages.MChart_chart_title_category);
        headPercent.setCategory(Messages.MChart_chart_title_category);
        interiorGap.setCategory(Messages.MChart_chart_title_category);
        webFilled.setCategory(Messages.MChart_chart_title_category);
        rotation.setCategory(Messages.MChart_chart_title_category);
        tableOrder.setCategory(Messages.MChart_chart_title_category);
        maxValExpr.setCategory(Messages.MChart_chart_title_category);
        titleFontD.setCategory(Messages.MChart_chart_title_category);
        titleColorD.setCategory(Messages.MChart_chart_title_category);
        titlePositionD.setCategory(Messages.MChart_chart_title_category);
        titleExprD.setCategory(Messages.MChart_chart_title_category);
        subtitleFontD.setCategory(Messages.MChart_chart_subtitle_category);
        subtitleExprD.setCategory(Messages.MChart_chart_subtitle_category);
        subtitleColorD.setCategory(Messages.MChart_chart_subtitle_category);
        this.evaluationGroupNameD.setCategory(Messages.MChart_common_chart_properties_category);
        classD.setCategory(Messages.MChart_common_chart_properties_category);
        legendFontD.setCategory(Messages.MChart_chart_legend_category);
        legendBackColorD.setCategory(Messages.MChart_chart_legend_category);
        legendColorD.setCategory(Messages.MChart_chart_legend_category);
        legendPositionD.setCategory(Messages.MChart_chart_legend_category);
        showLegendD.setCategory(Messages.MChart_chart_legend_category);
        evaluationTimeD.setCategory(Messages.MChart_common_chart_properties_category);
        rendererTypeD.setCategory(Messages.MChart_common_chart_properties_category);
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("startAngle", new DefaultValue(null, false));
        defaultsMap.put("headPercent", new DefaultValue(null, false));
        defaultsMap.put("interiorGap", new DefaultValue(null, false));
        defaultsMap.put("webFilled", new DefaultValue(null, false));
        defaultsMap.put("rotation", new DefaultValue(null, false));
        defaultsMap.put("tableOrder", new DefaultValue(null, false));
        defaultsMap.put("customizerClass", new DefaultValue(null, false));
        defaultsMap.put("showLegend", new DefaultValue((Object)true, false));
        defaultsMap.put("titleColor", new DefaultValue(null, false));
        defaultsMap.put("subtitleColor", new DefaultValue(null, false));
        defaultsMap.put("legendColor", new DefaultValue(null, false));
        defaultsMap.put("legendBackgroundColor", new DefaultValue(null, false));
        defaultsMap.put("titleFont", new DefaultValue(null, false));
        defaultsMap.put("subtitleFont", new DefaultValue(null, false));
        defaultsMap.put("legendFont", new DefaultValue(null, false));
        defaultsMap.put("titlePosition", new DefaultValue(null, false));
        defaultsMap.put("legendPosition", new DefaultValue(null, false));
        defaultsMap.put("evaluationTime", new DefaultValue((Object)EvaluationTimeEnum.NOW, false));
        defaultsMap.put("axisLineColor", new DefaultValue(null, false));
        defaultsMap.put("axisLineWidth", new DefaultValue(null, false));
        defaultsMap.putAll(new MHyperLink(null).getDefaultsPropertiesMap());
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        SpiderChartComponent component = (SpiderChartComponent)jrElement.getComponent();
        StandardChartSettings cs = (StandardChartSettings)component.getChartSettings();
        if (id.equals("titlePosition")) {
            return titlePositionD.getIntValue((Enum)cs.getTitlePosition());
        }
        if (id.equals("legendPosition")) {
            return legendPositionD.getIntValue((Enum)cs.getLegendPosition());
        }
        if (id.equals("renderType")) {
            return cs.getRenderType();
        }
        if (id.equals("hyperlinkParameters")) {
            return cs.getHyperlinkParameters();
        }
        if (id.equals("titleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)cs.getTitleColor());
        }
        if (id.equals("subtitleColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)cs.getSubtitleColor());
        }
        if (id.equals("legendColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)cs.getLegendColor());
        }
        if (id.equals("legendBackgroundColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)cs.getLegendBackgroundColor());
        }
        if (id.equals("showLegend")) {
            return cs.getShowLegend();
        }
        if (id.equals("customizerClass")) {
            return cs.getCustomizerClass();
        }
        if (id.equals("linkTarget")) {
            return cs.getLinkTarget();
        }
        if (id.equals("hyperlinkType")) {
            return cs.getLinkType();
        }
        if (id.equals("hyperlinkAnchorExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getHyperlinkAnchorExpression());
        }
        if (id.equals("hyperlinkPageExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getHyperlinkPageExpression());
        }
        if (id.equals("hyperlinkReferenceExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getHyperlinkReferenceExpression());
        }
        if (id.equals("hyperlinkTooltipExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getHyperlinkTooltipExpression());
        }
        if (id.equals("hyperlinkWhenExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getHyperlinkWhenExpression());
        }
        if (id.equals("anchorNameExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getAnchorNameExpression());
        }
        if (id.equals("bookmarkLevelExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getBookmarkLevelExpression());
        }
        if (id.equals("bookmarkLevel")) {
            return cs.getBookmarkLevel();
        }
        if (id.equals("titleFont")) {
            this.tFont = MFontUtil.getMFont((MFont)this.tFont, (JRFont)cs.getTitleFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.tFont;
        }
        if (id.equals("subtitleFont")) {
            this.stFont = MFontUtil.getMFont((MFont)this.stFont, (JRFont)cs.getSubtitleFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.stFont;
        }
        if (id.equals("legendFont")) {
            this.lFont = MFontUtil.getMFont((MFont)this.lFont, (JRFont)cs.getLegendFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.lFont;
        }
        if (id.equals("titleExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getTitleExpression());
        }
        if (id.equals("subtitleExpression")) {
            return ExprUtil.getExpression((JRExpression)cs.getSubtitleExpression());
        }
        if (id.equals("evaluationTime")) {
            return component.getEvaluationTime();
        }
        if (id.equals("evaluationGroup")) {
            return component.getEvaluationGroup();
        }
        StandardSpiderPlot sp = (StandardSpiderPlot)component.getPlot();
        if (id.equals("axisLineColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)sp.getAxisLineColor());
        }
        if (id.equals("axisLineWidth")) {
            return sp.getAxisLineWidth();
        }
        if (id.equals("labelColor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)sp.getLabelColor());
        }
        if (id.equals("labelGap")) {
            return sp.getLabelGap();
        }
        if (id.equals("labelFont")) {
            this.plFont = MFontUtil.getMFont((MFont)this.plFont, (JRFont)sp.getLabelFont(), (JRStyle)jrElement.getStyle(), (APropertyNode)this);
            return this.plFont;
        }
        if (id.equals("maxValueExpression")) {
            return ExprUtil.getExpression((JRExpression)sp.getMaxValueExpression());
        }
        if (id.equals("rotation")) {
            return rotation.getIntValue((Enum)sp.getRotation());
        }
        if (id.equals("tableOrder")) {
            return tableOrder.getIntValue((Enum)sp.getTableOrder());
        }
        if (id.equals("webFilled")) {
            return sp.getWebFilled();
        }
        if (id.equals("startAngle")) {
            return sp.getStartAngle();
        }
        if (id.equals("headPercent")) {
            return sp.getHeadPercent();
        }
        if (id.equals("interiorGap")) {
            return sp.getInteriorGap();
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        SpiderChartComponent component = (SpiderChartComponent)jrElement.getComponent();
        StandardChartSettings cs = (StandardChartSettings)component.getChartSettings();
        StandardSpiderPlot cp = (StandardSpiderPlot)component.getPlot();
        if (id.equals("axisLineColor")) {
            if (value instanceof AlfaRGB) {
                cp.setAxisLineColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("axisLineWidth")) {
            cp.setAxisLineWidth((Float)value);
        } else if (id.equals("labelColor")) {
            if (value instanceof AlfaRGB) {
                cp.setLabelColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("labelGap")) {
            cp.setLabelGap((Double)value);
        } else if (id.equals("labelFont")) {
            cp.setLabelFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("maxValueExpression")) {
            cp.setMaxValueExpression(ExprUtil.setValues((JRExpression)cp.getMaxValueExpression(), (Object)value));
        } else if (id.equals("rotation")) {
            int pos = (Integer)value;
            if (pos == 0) {
                cp.setRotation(null);
            } else {
                cp.setRotation(SpiderRotationEnum.values()[pos - 1]);
            }
        } else if (id.equals("tableOrder")) {
            int pos = (Integer)value;
            if (pos == 0) {
                cp.setTableOrder(null);
            } else {
                cp.setTableOrder(TableOrderEnum.values()[pos - 1]);
            }
        } else if (id.equals("webFilled")) {
            cp.setWebFilled((Boolean)value);
        } else if (id.equals("startAngle")) {
            cp.setStartAngle((Double)value);
        } else if (id.equals("interiorGap")) {
            cp.setInteriorGap((Double)value);
        } else if (id.equals("headPercent")) {
            cp.setHeadPercent((Double)value);
        } else if (id.equals("titleFont")) {
            cs.setTitleFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("subtitleFont")) {
            cs.setSubtitleFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("legendFont")) {
            cs.setLegendFont(MFontUtil.setMFont((Object)value));
        } else if (id.equals("titlePosition")) {
            cs.setTitlePosition((EdgeEnum)titlePositionD.getEnumValue(value));
        } else if (id.equals("legendPosition")) {
            cs.setLegendPosition((EdgeEnum)legendPositionD.getEnumValue(value));
        } else if (id.equals("showLegend")) {
            cs.setShowLegend((Boolean)value);
        } else if (id.equals("renderType")) {
            value = Misc.nullValue((String)((String)value));
            cs.setRenderType((String)value);
        } else if (id.equals("titleColor")) {
            if (value instanceof AlfaRGB) {
                cs.setTitleColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("subtitleColor")) {
            if (value instanceof AlfaRGB) {
                cs.setSubtitleColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("legendColor")) {
            if (value instanceof AlfaRGB) {
                cs.setLegendColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("legendBackgroundColor")) {
            if (value instanceof AlfaRGB) {
                cs.setLegendBackgroundColor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("customizerClass")) {
            value = Misc.nullValue((String)((String)value));
            cs.setCustomizerClass((String)value);
        } else if (id.equals("titleExpression")) {
            cs.setTitleExpression(ExprUtil.setValues((JRExpression)cs.getTitleExpression(), (Object)value));
        } else if (id.equals("subtitleExpression")) {
            cs.setSubtitleExpression(ExprUtil.setValues((JRExpression)cs.getSubtitleExpression(), (Object)value));
        } else if (id.equals("anchorNameExpression")) {
            cs.setAnchorNameExpression(ExprUtil.setValues((JRExpression)cs.getAnchorNameExpression(), (Object)value));
        } else if (id.equals("bookmarkLevelExpression")) {
            cs.setBookmarkLevelExpression(ExprUtil.setValues((JRExpression)cs.getBookmarkLevelExpression(), (Object)value));
        } else if (id.equals("bookmarkLevel")) {
            cs.setBookmarkLevel(value != null ? Integer.parseInt(value.toString()) : 0);
        } else if (id.equals("linkTarget")) {
            cs.setLinkTarget((String)value);
        } else if (id.equals("hyperlinkType")) {
            cs.setLinkType((String)value);
        } else if (id.equals("hyperlinkAnchorExpression")) {
            cs.setHyperlinkAnchorExpression(ExprUtil.setValues((JRExpression)cs.getHyperlinkAnchorExpression(), (Object)value));
        } else if (id.equals("hyperlinkPageExpression")) {
            cs.setHyperlinkPageExpression(ExprUtil.setValues((JRExpression)cs.getHyperlinkPageExpression(), (Object)value));
        } else if (id.equals("hyperlinkReferenceExpression")) {
            cs.setHyperlinkReferenceExpression(ExprUtil.setValues((JRExpression)cs.getHyperlinkReferenceExpression(), (Object)value));
        } else if (id.equals("hyperlinkTooltipExpression")) {
            cs.setHyperlinkTooltipExpression(ExprUtil.setValues((JRExpression)cs.getHyperlinkTooltipExpression(), (Object)value));
        } else if (id.equals("hyperlinkWhenExpression")) {
            cs.setHyperlinkWhenExpression(ExprUtil.setValues((JRExpression)cs.getHyperlinkWhenExpression(), (Object)value));
        } else if (id.equals("hyperlinkParameters")) {
            int n;
            int n2;
            JRHyperlinkParameter[] jRHyperlinkParameterArray;
            JRHyperlinkParameter[] oldParameters = cs.getHyperlinkParameters();
            JRHyperlinkParameter[] newParameters = (JRHyperlinkParameter[])value;
            if (oldParameters != null) {
                jRHyperlinkParameterArray = oldParameters;
                n2 = oldParameters.length;
                n = 0;
                while (n < n2) {
                    JRHyperlinkParameter prm = jRHyperlinkParameterArray[n];
                    cs.removeHyperlinkParameter(prm);
                    ++n;
                }
            }
            jRHyperlinkParameterArray = newParameters;
            n2 = newParameters.length;
            n = 0;
            while (n < n2) {
                JRHyperlinkParameter param = jRHyperlinkParameterArray[n];
                cs.addHyperlinkParameter(param);
                ++n;
            }
        } else if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            component.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                component.setEvaluationGroup(null);
            }
        } else if (id.equals("evaluationGroup")) {
            component.setEvaluationGroup(ModelUtils.getGroupNameForProperty((Object)value));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    protected void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evaluationGroupNameD != null) {
            this.evaluationGroupNameD.setItems(items);
        }
    }

    public void setValue(Object value) {
        SpiderChartComponent obj;
        if (this.getValue() != null) {
            obj = this.getComponent();
            if (obj instanceof JRChangeEventsSupport) {
                obj.getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            ((StandardChartSettings)obj.getChartSettings()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            ((StandardSpiderPlot)obj.getPlot()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (value != null) {
            obj = this.getComponent(value);
            if (value instanceof JRChangeEventsSupport) {
                obj.getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            ((StandardChartSettings)obj.getChartSettings()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            ((StandardSpiderPlot)obj.getPlot()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        super.setValue(value);
    }

    private SpiderChartComponent getComponent() {
        return this.getComponent(this.getValue());
    }

    private SpiderChartComponent getComponent(Object value) {
        if (value != null) {
            JRDesignComponentElement jrElement = (JRDesignComponentElement)value;
            return (SpiderChartComponent)jrElement.getComponent();
        }
        return null;
    }

    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(((Object)((Object)this)).getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(((Object)((Object)this)).getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    public JRDesignComponentElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignComponentElement jrcomponent = new JRDesignComponentElement((JRDefaultStyleProvider)jasperDesign);
        jrcomponent.setWidth(this.getDefaultWidth());
        jrcomponent.setHeight(this.getDefaultHeight());
        SpiderChartComponent component = new SpiderChartComponent();
        component.setChartSettings((ChartSettings)new StandardChartSettings());
        component.setDataset((ChartDataset)new StandardSpiderDataset());
        StandardSpiderPlot spiderPlot = new StandardSpiderPlot();
        spiderPlot.setWebFilled(Boolean.valueOf(true));
        component.setPlot((ChartPlot)spiderPlot);
        jrcomponent.setComponent((Component)component);
        jrcomponent.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "sc", "spiderChart"));
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(((Object)((Object)this)).getClass(), (JRElement)jrcomponent);
        }
        return jrcomponent;
    }

    public List<MDatasetRun> getDatasetRunList() {
        JRDesignComponentElement jrElement;
        SpiderChartComponent component;
        if (this.getValue() != null && (component = (SpiderChartComponent)(jrElement = (JRDesignComponentElement)this.getValue()).getComponent()) != null && component.getDataset() != null) {
            ArrayList<MDatasetRun> datasetList = new ArrayList<MDatasetRun>();
            MDatasetRun mDatasetRun = new MDatasetRun(component.getDataset().getDatasetRun(), this.getJasperDesign());
            mDatasetRun.setJasperConfiguration(this.getJasperConfiguration());
            datasetList.add(mDatasetRun);
            return datasetList;
        }
        return null;
    }

    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignComponentElement jrSourceElement = (JRDesignComponentElement)this.getValue();
        SpiderChartComponent jrSourceComponent = (SpiderChartComponent)jrSourceElement.getComponent();
        StandardChartSettings jrSourceSetting = (StandardChartSettings)jrSourceComponent.getChartSettings();
        StandardSpiderPlot jrSourcePlot = (StandardSpiderPlot)jrSourceComponent.getPlot();
        JRDesignComponentElement jrTargetElement = (JRDesignComponentElement)this.getValue();
        SpiderChartComponent jrTargetComponent = (SpiderChartComponent)jrTargetElement.getComponent();
        StandardChartSettings jrTargetSetting = (StandardChartSettings)jrTargetComponent.getChartSettings();
        StandardSpiderPlot jrTargetPlot = (StandardSpiderPlot)jrTargetComponent.getPlot();
        jrTargetPlot.setAxisLineColor(this.getColorClone(jrSourcePlot.getAxisLineColor()));
        jrTargetPlot.setAxisLineWidth(jrSourcePlot.getAxisLineWidth());
        jrTargetPlot.setLabelColor(this.getColorClone(jrSourcePlot.getLabelColor()));
        jrTargetPlot.setLabelGap(jrSourcePlot.getLabelGap());
        jrTargetPlot.setLabelFont(this.getFontClone(jrSourcePlot.getLabelFont()));
        jrTargetPlot.setRotation(jrSourcePlot.getRotation());
        jrTargetPlot.setTableOrder(jrSourcePlot.getTableOrder());
        jrTargetPlot.setWebFilled(jrSourcePlot.getWebFilled());
        jrTargetPlot.setStartAngle(jrSourcePlot.getStartAngle());
        jrTargetPlot.setInteriorGap(jrSourcePlot.getInteriorGap());
        jrTargetPlot.setHeadPercent(jrSourcePlot.getHeadPercent());
        jrTargetSetting.setTitleFont(this.getFontClone(jrSourceSetting.getTitleFont()));
        jrTargetSetting.setSubtitleFont(this.getFontClone(jrSourceSetting.getSubtitleFont()));
        jrTargetSetting.setLegendFont(this.getFontClone(jrSourceSetting.getLegendFont()));
        jrTargetSetting.setTitlePosition(jrSourceSetting.getTitlePosition());
        jrTargetSetting.setLegendPosition(jrSourceSetting.getLegendPosition());
        jrTargetSetting.setShowLegend(jrSourceSetting.getShowLegend());
        jrTargetSetting.setRenderType(jrSourceSetting.getRenderType());
        jrTargetSetting.setTitleColor(this.getColorClone(jrSourceSetting.getTitleColor()));
        jrTargetSetting.setLegendColor(this.getColorClone(jrSourceSetting.getLegendColor()));
        jrTargetSetting.setSubtitleColor(this.getColorClone(jrSourceSetting.getSubtitleColor()));
        jrTargetSetting.setLegendBackgroundColor(this.getColorClone(jrSourceSetting.getLegendBackgroundColor()));
    }
}

