/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chartspider.wizard.action;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chartspider.model.MSpiderChart;
import com.jaspersoft.studio.components.chartspider.model.command.EditSpiderChartCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ChartSpiderWizardAction
extends ACachedSelectionAction {
    public static final String ID = "chartspidereditaction";

    public ChartSpiderWizardAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    public Command createCommand() {
        List spiderCharts = this.editor.getSelectionCache().getSelectionModelForType(MSpiderChart.class);
        if (spiderCharts.isEmpty()) {
            return null;
        }
        for (Object spiderChart : spiderCharts) {
            MSpiderChart node = (MSpiderChart)((Object)spiderChart);
            ANode parent = node.getParent();
            if (parent instanceof MFrame) {
                return new EditSpiderChartCommand((MFrame)parent, node);
            }
            if (parent instanceof MBand) {
                return new EditSpiderChartCommand((MBand)parent, node);
            }
            if (!(parent instanceof MElementGroup)) continue;
            return new EditSpiderChartCommand((MElementGroup)parent, node);
        }
        return null;
    }

    public void run() {
        this.execute(this.command);
    }

    protected void init() {
        super.init();
        this.setText(Messages.commoneditAction);
        this.setToolTipText(Messages.commoneditToolTip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }
}

