/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab;

import com.jaspersoft.studio.components.crosstab.CrosstabCell;
import com.jaspersoft.studio.components.crosstab.Guide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.CrosstabColumnCell;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import org.eclipse.draw2d.geometry.Rectangle;

public class CrosstabMatrix {
    private List<Guide> hGuides = new ArrayList<Guide>();
    private List<Guide> vGuides = new ArrayList<Guide>();
    private Map<CrosstabCell, Rectangle> map = new HashMap<CrosstabCell, Rectangle>();

    public Map<CrosstabCell, Rectangle> getCells() {
        return this.map;
    }

    public CrosstabCell getCrosstabCell(CrosstabCell colcel) {
        for (CrosstabCell cc : this.map.keySet()) {
            if (!cc.equals(colcel)) continue;
            return cc;
        }
        return null;
    }

    public Rectangle getBounds(CrosstabCell cc) {
        Rectangle r = this.map.get(cc);
        if (r != null) {
            return r.getCopy();
        }
        return null;
    }

    private void fixCells() {
        for (CrosstabCell cc : this.map.keySet()) {
            this.map.put(cc, cc.getBounds());
        }
    }

    public void fill(JRDesignCrosstab crosstab) {
        Guide south;
        this.hGuides.clear();
        this.vGuides.clear();
        this.map.clear();
        Guide north = new Guide(0);
        this.hGuides.add(north);
        north = south = this.fillTitleCellH(north, this.addNext(north, this.hGuides), crosstab);
        south = this.fillHeaderCellH(north, this.addNext(north, this.hGuides), crosstab);
        this.fillColumnGroupH(north, south, crosstab);
        Guide gnorth = south;
        this.fillRowGroupH(south, this.addNext(south, this.hGuides), crosstab);
        this.fillDetailsH(gnorth, crosstab);
        this.fillVertical(crosstab);
        this.fixCells();
    }

    public void fillVertical(JRDesignCrosstab crosstab) {
        Guide west = new Guide(0);
        this.vGuides.add(west);
        Guide gwest = null;
        Guide east = this.fillTitleCellV(west, this.addNext(west, this.vGuides), crosstab);
        Guide heast = this.fillHeaderCellV(west, this.addNext(west, this.vGuides), crosstab);
        this.fillRowGroupV(west, heast, crosstab);
        gwest = heast;
        this.fillColumnGroupV(heast, east, crosstab);
        this.fillDetailsV(gwest, crosstab);
        if (crosstab.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.mirrorV();
        }
    }

    public void mirrorV() {
        int maxy = this.vGuides.get(this.vGuides.size() - 1).getY();
        Collections.reverse(this.vGuides);
        for (Guide g : this.vGuides) {
            g.setY(maxy - g.getY());
            g.mirrorV();
        }
    }

    public Guide fillRowGroupV(Guide west, Guide east, JRDesignCrosstab crosstab) {
        JRCrosstabRowGroup[] rows = crosstab.getRowGroups();
        int i = 0;
        while (i < rows.length) {
            JRCrosstabRowGroup cg = rows[i];
            CrosstabCell cc = null;
            if (cg.hasTotal()) {
                cc = this.addCell4ColTotal(west, east, cg);
            }
            cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)3);
            west.addEast(cc);
            Guide teast = null;
            teast = i == rows.length - 1 ? east : this.addNext(west, this.vGuides);
            teast.addWest(cc);
            teast.setX(west, (JRCellContents)cc.cell);
            west = teast;
            ++i;
        }
        return east;
    }

    public Guide fillColumnGroupV(Guide west, Guide east, JRDesignCrosstab crosstab) {
        JRCrosstabColumnGroup[] cols = crosstab.getColumnGroups();
        CrosstabCell hcc = this.createCell((JRDesignCellContents)crosstab.getHeaderCell(), (byte)1);
        int i = 0;
        while (i < cols.length) {
            Guide teast;
            JRCrosstabColumnGroup cg = cols[i];
            CrosstabCell cc = this.createCell((JRDesignCellContents)cg.getCrosstabHeader(), (byte)8);
            cc.setEast(hcc.getEast());
            cc.setWest(hcc.getWest());
            if (cg.getTotalPositionValue() == CrosstabTotalPositionEnum.START) {
                cc = this.createCell((JRDesignCellContents)cg.getTotalHeader(), (byte)6);
                west.addEast(cc);
                teast = cg.hasTotal() ? this.addNext(west, this.vGuides) : east;
                teast.addWest(cc);
                teast.setX(west, (JRCellContents)cc.cell);
                cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)5);
                teast.addEast(cc);
                east.addWest(cc);
                east.setX(teast, (JRCellContents)cc.cell);
                west = teast;
            } else if (cg.getTotalPositionValue() == CrosstabTotalPositionEnum.END) {
                cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)5);
                west.addEast(cc);
                teast = cg.hasTotal() ? this.addNext(west, this.vGuides) : east;
                teast.addWest(cc);
                teast.setX(west, (JRCellContents)cc.cell);
                cc = this.createCell((JRDesignCellContents)cg.getTotalHeader(), (byte)6);
                teast.addEast(cc);
                east.addWest(cc);
                east.setX(teast, (JRCellContents)cc.cell);
                east = teast;
            } else {
                cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)5);
                west.addEast(cc);
                east.addWest(cc);
                east.setX(west, (JRCellContents)cc.cell);
            }
            ++i;
        }
        return east;
    }

    public void fillDetailsV(Guide gwest, JRDesignCrosstab crosstab) {
        block6: {
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells == null) break block6;
            int i = cells.length - 1;
            while (i >= 0) {
                JRCrosstabCell[] rowcells = cells[i];
                Guide west = gwest;
                Guide east = this.vGuides.get(this.vGuides.size() - 1);
                List cols = crosstab.getColumnGroupsList();
                int k = 0;
                while (k < cols.size()) {
                    block10: {
                        boolean last;
                        block8: {
                            block9: {
                                JRCrosstabColumnGroup cg;
                                block7: {
                                    cg = (JRCrosstabColumnGroup)cols.get(k);
                                    boolean bl = last = k == cols.size() - 1;
                                    if (cg.getTotalPositionValue() != CrosstabTotalPositionEnum.END) break block7;
                                    Guide twest = this.vGuides.get(this.vGuides.indexOf(east) - 1);
                                    this.addDetailCellV(rowcells, twest, east, cg.getName());
                                    east = twest;
                                    break block8;
                                }
                                if (cg.getTotalPositionValue() != CrosstabTotalPositionEnum.START) break block9;
                                Guide teast = this.vGuides.get(this.vGuides.indexOf(west) + 1);
                                this.addDetailCellV(rowcells, west, teast, cg.getName());
                                west = teast;
                                break block8;
                            }
                            if (!last) break block10;
                        }
                        if (last) {
                            this.addDetailCellV(rowcells, west, east, null);
                        }
                    }
                    ++k;
                }
                --i;
            }
        }
    }

    private void addDetailCellV(JRCrosstabCell[] rowcells, Guide west, Guide east, String name) {
        int j = 0;
        while (j < rowcells.length) {
            String ctg;
            JRCrosstabCell rc = rowcells[j];
            if (rc != null && ((ctg = rc.getColumnTotalGroup()) != null && ctg.equals(name) || ctg == null && name == null)) {
                CrosstabCell cc = this.createCell((JRDesignCellContents)rc.getContents(), (byte)7);
                west.addEast(cc);
                east.addWest(cc);
                break;
            }
            ++j;
        }
    }

    public void fillDetailsH(Guide gnorth, JRDesignCrosstab crosstab) {
        block6: {
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells == null) break block6;
            int i = cells[0].length - 1;
            while (i >= 0) {
                Guide north = gnorth;
                Guide south = this.hGuides.get(this.hGuides.size() - 1);
                List rows = crosstab.getRowGroupsList();
                int k = 0;
                while (k < rows.size()) {
                    block10: {
                        boolean last;
                        block8: {
                            block9: {
                                JRCrosstabRowGroup cg;
                                block7: {
                                    cg = (JRCrosstabRowGroup)rows.get(k);
                                    boolean bl = last = k == rows.size() - 1;
                                    if (cg.getTotalPositionValue() != CrosstabTotalPositionEnum.END) break block7;
                                    Guide tnorth = this.hGuides.get(this.hGuides.indexOf(south) - 1);
                                    this.addDetailCellH(cells, i, tnorth, south, cg.getName());
                                    south = tnorth;
                                    break block8;
                                }
                                if (cg.getTotalPositionValue() != CrosstabTotalPositionEnum.START) break block9;
                                Guide tsouth = this.hGuides.get(this.hGuides.indexOf(north) + 1);
                                this.addDetailCellH(cells, i, north, tsouth, cg.getName());
                                north = tsouth;
                                break block8;
                            }
                            if (!last) break block10;
                        }
                        if (last) {
                            this.addDetailCellH(cells, i, north, south, null);
                        }
                    }
                    ++k;
                }
                --i;
            }
        }
    }

    private void addDetailCellH(JRCrosstabCell[][] cells, int i, Guide north, Guide south, String name) {
        int j = 0;
        while (j < cells.length) {
            String rtg;
            JRCrosstabCell rc = cells[j][i];
            if (rc != null && ((rtg = rc.getRowTotalGroup()) != null && rtg.equals(name) || rtg == null && name == null)) {
                CrosstabCell cc = this.createCell((JRDesignCellContents)rc.getContents(), (byte)7);
                north.addSouth(cc);
                south.addNorth(cc);
                break;
            }
            ++j;
        }
    }

    public Guide fillColumnGroupH(Guide north, Guide south, JRDesignCrosstab crosstab) {
        JRCrosstabColumnGroup[] columns = crosstab.getColumnGroups();
        int i = 0;
        while (i < columns.length) {
            JRCrosstabColumnGroup cg = columns[i];
            CrosstabCell cc = null;
            if (cg.hasTotal()) {
                cc = this.addCell4ColTotal(north, south, cg);
            }
            cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)5);
            north.addSouth(cc);
            Guide tsouth = null;
            tsouth = i == columns.length - 1 ? south : this.addNext(north, this.hGuides);
            tsouth.addNorth(cc);
            tsouth.setY(north, (JRCellContents)cc.cell);
            north = tsouth;
            CrosstabCell hcc = this.createCell((JRDesignCellContents)cg.getCrosstabHeader(), (byte)8);
            hcc.setSouth(cc.getSouth());
            hcc.setNorth(cc.getNorth());
            ++i;
        }
        return south;
    }

    public Guide fillRowGroupH(Guide north, Guide south, JRDesignCrosstab crosstab) {
        JRCrosstabRowGroup[] rows = crosstab.getRowGroups();
        int i = 0;
        while (i < rows.length) {
            Guide tsouth;
            CrosstabCell cc;
            JRCrosstabRowGroup cg = rows[i];
            if (cg.getTotalPositionValue() == CrosstabTotalPositionEnum.START) {
                cc = this.createCell((JRDesignCellContents)cg.getTotalHeader(), (byte)4);
                north.addSouth(cc);
                tsouth = cg.hasTotal() ? this.addNext(north, this.hGuides) : south;
                tsouth.addNorth(cc);
                tsouth.setY(north, (JRCellContents)cc.cell);
                cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)3);
                tsouth.addSouth(cc);
                south.addNorth(cc);
                south.setY(tsouth, (JRCellContents)cc.cell);
                north = tsouth;
            } else if (cg.getTotalPositionValue() == CrosstabTotalPositionEnum.END) {
                cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)3);
                north.addSouth(cc);
                tsouth = cg.hasTotal() ? this.addNext(north, this.hGuides) : south;
                tsouth.addNorth(cc);
                tsouth.setY(north, (JRCellContents)cc.cell);
                cc = this.createCell((JRDesignCellContents)cg.getTotalHeader(), (byte)4);
                tsouth.addSouth(cc);
                south.addNorth(cc);
                south.setY(tsouth, (JRCellContents)cc.cell);
                south = tsouth;
            } else {
                cc = this.createCell((JRDesignCellContents)cg.getHeader(), (byte)3);
                north.addSouth(cc);
                south.addNorth(cc);
                south.setY(north, (JRCellContents)cc.cell);
            }
            ++i;
        }
        return south;
    }

    public Guide fillTitleCellH(Guide north, Guide south, JRDesignCrosstab crosstab) {
        CrosstabColumnCell c = crosstab.getTitleCell();
        JRCellContents cell = c != null ? c.getCellContents() : null;
        CrosstabCell cc = this.createCell((JRDesignCellContents)cell, (byte)9);
        north.addSouth(cc);
        south.addNorth(cc);
        south.setY(north, cell);
        return south;
    }

    public Guide fillTitleCellV(Guide west, Guide east, JRDesignCrosstab crosstab) {
        CrosstabColumnCell c = crosstab.getTitleCell();
        JRCellContents cell = c != null ? c.getCellContents() : null;
        CrosstabCell cc = this.createCell((JRDesignCellContents)cell, (byte)9);
        west.addEast(cc);
        east.addWest(cc);
        east.setX(west, cell);
        return east;
    }

    public Guide fillHeaderCellH(Guide north, Guide south, JRDesignCrosstab crosstab) {
        JRCellContents c = crosstab.getHeaderCell();
        CrosstabCell cc = this.createCell((JRDesignCellContents)c, (byte)1);
        north.addSouth(cc);
        south.addNorth(cc);
        south.setY(north, c);
        return south;
    }

    public Guide fillHeaderCellV(Guide west, Guide east, JRDesignCrosstab crosstab) {
        JRCellContents c = crosstab.getHeaderCell();
        CrosstabCell cc = this.createCell((JRDesignCellContents)c, (byte)1);
        west.addEast(cc);
        east.addWest(cc);
        east.setX(west, c);
        return east;
    }

    public CrosstabCell addCell4ColTotal(Guide north, Guide south, JRCrosstabColumnGroup cg) {
        CrosstabCell cc = this.createCell((JRDesignCellContents)cg.getTotalHeader(), (byte)6);
        north.addSouth(cc);
        south.addNorth(cc);
        south.setY(north, (JRCellContents)cc.cell);
        return cc;
    }

    public CrosstabCell addCell4ColTotal(Guide west, Guide east, JRCrosstabRowGroup cg) {
        CrosstabCell cc = this.createCell((JRDesignCellContents)cg.getTotalHeader(), (byte)4);
        west.addEast(cc);
        east.addWest(cc);
        east.setX(west, (JRCellContents)cc.cell);
        return cc;
    }

    private Guide addNext(Guide north, List<Guide> guides) {
        Guide south = new Guide(north.getY());
        int i = guides.indexOf(north) + 1;
        if (i <= guides.size()) {
            guides.add(i, south);
        } else {
            guides.add(south);
        }
        return south;
    }

    public CrosstabCell createCell(JRDesignCellContents cell, byte type) {
        CrosstabCell cc = new CrosstabCell(cell, type);
        if (this.map.containsKey(cc)) {
            for (CrosstabCell key : this.map.keySet()) {
                if (!key.equals(cc)) continue;
                return key;
            }
        }
        this.map.put(cc, null);
        return cc;
    }

    public void print() {
        System.out.println("\n\n-- NEW TABLE--------------------");
        System.out.println("-- VERTICAL --------------------");
        int i = 0;
        while (i < this.vGuides.size()) {
            Guide g = this.vGuides.get(i);
            System.out.println("col:" + i + "\n" + g.toString());
            ++i;
        }
    }
}

