/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.UpdateCrosstabStyleCommand;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabStyleWizard;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.ExtendedMessageDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class EditCrosstabStyleAction
extends ACachedSelectionAction {
    public static final String ID = "com.jaspersoft.studio.components.crosstab.action.EditStyle";

    public EditCrosstabStyleAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CrosstabStyleWizard_actionName);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/crosstab-style-16.png"));
    }

    protected boolean calculateEnabled() {
        List crosstabs = this.editor.getSelectionCache().getSelectionModelForType(MCrosstab.class);
        return crosstabs.size() == 1;
    }

    public void run() {
        int response;
        CrosstabStyleWizard wizard = new CrosstabStyleWizard();
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                Button button = super.createButton(parent, id, label, defaultButton);
                if (id == 16) {
                    button.setText(Messages.EditCrosstabStyleAction_okButton);
                }
                return button;
            }
        };
        if (dialog.open() == 0 && ((response = this.getResponse()) == 0 || response == 1)) {
            CrosstabStyle selectedStyle = wizard.getTableStyle();
            List crosstabs = this.editor.getSelectionCache().getSelectionModelForType(MCrosstab.class);
            MCrosstab tableModel = (MCrosstab)((Object)crosstabs.get(0));
            this.execute(this.changeStyleCommand(tableModel, selectedStyle, response == 0));
        }
    }

    protected int getResponse() {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String styleBehavior = store.getString("tableCrosstabChangeStyle");
        if (styleBehavior.equals("updateStyles")) {
            return 0;
        }
        if (styleBehavior.equals("createStyles")) {
            return 1;
        }
        Shell shell = UIUtils.getShell();
        ExtendedMessageDialog question = new ExtendedMessageDialog(shell, Messages.EditCrosstabStyleAction_questionTitle, null, Messages.EditCrosstabStyleAction_questionText, 3, new String[]{Messages.EditCrosstabStyleAction_questionUpdate, Messages.EditCrosstabStyleAction_questionNewStyles, Messages.EditCrosstabStyleAction_questionCancel}, 0, Messages.EditCrosstabStyleAction_remeberDecision);
        int response = question.open();
        if (question.getCheckboxResult()) {
            if (response == 0) {
                store.setValue("tableCrosstabChangeStyle", "updateStyles");
            } else if (response == 1) {
                store.setValue("tableCrosstabChangeStyle", "createStyles");
            }
        }
        return response;
    }

    protected Command changeStyleCommand(MCrosstab crosstab, CrosstabStyle newStyle, boolean updateOldStyles) {
        JSSCompoundCommand command = new JSSCompoundCommand((ANode)crosstab);
        command.setDebugLabel(this.getText());
        UpdateCrosstabStyleCommand updateCommand = new UpdateCrosstabStyleCommand(crosstab, newStyle, updateOldStyles);
        command.add((Command)updateCommand);
        return command;
    }
}

