/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.cell.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.model.MGraphicElement;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;

public class ReorderElementCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignElement jrElement;
    private JRDesignCellContents jrCell;

    public ReorderElementCommand(MGraphicElement child, MCell parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrCell = parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrCell.getChildren().indexOf(this.jrElement);
        this.jrCell.removeElement(this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrCell.getChildren().size()) {
            this.jrCell.addElement(this.newIndex, this.jrElement);
        } else {
            this.jrCell.addElement(this.jrElement);
        }
    }

    public void undo() {
        this.jrCell.removeElement(this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrCell.getChildren().size()) {
            this.jrCell.addElement(this.oldIndex, this.jrElement);
        } else {
            this.jrCell.addElement(this.jrElement);
        }
    }
}

