/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard;

import com.jaspersoft.studio.components.crosstab.CrosstabManager;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.AgregationFunctionEnum;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabWizardColumnPage;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabWizardLayoutPage;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabWizardMeasurePage;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabWizardRowPage;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.Wrapper;
import com.jaspersoft.studio.components.crosstab.model.dialog.ApplyCrosstabStyleAction;
import com.jaspersoft.studio.components.crosstab.model.measure.command.CreateMeasureCommand;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.property.dataset.wizard.WizardDatasetPage;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.JSSWizardPageChangeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.CalculationEnum;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Event;

public class CrosstabWizard
extends JSSWizard {
    public static final String CROSSTAB_COLUMNS = "CROSSTAB_COLUMNS";
    public static final String CROSSTAB_ROWS = "CROSSTAB_ROWS";
    public static final String CROSSTAB_MEASURES = "CROSSTAB_MEASURES";
    private WizardDatasetPage step1;
    private CrosstabWizardColumnPage step2;
    private CrosstabWizardRowPage step3;
    private CrosstabWizardMeasurePage step4;
    private CrosstabWizardLayoutPage step5;
    private ReportObjects colGroups;
    private ReportObjects rowGroups;
    private ReportObjects measures;
    private MCrosstab crosstab;

    public CrosstabWizard() {
        this.setWindowTitle(Messages.common_crosstab_wizard);
    }

    public void addPages() {
        JasperDesign jd = this.getConfig().getJasperDesign();
        JRDesignCrosstab jrCrosstab = (JRDesignCrosstab)new MCrosstab().createJRElement(jd);
        this.crosstab = new MCrosstab(null, (JRCrosstab)jrCrosstab, 1, new CrosstabManager(jrCrosstab, jd));
        this.crosstab.setJasperConfiguration(this.getConfig());
        this.step1 = new WizardDatasetPage("Crosstab"){

            protected void clearSettings() {
                Map settings = ((JSSWizard)this.getWizard()).getSettings();
                if (settings != null) {
                    CrosstabWizard.this.step2.clearSelection();
                    CrosstabWizard.this.step3.clearSelection();
                    CrosstabWizard.this.step4.clearSelection();
                    this.getContainer().updateButtons();
                }
            }

            protected void handleComboBoxDatasetSelected(Event event) {
                super.handleComboBoxDatasetSelected(event);
                this.clearSettings();
            }

            protected void handleOptionSelected() {
                super.handleOptionSelected();
                this.clearSettings();
            }
        };
        this.addPage((IWizardPage)this.step1);
        this.step2 = new CrosstabWizardColumnPage();
        this.addPage((IWizardPage)this.step2);
        this.step3 = new CrosstabWizardRowPage();
        this.addPage((IWizardPage)this.step3);
        this.step4 = new CrosstabWizardMeasurePage();
        this.addPage((IWizardPage)this.step4);
        this.step5 = new CrosstabWizardLayoutPage();
        this.addPage((IWizardPage)this.step5);
    }

    public JRDesignDataset getDataset() {
        return this.step1.getSelectedDataset();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    public MCrosstab getCrosstab() {
        List rowGroups;
        List columnGroups;
        JRDesignCrosstab jdc = this.crosstab.getValue();
        JRDesignDataset dataset = this.getDataset();
        this.getAvailableColumnGroups();
        this.getAvailableRowGroups();
        if (dataset.isMainDataset()) {
            ((JRDesignCrosstabDataset)jdc.getDataset()).setDatasetRun(null);
        } else {
            JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)jdc.getDataset().getDatasetRun();
            if (datasetRun == null) {
                datasetRun = new JRDesignDatasetRun();
                ((JRDesignCrosstabDataset)jdc.getDataset()).setDatasetRun((JRDatasetRun)datasetRun);
            }
            datasetRun.setDatasetName(dataset.getName());
            datasetRun.setConnectionExpression((JRExpression)ExprUtil.createExpression((String)"$P{REPORT_CONNECTION}", (String)"java.sql.Connection"));
        }
        List measures = (List)this.getSettings().get(CROSSTAB_MEASURES);
        if (measures != null) {
            for (Object obj : measures) {
                try {
                    JRDesignCrosstabMeasure m = (JRDesignCrosstabMeasure)obj;
                    jdc.addMeasure(m);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((columnGroups = (List)this.getSettings().get(CROSSTAB_COLUMNS)) != null) {
            for (Object obj : columnGroups) {
                try {
                    JRDesignCrosstabColumnGroup c = (JRDesignCrosstabColumnGroup)obj;
                    CrosstabUtil.addColumnGroup(jdc, c, -1, 20 * jdc.getMeasures().length);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((rowGroups = (List)this.getSettings().get(CROSSTAB_ROWS)) != null) {
            for (Object obj : rowGroups) {
                try {
                    JRDesignCrosstabRowGroup r = (JRDesignCrosstabRowGroup)obj;
                    CrosstabUtil.addRowGroup(jdc, r, -1, 20 * jdc.getMeasures().length);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setupColumnGroups(jdc);
        this.setupRowGroups(jdc);
        this.createDetailCells(jdc);
        this.crosstab.getValue().preprocess();
        this.setupMeasures(jdc);
        ApplyCrosstabStyleAction applyAction = new ApplyCrosstabStyleAction(this.step5.getSelectedStyle(), this.crosstab.getValue());
        applyAction.applayStyle(this.getConfig().getJasperDesign());
        return this.crosstab;
    }

    private void createDetailCells(JRDesignCrosstab jdc) {
        List cells = jdc.getCellsList();
        JRCrosstabMeasure[] measures = jdc.getMeasures();
        if (measures != null && cells != null) {
            for (JRCrosstabCell c : cells) {
                int y = 0;
                if (c.getHeight() == null || measures.length <= 0) continue;
                int h = c.getHeight() / measures.length;
                int i = 0;
                while (i < measures.length) {
                    JRDesignExpression exp = new JRDesignExpression();
                    exp.setText("$V{" + measures[i].getName() + "}");
                    JRDesignTextField tf = (JRDesignTextField)new MTextField().createJRElement(this.getConfig().getJasperDesign());
                    tf.setX(0);
                    tf.setY(y);
                    tf.setWidth(c.getWidth().intValue());
                    tf.setHeight(h);
                    tf.setExpression((JRExpression)exp);
                    ((JRDesignCellContents)c.getContents()).addElement((JRDesignElement)tf);
                    y += h;
                    ++i;
                }
            }
        }
    }

    private void setupRowGroups(JRDesignCrosstab jdc) {
        List rows = jdc.getRowGroupsList();
        for (JRCrosstabRowGroup rowGroup : rows) {
            JRDesignElement el;
            JRElement e;
            ((JRDesignCellContents)rowGroup.getHeader()).setHeight(20 * jdc.getMeasures().length);
            JRElement[] jRElementArray = rowGroup.getHeader().getElements();
            int n = jRElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                e = jRElementArray[n2];
                el = (JRDesignElement)e;
                el.setWidth(rowGroup.getHeader().getWidth());
                el.setHeight(rowGroup.getHeader().getHeight());
                ++n2;
            }
            jRElementArray = rowGroup.getTotalHeader().getElements();
            n = jRElementArray.length;
            n2 = 0;
            while (n2 < n) {
                e = jRElementArray[n2];
                el = (JRDesignElement)e;
                el.setWidth(rowGroup.getTotalHeader().getWidth());
                el.setHeight(rowGroup.getTotalHeader().getHeight());
                ++n2;
            }
        }
    }

    private void setupColumnGroups(JRDesignCrosstab jdc) {
        List columns = jdc.getColumnGroupsList();
        for (JRCrosstabColumnGroup colGroup : columns) {
            JRDesignElement el;
            JRElement e;
            JRElement[] jRElementArray = colGroup.getHeader().getElements();
            int n = jRElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                e = jRElementArray[n2];
                el = (JRDesignElement)e;
                el.setWidth(colGroup.getHeader().getWidth());
                el.setHeight(colGroup.getHeader().getHeight());
                ++n2;
            }
            jRElementArray = colGroup.getTotalHeader().getElements();
            n = jRElementArray.length;
            n2 = 0;
            while (n2 < n) {
                e = jRElementArray[n2];
                el = (JRDesignElement)e;
                el.setWidth(colGroup.getTotalHeader().getWidth());
                el.setHeight(colGroup.getTotalHeader().getHeight());
                ++n2;
            }
        }
    }

    private JRDesignCrosstabRowGroup createRowGroups(JRDesignCrosstab jdc, Object f) {
        JRField fi;
        String name = "";
        String txt = "";
        String vclass = "";
        if (f instanceof JRField) {
            fi = (JRField)f;
            name = fi.getName();
            txt = "$F{" + name + "}";
            vclass = fi.getValueClassName();
        } else if (f instanceof JRParameter) {
            fi = (JRParameter)f;
            name = fi.getName();
            txt = "$P{" + name + "}";
            vclass = fi.getValueClassName();
        } else if (f instanceof JRVariable) {
            fi = (JRVariable)f;
            name = fi.getName();
            txt = "$V{" + name + "}";
            vclass = fi.getValueClassName();
        }
        CrosstabTotalPositionEnum total = this.step5.isAddRowTotal() ? CrosstabTotalPositionEnum.END : CrosstabTotalPositionEnum.NONE;
        JRDesignCrosstabRowGroup rowGroup = CrosstabUtil.createRowGroup(this.getConfig().getJasperDesign(), jdc, name, total);
        ((JRDesignExpression)rowGroup.getBucket().getExpression()).setText(txt);
        ((JRDesignCrosstabBucket)rowGroup.getBucket()).setValueClassName(vclass);
        return rowGroup;
    }

    private JRDesignCrosstabColumnGroup createColumnGroups(JRDesignCrosstab jdc, Object f) {
        JRField fi;
        String name = "";
        String txt = "";
        String vclass = "";
        if (f instanceof JRField) {
            fi = (JRField)f;
            name = fi.getName();
            txt = "$F{" + name + "}";
            vclass = fi.getValueClassName();
        } else if (f instanceof JRParameter) {
            fi = (JRParameter)f;
            name = fi.getName();
            txt = "$P{" + name + "}";
            vclass = fi.getValueClassName();
        } else if (f instanceof JRVariable) {
            fi = (JRVariable)f;
            name = fi.getName();
            txt = "$V{" + name + "}";
            vclass = fi.getValueClassName();
        }
        CrosstabTotalPositionEnum total = this.step5.isAddColTotal() ? CrosstabTotalPositionEnum.END : CrosstabTotalPositionEnum.NONE;
        JRDesignCrosstabColumnGroup colGroup = CrosstabUtil.createColumnGroup(this.getConfig().getJasperDesign(), jdc, name, total);
        ((JRDesignExpression)colGroup.getBucket().getExpression()).setText(txt);
        ((JRDesignCrosstabBucket)colGroup.getBucket()).setValueClassName(vclass);
        return colGroup;
    }

    private JRDesignCrosstabMeasure createMesures(JRDesignCrosstab jdc, Object f) {
        JRField fi;
        JRDesignExpression jre = new JRDesignExpression();
        String name = "";
        String classname = "";
        if (f instanceof JRField) {
            fi = (JRField)f;
            name = fi.getName();
            classname = fi.getValueClassName();
            jre.setText("$F{" + name + "}");
        } else if (f instanceof JRParameter) {
            fi = (JRParameter)f;
            name = fi.getName();
            classname = fi.getValueClassName();
            jre.setText("$P{" + name + "}");
        } else if (f instanceof JRVariable) {
            fi = (JRVariable)f;
            classname = fi.getValueClassName();
            name = fi.getName();
            jre.setText("$V{" + name + "}");
        }
        JRDesignCrosstabMeasure m = CreateMeasureCommand.createMesure(jdc, String.valueOf(name) + "_MEASURE");
        m.setValueExpression((JRExpression)jre);
        m.setCalculation(CalculationEnum.COUNT);
        m.setValueClassName(classname);
        m.setPercentageType(CrosstabPercentageEnum.NONE);
        return m;
    }

    private void setupMeasures(JRDesignCrosstab jdc) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jdc.getMeasures();
        int n = jRCrosstabMeasureArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRCrosstabMeasure cm = jRCrosstabMeasureArray[n2];
            CalculationEnum calculationValue = cm.getCalculationValue();
            if (calculationValue != null && (calculationValue.equals((Object)CalculationEnum.COUNT) || calculationValue.equals((Object)CalculationEnum.DISTINCT_COUNT))) {
                ((JRDesignCrosstabMeasure)cm).setValueClassName(Integer.class.getName());
            }
            ++n2;
        }
    }

    public void setConfig(JasperReportsConfiguration jConfig, boolean disposeConfig) {
        super.setConfig(jConfig, disposeConfig);
        if (this.crosstab != null) {
            this.crosstab.setJasperConfiguration(jConfig);
        }
    }

    public static void setBucketExpression(JRDesignCrosstabBucket bucket, String oldExpText, AgregationFunctionEnum function) {
        JRDesignExpression exp = (JRDesignExpression)bucket.getExpression();
        if (function == AgregationFunctionEnum.UNIQUE) {
            exp.setText(oldExpText);
        } else if (function == AgregationFunctionEnum.YEAR) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"yyyy\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.MONTH) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"MM\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.WEEK) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"ww\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.DAY) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"dd\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.DAY_OF_THE_WEEK) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"u\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.HOUR) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"HH\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.MINUTE) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"mm\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.SECOND) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"ss\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.MILLISECOND) {
            exp.setText("Integer.parseInt(new SimpleDateFormat(\"SSSS\").format(" + oldExpText + "))");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.QUARTER) {
            exp.setText("(Integer.parseInt(new SimpleDateFormat(\"MM\").format(" + oldExpText + "))/4)+1");
            bucket.setValueClassName(Integer.class.getName());
        } else if (function == AgregationFunctionEnum.SEMESTER) {
            exp.setText("(Integer.parseInt(new SimpleDateFormat(\"MM\").format(" + oldExpText + "))/6)+1");
            bucket.setValueClassName(Integer.class.getName());
        }
        bucket.setExpression(exp);
    }

    public List<Object> getAvailableColumnGroups() {
        ArrayList<Object> objects = new ArrayList<Object>();
        JRDesignDataset ds = this.getDataset();
        if (ds == null) {
            return objects;
        }
        String dsname = ds.getName();
        if (ds.isMainDataset()) {
            dsname = "_MAIN_DATASET";
        }
        if (this.colGroups == null || !this.colGroups.getDsname().equals(dsname)) {
            this.colGroups = new ReportObjects(ModelUtils.getReportObjects4Datasource((JRDataset)ds), dsname);
        }
        if (this.colGroups != null) {
            JRDesignCrosstab jdc = this.crosstab.getValue();
            for (Object f : this.colGroups.getReportObects()) {
                objects.add(this.createColumnGroups(jdc, f));
            }
        }
        return objects;
    }

    public List<Object> getAvailableRowGroups() {
        ArrayList<Object> objects = new ArrayList<Object>();
        JRDesignDataset ds = this.getDataset();
        if (ds == null) {
            return objects;
        }
        String dsname = ds.getName();
        if (ds.isMainDataset()) {
            dsname = "_MAIN_DATASET";
        }
        if (this.rowGroups == null || !this.rowGroups.getDsname().equals(dsname)) {
            this.rowGroups = new ReportObjects(ModelUtils.getReportObjects4Datasource((JRDataset)ds), dsname);
        }
        if (this.rowGroups != null) {
            List<Wrapper> selectedColumns = this.step2.getSelectedFieldWrappers();
            HashSet<String> selectedColExpressions = new HashSet<String>();
            for (Wrapper wrapper : selectedColumns) {
                String usedObject = wrapper.getBaseObjectExpression();
                selectedColExpressions.add(usedObject);
            }
            JRDesignCrosstab jdc = this.crosstab.getValue();
            for (Object f : this.rowGroups.getReportObects()) {
                JRDesignCrosstabRowGroup row = this.createRowGroups(jdc, f);
                String rowExpression = row.getBucket().getExpression().getText();
                if (selectedColExpressions.contains(rowExpression)) continue;
                objects.add(row);
            }
        }
        return objects;
    }

    public List<Object> getAvailableMeasures() {
        ArrayList<Object> objects = new ArrayList<Object>();
        JRDesignDataset ds = this.getDataset();
        if (ds == null) {
            return objects;
        }
        String dsname = ds.getName();
        if (ds.isMainDataset()) {
            dsname = "_MAIN_DATASET";
        }
        if (this.measures == null || !this.measures.getDsname().equals(dsname)) {
            this.measures = new ReportObjects(ModelUtils.getReportObjects4Datasource((JRDataset)ds), dsname);
        }
        if (this.measures != null) {
            JRDesignCrosstab jdc = this.crosstab.getValue();
            for (Object f : this.measures.getReportObects()) {
                objects.add(this.createMesures(jdc, f));
            }
        }
        return objects;
    }

    public void pageChanged(JSSWizardPageChangeEvent event) {
        super.pageChanged(event);
        if (event.getPage().getName().equals("tablepage")) {
            this.colGroups = null;
            this.rowGroups = null;
            this.measures = null;
        }
    }

    private class ReportObjects {
        private List<Object> reportObects;
        private String dsname;

        public List<Object> getReportObects() {
            return this.reportObects;
        }

        public String getDsname() {
            return this.dsname;
        }

        public ReportObjects(List<Object> reportObects, String dsname) {
            this.reportObects = reportObects;
            this.dsname = dsname;
        }
    }
}

