/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.dialog;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import com.jaspersoft.studio.editor.style.ApplyStyleAction;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.model.style.command.CreateStyleCommand;
import com.jaspersoft.studio.model.style.command.UpdateStyleCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.eclipse.gef.commands.Command;

public class ApplyCrosstabStyleAction
extends ApplyStyleAction {
    public static final String CROSSTAB_HEADER_PROPERTY = "com.jaspersoft.studio.crosstab.style.header";
    public static final String CROSSTAB_TOTAL_PROPERTY = "com.jaspersoft.studio.crosstab.style.total";
    public static final String CROSSTAB_GROUP_PROPERTY = "com.jaspersoft.studio.crosstab.style.group";
    public static final String CROSSTAB_DETAIL_PROPERTY = "com.jaspersoft.studio.crosstab.style.detail";
    private List<JRDesignStyle> styles = null;

    public ApplyCrosstabStyleAction(CrosstabStyle style, JRDesignCrosstab element) {
        super((TemplateStyle)style, (JRElement)element);
    }

    public ApplyCrosstabStyleAction(List<JRDesignStyle> styles, JRDesignCrosstab crosstab) {
        super(null, (JRElement)crosstab);
        this.styles = styles;
    }

    private JRDesignStyle getCellBackgroundColor(JRDesignCrosstab crosstab, JRCrosstabOrigin origin, List<JRDesignStyle> styleList) {
        int groupIndex;
        int c_index = -1;
        int r_index = -1;
        if (origin.getColumnGroupName() != null) {
            c_index = (Integer)crosstab.getColumnGroupIndicesMap().get(origin.getColumnGroupName());
        }
        if (origin.getRowGroupName() != null) {
            r_index = (Integer)crosstab.getRowGroupIndicesMap().get(origin.getRowGroupName());
        }
        if ((groupIndex = Math.max(c_index, r_index)) < 0) {
            return styleList.get(3);
        }
        groupIndex = c_index == 0 || r_index == 0 ? 1 : 0;
        switch (origin.getType()) {
            case 7: {
                return styleList.get(groupIndex + 1);
            }
            case 3: 
            case 5: {
                return styleList.get(0);
            }
            case 4: 
            case 6: {
                return styleList.get(groupIndex + 1);
            }
        }
        return null;
    }

    private int getBackgroundIndex(JRDesignCrosstab crosstab, JRCrosstabOrigin origin) {
        int groupIndex;
        int c_index = -1;
        int r_index = -1;
        if (origin.getColumnGroupName() != null) {
            c_index = (Integer)crosstab.getColumnGroupIndicesMap().get(origin.getColumnGroupName());
        }
        if (origin.getRowGroupName() != null) {
            r_index = (Integer)crosstab.getRowGroupIndicesMap().get(origin.getRowGroupName());
        }
        if ((groupIndex = Math.max(c_index, r_index)) < 0) {
            return 3;
        }
        groupIndex = c_index == 0 || r_index == 0 ? 1 : 0;
        switch (origin.getType()) {
            case 7: {
                return groupIndex + 1;
            }
            case 3: 
            case 5: {
                return 0;
            }
            case 4: 
            case 6: {
                return groupIndex + 1;
            }
        }
        return -1;
    }

    public void rebuildStylesFromCrosstab(JasperDesign jd) {
        this.styles = new ArrayList<JRDesignStyle>(Arrays.asList(this.getStylesFromCrosstab(this.getElement().getPropertiesMap(), jd)));
    }

    protected static boolean hasStyleProperties(JRPropertiesMap crosstabMap) {
        return crosstabMap.containsProperty(CROSSTAB_GROUP_PROPERTY) || crosstabMap.containsProperty(CROSSTAB_DETAIL_PROPERTY) || crosstabMap.containsProperty(CROSSTAB_HEADER_PROPERTY) || crosstabMap.containsProperty(CROSSTAB_TOTAL_PROPERTY);
    }

    public JRDesignStyle[] getStylesFromCrosstab(JRPropertiesMap crosstabMap, JasperDesign jd) {
        JRDesignStyle[] stylesArray = new JRDesignStyle[4];
        if (ApplyCrosstabStyleAction.hasStyleProperties(crosstabMap)) {
            String crosstabHeaderStyle = crosstabMap.getProperty(CROSSTAB_HEADER_PROPERTY);
            stylesArray[0] = (JRDesignStyle)jd.getStylesMap().get(crosstabHeaderStyle);
            String crosstabGroupStyle = crosstabMap.getProperty(CROSSTAB_GROUP_PROPERTY);
            stylesArray[1] = (JRDesignStyle)jd.getStylesMap().get(crosstabGroupStyle);
            String crosstabTotalStyle = crosstabMap.getProperty(CROSSTAB_TOTAL_PROPERTY);
            stylesArray[2] = (JRDesignStyle)jd.getStylesMap().get(crosstabTotalStyle);
            String crosstabDetailStyle = crosstabMap.getProperty(CROSSTAB_DETAIL_PROPERTY);
            stylesArray[3] = (JRDesignStyle)jd.getStylesMap().get(crosstabDetailStyle);
        } else {
            JRDesignCrosstab crosstab = (JRDesignCrosstab)this.getElement();
            List contents = ModelUtils.getAllCells((JRDesignCrosstab)crosstab);
            for (JRDesignCellContents content : contents) {
                int index;
                JRStyle actualStyle;
                if (content == null || (actualStyle = content.getStyle()) == null || !(actualStyle instanceof JRDesignStyle) || (index = this.getBackgroundIndex(crosstab, content.getOrigin())) == -1) continue;
                stylesArray[index] = (JRDesignStyle)actualStyle;
            }
        }
        return stylesArray;
    }

    public void applayStyle(JasperDesign design) {
        List<JRDesignStyle> styleList = this.createStyles(design);
        this.setCellStyles(styleList);
    }

    private void setCellStyles(List<JRDesignStyle> styleList) {
        JRDesignCrosstab crosstab = (JRDesignCrosstab)this.getElement();
        JRPropertiesMap tableMap = this.getElement().getPropertiesMap();
        if (styleList.get(0) != null) {
            tableMap.setProperty(CROSSTAB_HEADER_PROPERTY, styleList.get(0).getName());
        }
        if (styleList.get(1) != null) {
            tableMap.setProperty(CROSSTAB_GROUP_PROPERTY, styleList.get(1).getName());
        }
        if (styleList.get(2) != null) {
            tableMap.setProperty(CROSSTAB_TOTAL_PROPERTY, styleList.get(2).getName());
        }
        if (styleList.get(3) != null) {
            tableMap.setProperty(CROSSTAB_DETAIL_PROPERTY, styleList.get(3).getName());
        }
        List contents = ModelUtils.getAllCells((JRDesignCrosstab)crosstab);
        for (JRDesignCellContents content : contents) {
            JRDesignStyle style;
            if (content == null || (style = this.getCellBackgroundColor(crosstab, content.getOrigin(), styleList)) == null) continue;
            try {
                content.setStyle(null);
                content.setStyle((JRStyle)style);
                content.setMode(ModeEnum.OPAQUE);
                Color backGround = style.getBackcolor();
                int luminance = (30 * backGround.getRed() + 59 * backGround.getGreen() + 11 * backGround.getBlue()) / 255;
                if (luminance >= 50) continue;
                JRElement[] elements = content.getElements();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof JRDesignTextElement) {
                        ((JRDesignTextElement)elements[i]).setForecolor(Color.WHITE);
                    }
                    ++i;
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void updateStyle(JasperDesign design, CrosstabStyle newStyles, boolean updatOldStyles, boolean removeOldStyles) {
        this.updateStyle(design, this.createStyles(design, false), updatOldStyles, removeOldStyles);
    }

    public void updateStyle(JasperDesign design, List<JRDesignStyle> newStyles, boolean updatOldStyles, boolean removeOldStyles) {
        if (updatOldStyles) {
            JSSCompoundCommand commands = new JSSCompoundCommand(null);
            ArrayList<JRDesignStyle> stylesToApply = new ArrayList<JRDesignStyle>(newStyles);
            JRDesignStyle[] actualStyles = this.getStylesFromCrosstab(this.getElement().getPropertiesMap(), design);
            int i = 0;
            while (i < actualStyles.length) {
                JRDesignStyle style = actualStyles[i];
                if (style != null) {
                    JRDesignStyle updatedStyle = (JRDesignStyle)stylesToApply.get(i);
                    updatedStyle.setName(style.getName());
                    JRDesignStyle styleToUpdate = (JRDesignStyle)design.getStylesMap().get(style.getName());
                    stylesToApply.set(i, styleToUpdate);
                    if (styleToUpdate != null) {
                        commands.add((Command)new UpdateStyleCommand(updatedStyle, styleToUpdate));
                    } else {
                        stylesToApply.set(i, null);
                    }
                } else {
                    stylesToApply.set(i, null);
                }
                ++i;
            }
            commands.execute();
            this.setCellStyles(stylesToApply);
        } else {
            JSSCompoundCommand commands = new JSSCompoundCommand(null);
            this.styles = newStyles;
            Map stylesMap = design.getStylesMap();
            if (removeOldStyles) {
                JRDesignStyle[] oldStyles;
                JRDesignStyle[] jRDesignStyleArray = oldStyles = this.getStylesFromCrosstab(this.getElement().getPropertiesMap(), design);
                int n = oldStyles.length;
                int n2 = 0;
                while (n2 < n) {
                    JRDesignStyle style = jRDesignStyleArray[n2];
                    if (style != null) {
                        design.removeStyle((JRStyle)style);
                    }
                    ++n2;
                }
            }
            for (JRDesignStyle style : newStyles) {
                if (style == null || stylesMap.containsKey(style.getName())) continue;
                commands.add((Command)new CreateStyleCommand(design, style));
            }
            commands.execute();
            this.setCellStyles(newStyles);
        }
    }

    private boolean stylePresent(Map<String, JRStyle> styleMap, String baseName) {
        return styleMap.containsKey(String.valueOf(baseName) + "_CH") || styleMap.containsKey(String.valueOf(baseName) + "_CG") || styleMap.containsKey(String.valueOf(baseName) + "_CT") || styleMap.containsKey(String.valueOf(baseName) + "_CD");
    }

    public List<JRDesignStyle> createStyles(JasperDesign jd, boolean addStylesToReport) {
        String name;
        JSSCompoundCommand commands = new JSSCompoundCommand(null);
        CrosstabStyle style = (CrosstabStyle)this.getStyle();
        String baseName = "Crosstab";
        int i = 0;
        while (true) {
            name = baseName;
            if (i > 0) {
                name = String.valueOf(baseName) + " " + i;
            }
            if (!this.stylePresent(jd.getStylesMap(), name)) break;
            ++i;
        }
        baseName = name;
        float gridSize = style.isShowGrid() != false ? 0.5f : 0.0f;
        ArrayList<JRDesignStyle> result = new ArrayList<JRDesignStyle>();
        JRDesignStyle tableHeaderStyle = new JRDesignStyle();
        tableHeaderStyle.setName(String.valueOf(baseName) + "_CH");
        this.setBorderWidth(tableHeaderStyle, gridSize);
        if (style.getWhiteGrid().booleanValue()) {
            this.setBorderColor(tableHeaderStyle, Color.white);
        } else {
            this.setBorderColor(tableHeaderStyle, Color.black);
        }
        tableHeaderStyle.setMode(ModeEnum.OPAQUE);
        tableHeaderStyle.setBackcolor(style.getColorValue("color_measures"));
        commands.add((Command)new CreateStyleCommand(jd, tableHeaderStyle));
        result.add(tableHeaderStyle);
        JRDesignStyle groupStyle = new JRDesignStyle();
        groupStyle.setName(String.valueOf(baseName) + "_CG");
        this.setBorderWidth(groupStyle, gridSize);
        if (style.getWhiteGrid().booleanValue()) {
            this.setBorderColor(groupStyle, Color.white);
        } else {
            this.setBorderColor(groupStyle, Color.black);
        }
        groupStyle.setMode(ModeEnum.OPAQUE);
        groupStyle.setBackcolor(style.getColorValue("color_group"));
        commands.add((Command)new CreateStyleCommand(jd, groupStyle));
        result.add(groupStyle);
        JRDesignStyle columnHeaderStyle = new JRDesignStyle();
        columnHeaderStyle.setName(String.valueOf(baseName) + "_CT");
        this.setBorderWidth(columnHeaderStyle, gridSize);
        if (style.getWhiteGrid().booleanValue()) {
            this.setBorderColor(columnHeaderStyle, Color.white);
        } else {
            this.setBorderColor(columnHeaderStyle, Color.black);
        }
        columnHeaderStyle.setMode(ModeEnum.OPAQUE);
        columnHeaderStyle.setBackcolor(style.getColorValue("color_total"));
        commands.add((Command)new CreateStyleCommand(jd, columnHeaderStyle));
        result.add(columnHeaderStyle);
        JRDesignStyle cellStyle = new JRDesignStyle();
        cellStyle.setName(String.valueOf(baseName) + "_CD");
        this.setBorderWidth(cellStyle, gridSize);
        if (style.getWhiteGrid().booleanValue()) {
            this.setBorderColor(cellStyle, Color.white);
        } else {
            this.setBorderColor(cellStyle, Color.black);
        }
        cellStyle.setMode(ModeEnum.OPAQUE);
        cellStyle.setBackcolor(style.getColorValue("color_detail"));
        commands.add((Command)new CreateStyleCommand(jd, cellStyle));
        result.add(cellStyle);
        if (addStylesToReport) {
            commands.execute();
        }
        return result;
    }

    public List<JRDesignStyle> createStyles(JasperDesign jd) {
        if (this.styles == null) {
            return this.createStyles(jd, true);
        }
        return this.styles;
    }
}

