/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.measure.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.components.crosstab.model.measure.MMeasure;
import com.jaspersoft.studio.components.crosstab.model.measure.MMeasures;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateMeasureCommand
extends Command {
    private JRDesignCrosstabMeasure jrMeasure;
    private JRDesignCrosstab jrCrosstab;
    private int index;

    public CreateMeasureCommand(MMeasures destNode, MMeasure srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateMeasureCommand(MCrosstab destNode, MMeasure srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateMeasureCommand(MCell destNode, MMeasure srcNode, int index) {
        this(destNode.getMCrosstab(), srcNode, index);
    }

    public CreateMeasureCommand(MCrosstab crosstab, JRDesignCrosstabMeasure measure, int index) {
        this.jrCrosstab = crosstab.getValue();
        this.index = index;
        this.jrMeasure = measure;
    }

    private CreateMeasureCommand(ANode destNode, MMeasure srcNode, int index) {
        this.jrCrosstab = (JRDesignCrosstab)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrMeasure = (JRDesignCrosstabMeasure)srcNode.getValue();
        }
    }

    public void execute() {
        block6: {
            if (this.jrMeasure == null) {
                this.jrMeasure = CreateMeasureCommand.createMesure(this.jrCrosstab, Messages.CreateMeasureCommand_measure);
            }
            if (this.jrMeasure != null) {
                try {
                    if (this.index >= 0 && this.index < this.jrCrosstab.getMesuresList().size()) {
                        this.jrCrosstab.addMeasure(this.index, this.jrMeasure);
                    } else {
                        this.jrCrosstab.addMeasure(this.jrMeasure);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("A group or measure having the same name already exists in the crosstab")) break block6;
                    String defaultName = ModelUtils.getDefaultName((Map)this.jrCrosstab.getMeasureIndicesMap(), (String)"CopyOFMeasure_");
                    InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateMeasureCommand_parameter_name, Messages.CreateMeasureCommand_dialog_text, defaultName, null);
                    if (dlg.open() != 0) break block6;
                    this.jrMeasure.setName(dlg.getValue());
                    this.execute();
                }
            }
        }
    }

    public static JRDesignCrosstabMeasure createMesure(JRDesignCrosstab jrCrosstab, String name) {
        JRDesignCrosstabMeasure jrMeasure = new JRDesignCrosstabMeasure();
        jrMeasure.setName(ModelUtils.getDefaultName((JRDesignCrosstab)jrCrosstab, (String)name));
        return jrMeasure;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrCrosstab.removeMeasure((JRCrosstabMeasure)this.jrMeasure);
    }
}

