/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.measure.command;

import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.components.crosstab.model.measure.MMeasure;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.text.MTextField;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateMeasureFieldCommand
extends Command {
    protected MMeasure child;
    protected MCell parent;
    protected JRDesignDataset jDataset;
    protected JRDesignTextField newElement = null;
    protected Rectangle location;

    public CreateMeasureFieldCommand(MMeasure child, MCell parent, Rectangle location) {
        String dbname;
        JasperDesign jd = parent.getJasperDesign();
        this.jDataset = jd.getMainDesignDataset();
        JRCrosstabDataset d = parent.getMCrosstab().getValue().getDataset();
        JRDesignDatasetRun dr = (JRDesignDatasetRun)d.getDatasetRun();
        if (dr != null && (dbname = dr.getDatasetName()) != null) {
            this.jDataset = (JRDesignDataset)jd.getDatasetMap().get(dbname);
        }
        this.child = child;
        this.parent = parent;
        this.location = location;
    }

    protected void setElementBounds(JRDesignElement jrElement, MGraphicElement gElement) {
        if (this.location == null) {
            this.location = new Rectangle(0, 0, this.parent.getDefaultWidth(), this.parent.getDefaultHeight());
        }
        if (this.location.width < 0) {
            this.location.width = gElement.getDefaultWidth();
        }
        if (this.location.height < 0) {
            this.location.height = gElement.getDefaultHeight();
        }
        jrElement.setX(this.location.x);
        jrElement.setY(this.location.y);
        jrElement.setWidth(this.location.width);
        jrElement.setHeight(this.location.height);
    }

    public void execute() {
        MTextField mElement = new MTextField();
        JRDesignTextField textElement = mElement.createJRElement(this.parent.getJasperDesign(), true);
        String measureName = "$V{" + (String)this.child.getPropertyActualValue("name") + "}";
        textElement.setExpression((JRExpression)new JRDesignExpression(measureName));
        this.newElement = textElement;
        this.parent.getValue().addElement((JRDesignElement)textElement);
        this.setElementBounds((JRDesignElement)textElement, (MGraphicElement)mElement);
    }

    public boolean canUndo() {
        return this.newElement != null;
    }

    public void undo() {
        if (this.newElement != null) {
            this.parent.getValue().removeElement((JRDesignElement)this.newElement);
            this.newElement = null;
        }
    }
}

