/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.measure.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.measure.MMeasure;
import com.jaspersoft.studio.components.crosstab.model.measure.MMeasures;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import org.eclipse.gef.commands.Command;

public class ReorderMeasureCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignCrosstabMeasure jrMeasure;
    private JRDesignCrosstab jrCrosstab;

    public ReorderMeasureCommand(MMeasure child, MMeasures parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrCrosstab = (JRDesignCrosstab)parent.getValue();
        this.jrMeasure = (JRDesignCrosstabMeasure)child.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrCrosstab.getMesuresList().indexOf(this.jrMeasure);
        this.jrCrosstab.getMesuresList().remove(this.jrMeasure);
        this.jrCrosstab.getEventSupport().fireCollectionElementRemovedEvent("measures", (Object)this.jrMeasure, this.oldIndex);
        if (this.newIndex >= 0 && this.newIndex < this.jrCrosstab.getMesuresList().size()) {
            this.jrCrosstab.getMesuresList().add(this.newIndex, this.jrMeasure);
        } else {
            this.jrCrosstab.getMesuresList().add(this.jrMeasure);
        }
        this.jrCrosstab.getEventSupport().fireCollectionElementAddedEvent("measures", (Object)this.jrMeasure, this.newIndex);
    }

    public void undo() {
        this.jrCrosstab.getMesuresList().remove(this.jrMeasure);
        this.jrCrosstab.getEventSupport().fireCollectionElementRemovedEvent("measures", (Object)this.jrMeasure, this.newIndex);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrCrosstab.getMesuresList().size()) {
            this.jrCrosstab.getMesuresList().add(this.oldIndex, this.jrMeasure);
        } else {
            this.jrCrosstab.getMesuresList().add(this.jrMeasure);
        }
        this.jrCrosstab.getEventSupport().fireCollectionElementAddedEvent("measures", (Object)this.jrMeasure, this.oldIndex);
    }
}

