/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.rowgroup.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.wizard.CrosstabGroupWizard;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.LazyCrosstabLayoutCommand;
import com.jaspersoft.studio.components.crosstab.model.dialog.ApplyCrosstabStyleAction;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroups;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.command.CreateRowCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public class CreateRowGroupAction
extends ACachedSelectionAction {
    public static final String ID = "create_rowgroup";

    public CreateRowGroupAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CreateRowGroupAction_create_row_group);
        this.setToolTipText(Messages.CreateRowGroupAction_create_row_group_tool_tip);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/add-crosstabrows-16.png"));
        this.setDisabledImageDescriptor(Activator.getDefault().getImageDescriptor("icons/add-crosstabrows-16.png"));
    }

    public void run() {
        EditPart part;
        MCrosstab crosstab = null;
        Object selected = this.getSelectedObjects().get(0);
        if (selected instanceof EditPart && (part = (EditPart)selected).getModel() instanceof INode) {
            crosstab = this.getCrosstab((INode)part.getModel());
        }
        if (crosstab != null) {
            CrosstabGroupWizard crosstabGroupWizard = new CrosstabGroupWizard(crosstab);
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)crosstabGroupWizard);
            if (dialog.open() == 0) {
                JSSCompoundCommand cmd = new JSSCompoundCommand("Create Row Group", null);
                JRDesignCrosstabRowGroup jrGroup = CrosstabUtil.createRowGroup(crosstab.getJasperDesign(), crosstab.getValue(), crosstabGroupWizard.getGroupName(), CrosstabTotalPositionEnum.END);
                JRDesignCrosstabBucket bucket = (JRDesignCrosstabBucket)jrGroup.getBucket();
                bucket.setExpression(new JRDesignExpression(crosstabGroupWizard.getGroupExpression()));
                bucket.setValueClassName(crosstabGroupWizard.getGroupValueClass());
                cmd.add((Command)new CreateRowCommand((ANode)crosstab, jrGroup, -1));
                cmd.setReferenceNodeIfNull((ANode)crosstab);
                cmd.add((Command)new LazyCrosstabLayoutCommand(crosstab));
                this.execute((Command)cmd);
                JasperDesign jd = crosstab.getJasperDesign();
                ApplyCrosstabStyleAction applyStyle = new ApplyCrosstabStyleAction(new ArrayList<JRDesignStyle>(), crosstab.getValue());
                applyStyle.rebuildStylesFromCrosstab(jd);
                applyStyle.applayStyle(crosstab.getJasperDesign());
            }
        }
    }

    public MCrosstab getCrosstab(INode startNode) {
        INode node = startNode;
        while (node != null && node.getParent() != null && !(node instanceof MCrosstab) && !(node instanceof MRoot)) {
            node = node.getParent();
        }
        if (node instanceof MCrosstab) {
            return (MCrosstab)node;
        }
        return null;
    }

    public boolean isEnabled() {
        List elements = this.editor.getSelectionCache().getSelectionModelForType(MCrosstab.class);
        if (elements.size() == 1) {
            return true;
        }
        elements = this.editor.getSelectionCache().getSelectionModelForType(MRowGroups.class);
        return elements.size() == 1;
    }
}

