/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.rowgroup.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.LazyCrosstabLayoutCommand;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroup;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroups;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.command.DeleteRowGroupCommand;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.gef.commands.Command;

public class ReorderRowGroupCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignCrosstabRowGroup jrRowGroup;
    private MCrosstab crosstabNode;
    private JRDesignCrosstab jrCrosstab;
    private LazyCrosstabLayoutCommand layoutCommand;

    public ReorderRowGroupCommand(MRowGroup child, MRowGroups parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = newIndex;
        this.crosstabNode = child.getMCrosstab();
        this.jrCrosstab = (JRDesignCrosstab)parent.getValue();
        this.jrRowGroup = (JRDesignCrosstabRowGroup)child.getValue();
        this.layoutCommand = new LazyCrosstabLayoutCommand(child.getMCrosstab());
    }

    public void execute() {
        this.oldIndex = this.jrCrosstab.getRowGroupsList().indexOf(this.jrRowGroup);
        DeleteRowGroupCommand deleteCommand = new DeleteRowGroupCommand(this.crosstabNode, this.jrRowGroup);
        deleteCommand.execute();
        try {
            CrosstabUtil.addRowGroup(this.jrCrosstab, this.jrRowGroup, this.newIndex, deleteCommand.getRemovedCells());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrRowGroup);
        this.layoutCommand.execute();
    }

    public void undo() {
        DeleteRowGroupCommand deleteCommand = new DeleteRowGroupCommand(this.crosstabNode, this.jrRowGroup);
        deleteCommand.execute();
        try {
            CrosstabUtil.addRowGroup(this.jrCrosstab, this.jrRowGroup, this.oldIndex, deleteCommand.getRemovedCells());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrRowGroup);
        this.layoutCommand.execute();
    }

    public boolean canExecute() {
        return this.newIndex != -1;
    }
}

