/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.engine;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.column.command.CreateColumnCommand;
import com.jaspersoft.studio.components.table.model.dialog.ApplyTableStyleAction;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableSections;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableWizardLayoutPage;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.jasper.JSSReportConverter;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.templates.engine.DefaultTemplateEngine;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateEngineException;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.RGB;

public class TableTemplateEngine
extends DefaultTemplateEngine {
    public static final String FIELD_MARKER = "field";
    public static final String GROUP_MARKER = "groupfield";
    private static final String FIELD_COMPATIBILITY_MARKER = "detailfield";
    public static final String TEXT_MARKER = "label";
    private List<JRDesignStyle> stylesList;
    private List<Object> tableFields;
    private List<Object> groupFields;
    private List<JRDesignElement> colHeaderContent;
    private List<JRDesignElement> colFooterContent;
    private List<JRDesignElement> tableHeaderContent;
    private List<List<JRDesignElement>> tableGroupField;
    private List<JRDesignElement> detailContent;
    private List<JRDesignElement> tableFooterContent;
    private int tableWidth = 200;
    private int tableHeight = 200;
    private int columnWidth = 40;
    private int templateGroupWidth = 200;
    private int tableX = 0;
    private int tableY = 0;
    private TableSections sections;
    private int summaryHeight;

    private StandardColumn generateColumn(StandardTable tbl, JRPropertiesMap tableMap, JasperDesign jd, String fieldName, String fieldValue, int colWidth) {
        JRDesignElement copyElement;
        StandardColumn col = CreateColumnCommand.addColumnWithStyle(jd, tbl, tableMap, this.sections.isTableHeader(), this.sections.isTableFooter(), this.sections.isColumnHeader(), this.sections.isColumnFooter(), this.sections.isGroupHeader(), this.sections.isGroupFooter());
        col.setWidth(Integer.valueOf(colWidth));
        if (this.sections.isTableHeader()) {
            DesignCell tableHeader = (DesignCell)col.getTableHeader();
            tableHeader.setHeight(Integer.valueOf(this.sections.getTableHeaderHeight()));
            for (JRDesignElement element : this.tableHeaderContent) {
                copyElement = (JRDesignElement)element.clone();
                copyElement.setX(this.getRelativeWidth(colWidth, copyElement.getX()));
                copyElement.setWidth(this.getRelativeWidth(colWidth, copyElement.getWidth()));
                tableHeader.addElement(copyElement);
            }
        }
        if (this.sections.isTableFooter()) {
            DesignCell tableFooter = (DesignCell)col.getTableFooter();
            tableFooter.setHeight(Integer.valueOf(this.sections.getTableFooterHeight()));
            for (JRDesignElement element : this.tableFooterContent) {
                copyElement = (JRDesignElement)element.clone();
                copyElement.setX(this.getRelativeWidth(colWidth, copyElement.getX()));
                copyElement.setWidth(this.getRelativeWidth(colWidth, copyElement.getWidth()));
                tableFooter.addElement(copyElement);
            }
        }
        if (this.sections.isColumnFooter()) {
            DesignCell columnFooter = (DesignCell)col.getColumnFooter();
            columnFooter.setHeight(Integer.valueOf(this.sections.getColumnFooterHeight()));
            for (JRDesignElement element : this.colFooterContent) {
                copyElement = (JRDesignElement)element.clone();
                copyElement.setX(this.getRelativeWidth(colWidth, copyElement.getX()));
                copyElement.setWidth(this.getRelativeWidth(colWidth, copyElement.getWidth()));
                columnFooter.addElement(copyElement);
            }
        }
        if (this.sections.isColumnHeader()) {
            DesignCell columnHeader = (DesignCell)col.getColumnHeader();
            columnHeader.setHeight(Integer.valueOf(this.sections.getColumnHeaderHeight()));
            for (JRDesignElement element : this.colHeaderContent) {
                JRDesignStaticText text;
                copyElement = (JRDesignElement)element.clone();
                copyElement.setX(this.getRelativeWidth(colWidth, copyElement.getX()));
                copyElement.setWidth(this.getRelativeWidth(colWidth, copyElement.getWidth()));
                if (copyElement instanceof JRDesignStaticText && this.isColumnHeaderPlaceholder(text = (JRDesignStaticText)copyElement)) {
                    text.setText(fieldName);
                }
                columnHeader.addElement(copyElement);
            }
        }
        DesignCell detailCell = (DesignCell)col.getDetailCell();
        detailCell.setHeight(Integer.valueOf(this.sections.getDetailHeight()));
        for (JRDesignElement element : this.detailContent) {
            JRDesignTextField field;
            copyElement = (JRDesignElement)element.clone();
            copyElement.setX(this.getRelativeWidth(colWidth, copyElement.getX()));
            copyElement.setWidth(this.getRelativeWidth(colWidth, copyElement.getWidth()));
            if (copyElement instanceof JRDesignTextField && this.isDetailPlaceholder(field = (JRDesignTextField)copyElement)) {
                JRDesignExpression jre = new JRDesignExpression();
                jre.setText(fieldValue);
                field.setExpression((JRExpression)jre);
            }
            detailCell.addElement(copyElement);
        }
        return col;
    }

    private void createGroupCell(DesignCell groupCell, int groupIndex, int newGroupWidth, JRDesignExpression groupExpression, JasperDesign jd) {
        List<JRDesignElement> groupHeaderContent = null;
        if (this.tableGroupField.size() > groupIndex) {
            groupHeaderContent = this.tableGroupField.get(groupIndex);
        } else if (!this.tableGroupField.isEmpty()) {
            groupHeaderContent = this.tableGroupField.get(this.tableGroupField.size() - 1);
        }
        if (groupHeaderContent != null) {
            for (JRDesignElement element : groupHeaderContent) {
                JRDesignTextField field;
                JRDesignElement copyElement = (JRDesignElement)element.clone();
                copyElement.setX(this.getRelativeWidth(newGroupWidth, copyElement.getX(), this.templateGroupWidth));
                copyElement.setWidth(this.getRelativeWidth(newGroupWidth, copyElement.getWidth(), this.templateGroupWidth));
                if (copyElement instanceof JRDesignTextField && this.isGroupPlaceholder(field = (JRDesignTextField)copyElement)) {
                    field.setExpression((JRExpression)groupExpression);
                }
                groupCell.addElement(copyElement);
            }
        } else {
            JRDesignTextField sText = new MTextField().createJRElement(jd, true);
            sText.setWidth(newGroupWidth);
            sText.setHeight(groupCell.getHeight().intValue());
            sText.setX(0);
            sText.setY(0);
            sText.setExpression((JRExpression)groupExpression);
            groupCell.addElement((JRDesignElement)sText);
        }
    }

    private boolean isColumnHeaderPlaceholder(JRDesignStaticText element) {
        return element.getText() != null && element.getText().toLowerCase().equals(TEXT_MARKER);
    }

    private boolean isDetailPlaceholder(JRDesignTextField element) {
        JRExpression expression = element.getExpression();
        if (expression != null && expression.getText() != null) {
            String text = expression.getText().toLowerCase();
            if (text.startsWith("\"")) {
                text = text.substring(1);
            }
            if (text.endsWith("\"")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.equals(FIELD_MARKER) || text.equals(FIELD_COMPATIBILITY_MARKER)) {
                return true;
            }
        }
        return false;
    }

    private boolean isGroupPlaceholder(JRDesignTextField element) {
        JRExpression expression = element.getExpression();
        if (expression != null && expression.getText() != null) {
            String text = expression.getText().toLowerCase();
            if (text.startsWith("\"")) {
                text = text.substring(1);
            }
            if (text.endsWith("\"")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.equals(GROUP_MARKER)) {
                return true;
            }
        }
        return false;
    }

    private int getRelativeWidth(int newColwidth, int elementWidth) {
        return this.getRelativeWidth(newColwidth, elementWidth, this.columnWidth);
    }

    private int getRelativeWidth(int newColwidth, int elementWidth, int colWidth) {
        return newColwidth * elementWidth / colWidth;
    }

    protected void createGroupColumn(StandardTable tbl, JRPropertiesMap tableMap, JasperDesign jd, String fieldName, String fieldValue, int colWidth, StandardColumnGroup parentCol) {
        parentCol.addColumn((BaseColumn)this.generateColumn(tbl, tableMap, jd, fieldName, fieldValue, colWidth));
    }

    private void createColumn(StandardTable tbl, JRPropertiesMap tableMap, JasperDesign jd, String fieldName, String fieldValue, int colWidth) {
        tbl.addColumn((BaseColumn)this.generateColumn(tbl, tableMap, jd, fieldName, fieldValue, colWidth));
    }

    private int getTableHeight(BaseColumn col) {
        StandardColumn standardCol;
        int height = 0;
        if (col.getTableHeader() != null) {
            height += col.getTableHeader().getHeight().intValue();
        }
        if (col.getTableFooter() != null) {
            height += col.getTableFooter().getHeight().intValue();
        }
        if (col.getColumnHeader() != null) {
            height += col.getColumnHeader().getHeight().intValue();
        }
        if (col.getColumnFooter() != null) {
            height += col.getColumnFooter().getHeight().intValue();
        }
        for (GroupCell cell : col.getGroupFooters()) {
            height += cell.getCell().getHeight().intValue();
        }
        for (GroupCell cell : col.getGroupHeaders()) {
            height += cell.getCell().getHeight().intValue();
        }
        if (col instanceof StandardColumnGroup) {
            StandardColumnGroup groupCol = (StandardColumnGroup)col;
            height += this.getTableHeight((BaseColumn)groupCol.getColumns().get(0));
        }
        if (col instanceof StandardColumn && (standardCol = (StandardColumn)col).getDetailCell() != null) {
            height += standardCol.getDetailCell().getHeight().intValue();
        }
        return height;
    }

    private JRDesignElement getTable(JasperDesign jd, JRDesignDatasetRun datasetRun) {
        JRDesignComponentElement jrElement = new JRDesignComponentElement();
        StandardTable tbl = new StandardTable();
        jrElement.setComponent((Component)tbl);
        jrElement.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "table"));
        tbl.setDatasetRun((JRDatasetRun)datasetRun);
        JRPropertiesMap tableMap = jrElement.getPropertiesMap();
        if (this.tableFields != null && this.tableFields.size() > 0) {
            int colWidth = this.columnWidth;
            if (this.columnWidth * this.tableFields.size() > this.tableWidth) {
                colWidth = this.tableWidth / this.tableFields.size();
            }
            if (this.sections == null) {
                this.sections = TableWizardLayoutPage.getDefaultSection();
            }
            if (this.groupFields != null && this.groupFields.size() > 0) {
                int groupColWidth = colWidth * this.tableFields.size();
                StandardColumnGroup parentCol = new StandardColumnGroup();
                parentCol.setWidth(Integer.valueOf(groupColWidth));
                for (Object f : this.tableFields) {
                    this.createGroupColumn(tbl, tableMap, jd, ((JRField)f).getName(), "$F{" + ((JRField)f).getName() + "}", colWidth, parentCol);
                }
                int height = this.sections.getGroupHeaderHeight();
                int groupIndex = 0;
                for (Object field : this.groupFields) {
                    JRDesignField groupField = (JRDesignField)field;
                    DesignCell cell = new DesignCell();
                    cell.setHeight(Integer.valueOf(height));
                    JRDesignExpression groupExpression = (JRDesignExpression)ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)("$F{" + groupField.getName() + "}"), (String)groupField.getValueClassName());
                    this.createGroupCell(cell, groupIndex, groupColWidth, groupExpression, jd);
                    parentCol.setGroupHeader(groupField.getName(), (Cell)cell);
                    ++groupIndex;
                }
                tbl.addColumn((BaseColumn)parentCol);
                int minimumHeight = this.getTableHeight((BaseColumn)parentCol);
                if (this.tableHeight < minimumHeight) {
                    this.tableHeight = minimumHeight;
                }
            } else {
                for (Object f : this.tableFields) {
                    this.createColumn(tbl, tableMap, jd, ((JRField)f).getName(), "$F{" + ((JRField)f).getName() + "}", colWidth);
                }
                int minimumHeight = this.getTableHeight((BaseColumn)((StandardColumn)tbl.getColumns().get(0)));
                if (this.tableHeight < minimumHeight) {
                    this.tableHeight = minimumHeight;
                }
            }
        } else {
            this.createColumn(tbl, tableMap, jd, "", "\"\"", 160);
        }
        ApplyTableStyleAction applyAction = this.stylesList != null ? new ApplyTableStyleAction(this.stylesList, (JRElement)jrElement) : new ApplyTableStyleAction(TableWizardLayoutPage.getDefaultStyle(), (JRElement)jrElement);
        applyAction.applayStyle(jd);
        return jrElement;
    }

    private List<JRDesignStyle> buildStylesList(JasperReportsContext jrContext, JasperDesign jd) {
        JSSReportConverter templateConverter = new JSSReportConverter(jrContext, (JRReport)jd, true);
        JRDesignStyle[] result = new JRDesignStyle[4];
        if (templateConverter.getStylesMap().get("Table_TH") != null) {
            result[1] = (JRDesignStyle)templateConverter.getStylesMap().get("Table_TH");
        }
        if (templateConverter.getStylesMap().get("Table_CH") != null) {
            result[2] = (JRDesignStyle)templateConverter.getStylesMap().get("Table_CH");
        }
        if (templateConverter.getStylesMap().get("Table_TD") != null) {
            result[3] = (JRDesignStyle)templateConverter.getStylesMap().get("Table_TD");
        }
        if (result[1] == null || result[2] == null || result[3] == null) {
            TableStyle defaultPattern = new TableStyle(AlfaRGB.getFullyOpaque((RGB)ColorConstants.white.getRGB()), ColorSchemaGenerator.SCHEMAS.PALE, TableStyle.BorderStyleEnum.FULL, AlfaRGB.getFullyOpaque((RGB)ColorConstants.black.getRGB()), false);
            ApplyTableStyleAction stylesGenerator = new ApplyTableStyleAction(defaultPattern, null);
            List<JRDesignStyle> defaultStyles = stylesGenerator.createStyles(jd);
            defaultStyles.get(1).setBackcolor(Color.white);
            defaultStyles.get(2).setBackcolor(Color.white);
            defaultStyles.get(3).setBackcolor(Color.white);
            if (result[1] == null) {
                result[1] = defaultStyles.get(1);
            }
            if (result[2] == null) {
                result[2] = defaultStyles.get(2);
            }
            if (result[3] == null) {
                result[3] = defaultStyles.get(3);
            }
        }
        return new ArrayList<JRDesignStyle>(Arrays.asList(result));
    }

    private static JRDesignComponentElement getTable(JasperDesign jd) {
        if (jd.getSummary() == null) {
            return null;
        }
        for (JRChild child : jd.getSummary().getChildren()) {
            JRDesignComponentElement component;
            if (!(child instanceof JRDesignComponentElement) || !((component = (JRDesignComponentElement)child).getComponent() instanceof StandardTable)) continue;
            return component;
        }
        return null;
    }

    private void addSectionElementsToList(Cell section, List<JRDesignElement> currentList) {
        if (section != null) {
            for (JRChild child : section.getChildren()) {
                if (!(child instanceof JRDesignElement)) continue;
                currentList.add((JRDesignElement)child);
            }
        }
    }

    private void generateTableContentList(StandardTable table) {
        StandardColumn firstCol = TableTemplateEngine.getStandadColumn((BaseColumn)table.getColumns().get(0));
        this.tableHeaderContent = new ArrayList<JRDesignElement>();
        this.addSectionElementsToList(firstCol.getTableHeader(), this.tableHeaderContent);
        this.tableFooterContent = new ArrayList<JRDesignElement>();
        this.addSectionElementsToList(firstCol.getTableFooter(), this.tableFooterContent);
        this.colHeaderContent = new ArrayList<JRDesignElement>();
        this.addSectionElementsToList(firstCol.getColumnHeader(), this.colHeaderContent);
        this.colFooterContent = new ArrayList<JRDesignElement>();
        this.addSectionElementsToList(firstCol.getColumnFooter(), this.colFooterContent);
        this.detailContent = new ArrayList<JRDesignElement>();
        this.addSectionElementsToList(firstCol.getDetailCell(), this.detailContent);
        this.tableGroupField = new ArrayList<List<JRDesignElement>>();
        StandardColumnGroup groupColumn = TableTemplateEngine.getStandadGroupColumn((BaseColumn)table.getColumns().get(0));
        if (groupColumn != null) {
            this.templateGroupWidth = groupColumn.getWidth();
            for (GroupCell cell : groupColumn.getGroupHeaders()) {
                if (cell.getCell() == null) continue;
                ArrayList<JRDesignElement> cellContent = new ArrayList<JRDesignElement>();
                this.addSectionElementsToList(cell.getCell(), cellContent);
                this.tableGroupField.add(cellContent);
            }
        }
    }

    protected void processTemplate(JasperReportsContext jrContext, JasperDesign jd, List<Object> fields, List<Object> groupFields) {
        this.stylesList = this.buildStylesList(jrContext, jd);
        JRDesignComponentElement tableComponent = TableTemplateEngine.getTable(jd);
        this.summaryHeight = jd.getSummary().getHeight();
        if (tableComponent != null) {
            StandardTable table = (StandardTable)tableComponent.getComponent();
            this.tableWidth = tableComponent.getWidth();
            this.templateGroupWidth = tableComponent.getWidth();
            this.tableHeight = tableComponent.getHeight();
            this.columnWidth = ((BaseColumn)table.getColumns().get(0)).getWidth();
            this.tableX = tableComponent.getX();
            this.tableY = tableComponent.getY();
            this.generateTableContentList(table);
            if (table.getColumns().size() > 0) {
                StandardColumn col = TableTemplateEngine.getStandadColumn((BaseColumn)table.getColumns().get(0));
                boolean tableHeader = col.getTableHeader() != null;
                boolean tableFooter = col.getTableFooter() != null;
                boolean columnHeader = col.getColumnHeader() != null;
                boolean columnFooter = col.getColumnFooter() != null;
                boolean groupHeader = col.getGroupHeaders() != null && col.getGroupHeaders().size() > 0;
                boolean groupFooter = col.getGroupFooters() != null && col.getGroupFooters().size() > 0;
                this.sections = new TableSections(tableHeader, tableFooter, columnHeader, columnFooter, groupHeader, groupFooter);
                if (tableHeader) {
                    this.sections.setTableHeaderHeight(col.getTableHeader().getHeight());
                }
                if (tableFooter) {
                    this.sections.setTableFooterHeight(col.getTableFooter().getHeight());
                }
                if (columnHeader) {
                    this.sections.setColumnHeaderHeight(col.getColumnHeader().getHeight());
                }
                if (columnFooter) {
                    this.sections.setColumnFooterHeight(col.getColumnFooter().getHeight());
                }
                if (groupHeader) {
                    this.sections.setGroupHeaderHeight(((GroupCell)col.getGroupHeaders().get(0)).getCell().getHeight());
                }
                if (groupFooter) {
                    this.sections.setGroupHeaderHeight(((GroupCell)col.getGroupFooters().get(0)).getCell().getHeight());
                }
                this.sections.setDetailHeight(col.getDetailCell().getHeight());
            }
            this.removeElement((JRElementGroup)jd.getSummary(), (JRDesignElement)tableComponent);
        } else {
            JRDesignStaticText colHeaderLabel = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)jd.getColumnHeader(), (String)"Label");
            JRDesignTextField cellField = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)jd.getDetailSection().getBands()[0], (String)"Field");
            this.tableHeaderContent = new ArrayList<JRDesignElement>();
            this.tableFooterContent = new ArrayList<JRDesignElement>();
            this.colFooterContent = new ArrayList<JRDesignElement>();
            this.colHeaderContent = new ArrayList<JRDesignElement>();
            this.detailContent = new ArrayList<JRDesignElement>();
            this.tableGroupField = new ArrayList<List<JRDesignElement>>();
            ArrayList<JRDesignTextField> fakeGroupPlaceHolder = new ArrayList<JRDesignTextField>();
            JRDesignTextField groupElement = new MTextField().createJRElement(jd, true);
            groupElement.setExpression(ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)"$F{Group1}", (String)"java.Lang.Object"));
            fakeGroupPlaceHolder.add(groupElement);
            this.tableGroupField.add(fakeGroupPlaceHolder);
            if (colHeaderLabel != null) {
                this.colHeaderContent.add((JRDesignElement)colHeaderLabel);
            }
            if (cellField != null) {
                this.detailContent.add((JRDesignElement)cellField);
            }
            this.tableWidth = jd.getPageWidth() - jd.getLeftMargin() - jd.getRightMargin();
            if (jd.getSummary() == null) {
                jd.setSummary((JRBand)MBand.createJRBand());
                ((JRDesignBand)jd.getSummary()).setHeight(jd.getDetailSection().getBands()[0].getHeight());
            }
            this.tableHeight = jd.getSummary().getHeight();
            this.tableX = 0;
            this.tableY = 0;
            this.sections = new TableSections(false, false, true, true, false, false);
            JRDesignElementGroup summaryBand = (JRDesignElementGroup)jd.getSummary();
            for (JRChild child : summaryBand.getChildren()) {
                summaryBand.removeElement((JRDesignElement)child);
            }
        }
        this.removeUnwantedBand(jd);
        jd.removeDataset("tableDataset");
    }

    private void removeUnwantedBand(JasperDesign jd) {
        jd.setColumnHeader(null);
        jd.setColumnFooter(null);
        JRDesignSection bandSection = (JRDesignSection)jd.getDetailSection();
        JRBand[] jRBandArray = jd.getDetailSection().getBands();
        int n = jRBandArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRBand actualDetail = jRBandArray[n2];
            bandSection.removeBand(actualDetail);
            ++n2;
        }
        while (jd.getGroupsList().size() > 0) {
            jd.getGroupsList().remove(0);
        }
    }

    public static JRDesignStaticText findStaticTextElement(StandardTable parent, String exp) {
        StandardColumn col = TableTemplateEngine.getStandadColumn((BaseColumn)parent.getColumns().get(0));
        if (col != null) {
            JRDesignStaticText result = null;
            if (col.getTableHeader() != null) {
                result = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)col.getTableHeader(), (String)exp);
            }
            if (col.getColumnHeader() != null && result == null) {
                result = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)col.getColumnHeader(), (String)exp);
            }
            if (col.getDetailCell() != null && result == null) {
                result = DefaultTemplateEngine.findStaticTextElement((JRElementGroup)col.getDetailCell(), (String)exp);
            }
            return result;
        }
        return null;
    }

    public static JRDesignTextField findTextFieldElement(StandardTable parent, String exp) {
        StandardColumn col = TableTemplateEngine.getStandadColumn((BaseColumn)parent.getColumns().get(0));
        if (col != null) {
            JRDesignTextField result = null;
            if (col.getTableHeader() != null) {
                result = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)col.getTableHeader(), (String)exp);
            }
            if (col.getColumnHeader() != null && result == null) {
                result = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)col.getColumnHeader(), (String)exp);
            }
            if (col.getDetailCell() != null && result == null) {
                result = DefaultTemplateEngine.findTextFieldElement((JRElementGroup)col.getDetailCell(), (String)exp);
            }
            return result;
        }
        return null;
    }

    private static StandardColumn getStandadColumn(BaseColumn container) {
        if (container instanceof StandardColumnGroup) {
            return TableTemplateEngine.getStandadColumn((BaseColumn)((StandardColumnGroup)container).getColumns().get(0));
        }
        if (container instanceof StandardColumn) {
            return (StandardColumn)container;
        }
        return null;
    }

    private static StandardColumnGroup getStandadGroupColumn(BaseColumn container) {
        if (container instanceof StandardColumnGroup) {
            return (StandardColumnGroup)container;
        }
        return null;
    }

    public void setReportDataAdapter(ReportBundle bundle, DataAdapterDescriptor dataadapter, JRPropertiesMap properties, JasperReportsConfiguration jConf) {
        JRDesignDataset tableDataset = (JRDesignDataset)bundle.getJasperDesign().getDatasetMap().get("tableDataset");
        JasperDesign jd = bundle.getJasperDesign();
        String[] stringArray = properties.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            jd.setProperty(key, properties.getProperty(key));
            if (key.contains("ireport")) {
                tableDataset.setProperty(key, properties.getProperty(key));
            }
            ++n2;
        }
        tableDataset.setProperty("com.jaspersoft.studio.data.defaultdataadapter", dataadapter.getName());
        jConf.getEditorContext().setDataAdapter(dataadapter, jd);
        JRDesignDataset mainDataset = jd.getMainDesignDataset();
        ((JRDesignQuery)mainDataset.getQuery()).setText(null);
        ((JRDesignQuery)mainDataset.getQuery()).setLanguage(null);
        JRField[] jRFieldArray = mainDataset.getFields();
        int n3 = jRFieldArray.length;
        n = 0;
        while (n < n3) {
            JRField field = jRFieldArray[n];
            mainDataset.removeField(field);
            ++n;
        }
    }

    public ReportBundle generateReportBundle(TemplateBundle template, Map<String, Object> settings, JasperReportsContext jContext) throws TemplateEngineException {
        ReportBundle reportBundle = super.generateReportBundle(template, settings, jContext);
        this.tableFields = (List)settings.get("main_fields");
        JRDesignDataset tableDataset = new JRDesignDataset(jContext, false);
        tableDataset.setName("tableDataset");
        JRDesignDataset dataset = (JRDesignDataset)settings.get("main_dataset");
        JRDesignQuery query = new JRDesignQuery();
        if (dataset != null) {
            query.setLanguage(dataset.getQuery().getLanguage());
            query.setText(dataset.getQuery().getText());
        }
        tableDataset.setQuery(query);
        if (this.tableFields != null) {
            for (Object field : this.tableFields) {
                try {
                    tableDataset.addField((JRField)((JRDesignField)field));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        this.groupFields = (List)settings.get("main_group_fields");
        if (this.groupFields != null) {
            for (Object field : this.groupFields) {
                try {
                    JRDesignGroup newGroup = new JRDesignGroup();
                    JRDesignField groupField = (JRDesignField)field;
                    newGroup.setName(groupField.getName());
                    JRDesignExpression groupExpression = (JRDesignExpression)ExprUtil.setValues((JRExpression)new JRDesignExpression(), (Object)("$F{" + groupField.getName() + "}"), (String)groupField.getValueClassName());
                    newGroup.setExpression((JRExpression)groupExpression);
                    tableDataset.addGroup(newGroup);
                    if (!this.createSortFields) continue;
                    JRDesignSortField sortfield = new JRDesignSortField();
                    sortfield.setType(SortFieldTypeEnum.FIELD);
                    sortfield.setOrder(SortOrderEnum.DESCENDING);
                    sortfield.setName(groupField.getName());
                    tableDataset.addSortField((JRSortField)sortfield);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("$P{REPORT_CONNECTION}");
        datasetRun.setConnectionExpression((JRExpression)exp);
        datasetRun.setDatasetName("tableDataset");
        try {
            reportBundle.getJasperDesign().addDataset(tableDataset);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        JasperDesign jd = reportBundle.getJasperDesign();
        jd.setWhenNoDataType(WhenNoDataTypeEnum.ALL_SECTIONS_NO_DETAIL);
        JRDesignElement table = this.getTable(jd, datasetRun);
        JRDesignBand summaryBand = (JRDesignBand)jd.getSummary();
        if (summaryBand == null) {
            summaryBand = MBand.createJRBand();
            jd.setSummary((JRBand)summaryBand);
        }
        summaryBand.setHeight(this.summaryHeight);
        table.setWidth(this.tableWidth);
        table.setHeight(this.tableHeight);
        table.setX(this.tableX);
        table.setY(this.tableY);
        summaryBand.addElement(table);
        return reportBundle;
    }

    public static List<String> validateJasperDesig(JasperReportsContext jrContext, JasperDesign design) {
        JRDesignComponentElement tableComponent;
        ArrayList<String> errorsList = new ArrayList<String>();
        boolean[] foundedStyles = new boolean[3];
        JSSReportConverter templateConverter = new JSSReportConverter(jrContext, (JRReport)design, true);
        if (templateConverter.getStylesMap().get("Table_TH") != null) {
            foundedStyles[0] = true;
        }
        if (templateConverter.getStylesMap().get("Table_CH") != null) {
            foundedStyles[1] = true;
        }
        if (templateConverter.getStylesMap().get("Table_TD") != null) {
            foundedStyles[2] = true;
        }
        if (!foundedStyles[0]) {
            errorsList.add(Messages.TableTemplateEngine_missingStyleTH);
        }
        if (!foundedStyles[1]) {
            errorsList.add(Messages.TableTemplateEngine_missingStyleCH);
        }
        if (!foundedStyles[2]) {
            errorsList.add(Messages.TableTemplateEngine_missingStyleD);
        }
        if ((tableComponent = TableTemplateEngine.getTable(design)) == null) {
            errorsList.add(Messages.TableTemplateEngine_missingTable);
        } else {
            StandardTable table = (StandardTable)tableComponent.getComponent();
            if (table.getColumns().size() > 1 || table.getColumns().size() < 1) {
                errorsList.add(Messages.TableTemplateEngine_oneColumnError);
            } else {
                if (TableTemplateEngine.findStaticTextElement(table, TEXT_MARKER) == null) {
                    errorsList.add(MessageFormat.format(Messages.TableTemplateEngine_missingStaticText, TEXT_MARKER));
                }
                if (TableTemplateEngine.findTextFieldElement(table, FIELD_MARKER) == null) {
                    errorsList.add(MessageFormat.format(Messages.TableTemplateEngine_missingTextField, FIELD_MARKER));
                }
            }
        }
        return errorsList;
    }
}

