/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.list.commands.element;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.list.model.MList;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.Map;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateElementCommand
extends Command {
    protected MGraphicElement srcNode;
    protected JRDesignElement jrElement;
    private JasperDesign jDesign;
    private StandardListComponent listcomponent;
    private Rectangle location;
    private int index;
    private JRPropertiesHolder[] pholder;
    private MList destNode;
    private JSSCompoundCommand commands;
    private Map<JRElement, Rectangle> map;
    private boolean firstTime = true;
    private JRDesignComponentElement jrElement2;

    public CreateElementCommand(MList destNode, MGraphicElement srcNode, Rectangle position, int index) {
        this.destNode = destNode;
        this.srcNode = srcNode;
        if (srcNode != null) {
            this.jrElement = srcNode.getValue();
        }
        this.jrElement2 = destNode.getValue();
        this.listcomponent = (StandardListComponent)this.jrElement2.getComponent();
        this.index = index;
        this.location = position;
        this.jDesign = destNode.getJasperDesign();
        this.pholder = destNode.getPropertyHolder();
    }

    protected void createObject() {
        if (this.jrElement == null) {
            this.jrElement = this.srcNode.createJRElement(this.srcNode.getJasperDesign());
        }
        if (this.jrElement != null) {
            this.setElementBounds();
        }
    }

    protected void setElementBounds() {
        if (this.location == null) {
            this.location = new Rectangle(0, 0, this.srcNode.getDefaultWidth(), this.srcNode.getDefaultHeight());
        }
        if (this.location.width < 0) {
            this.location.width = this.srcNode.getDefaultWidth();
        }
        if (this.location.height < 0) {
            this.location.height = this.srcNode.getDefaultHeight();
        }
        this.jrElement.setX(this.location.x);
        this.jrElement.setY(this.location.y);
        this.jrElement.setWidth(this.location.width);
        this.jrElement.setHeight(this.location.height);
    }

    public void setJrGroup(StandardListComponent jrGroup) {
        this.listcomponent = jrGroup;
    }

    public void execute() {
        this.createObject();
        if (this.jrElement != null) {
            this.removeElements(this.jrElement);
            DesignListContents dlist = (DesignListContents)this.listcomponent.getContents();
            if (this.index < 0 || this.index > dlist.getChildren().size()) {
                dlist.addElement(this.jrElement);
            } else {
                dlist.addElement(this.index, this.jrElement);
            }
            ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])this.pholder, (JasperDesign)this.jDesign, (String)this.jrElement2.getUUID().toString());
            this.map = layout.layout(this.jDesign, (JRElementGroup)dlist, dlist.getElements(), new Dimension(this.jrElement.getWidth(), this.jrElement.getHeight()));
        }
        if (this.firstTime) {
            SelectionHelper.setSelection((JRChild)this.jrElement, (boolean)false);
            this.firstTime = false;
        }
        this.executeCommands();
        LayoutManager.layoutContainer((ANode)this.destNode);
    }

    protected void addCommand(Command command) {
        if (this.commands == null) {
            this.commands = new JSSCompoundCommand((ANode)this.srcNode);
        }
        this.commands.add(command);
    }

    protected void executeCommands() {
        if (this.commands != null) {
            this.commands.execute();
        }
    }

    public boolean canUndo() {
        return this.listcomponent != null && this.jrElement != null;
    }

    public void undo() {
        if (this.commands != null) {
            this.commands.undo();
        }
        for (JRElement el : this.map.keySet()) {
            JRDesignElement del = (JRDesignElement)el;
            Rectangle r = this.map.get(el);
            del.setX(r.x);
            del.setY(r.y);
            del.setWidth(r.width);
            del.setHeight(r.height);
        }
        DesignListContents dlist = (DesignListContents)this.listcomponent.getContents();
        dlist.removeElement(this.jrElement);
        LayoutManager.layoutContainer((ANode)this.destNode);
    }

    private void removeElements(JRDesignElement element) {
        com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JasperDesign)this.jDesign, (JRDesignElement)this.jrElement);
        DesignListContents dlist = (DesignListContents)this.listcomponent.getContents();
        com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])dlist.getElements());
    }
}

