/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata;

import com.jaspersoft.studio.components.map.model.itemdata.ElementDataHelper;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementDTO;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemProperty;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class ElementsTreeStatus {
    private List<ItemProperty> names;
    private LAST_OPERATION lastOperationPerformed;
    private int level1SelectionIdx = -1;
    private int level2SelectionIdx = -1;

    public int getLevel1SelectionIdx() {
        return this.level1SelectionIdx;
    }

    public void setLevel1SelectionIdx(int level1SelectionIdx) {
        this.level1SelectionIdx = level1SelectionIdx;
    }

    public int getLevel2SelectionIdx() {
        return this.level2SelectionIdx;
    }

    public void setLevel2SelectionIdx(int level2SelectionIdx) {
        this.level2SelectionIdx = level2SelectionIdx;
    }

    public List<ItemProperty> getNames() {
        if (this.names == null) {
            this.names = new ArrayList<ItemProperty>();
        }
        return this.names;
    }

    public void setNames(List<ItemProperty> names) {
        this.names = names;
    }

    public LAST_OPERATION getLastOperationPerformed() {
        return this.lastOperationPerformed;
    }

    public void setLastOperationPerformed(LAST_OPERATION lastOperationPerformed) {
        this.lastOperationPerformed = lastOperationPerformed;
    }

    public void addName(ItemProperty name) {
        this.getNames().add(name);
    }

    public void addName(int index, ItemProperty name) {
        this.getNames().add(index, name);
    }

    public void removeName(ItemProperty name) {
        this.getNames().remove(name);
    }

    public Object[] findExpandedElements(List<MapDataElementDTO> candidates) {
        ArrayList<MapDataElementDTO> found = new ArrayList<MapDataElementDTO>();
        block0: for (MapDataElementDTO c : candidates) {
            for (ItemProperty n : this.getNames()) {
                if (!ElementDataHelper.areNamesEqual(n, c.getName())) continue;
                found.add(c);
                continue block0;
            }
        }
        return found.toArray();
    }

    public static ElementsTreeStatus getElementsTreeStatus(TreeViewer elementsTV, LAST_OPERATION lastOperation) {
        Object[] expandedElements = elementsTV.getExpandedElements();
        ElementsTreeStatus status = new ElementsTreeStatus();
        status.setLastOperationPerformed(lastOperation);
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (el instanceof MapDataElementDTO) {
                status.addName(((MapDataElementDTO)el).getName());
            }
            ++n2;
        }
        TreeItem[] selection = elementsTV.getTree().getSelection();
        if (selection.length == 1) {
            TreeItem i;
            int n3;
            int n4;
            TreeItem[] treeItemArray;
            TreeItem selItem = selection[0];
            TreeItem parentItem = selItem.getParentItem();
            if (parentItem != null) {
                int level2Idx = 0;
                treeItemArray = parentItem.getItems();
                n4 = treeItemArray.length;
                n3 = 0;
                while (n3 < n4) {
                    i = treeItemArray[n3];
                    if (i.equals(selItem)) {
                        status.setLevel2SelectionIdx(level2Idx);
                        selItem = parentItem;
                        break;
                    }
                    ++level2Idx;
                    ++n3;
                }
            }
            int level1Idx = 0;
            treeItemArray = elementsTV.getTree().getItems();
            n4 = treeItemArray.length;
            n3 = 0;
            while (n3 < n4) {
                i = treeItemArray[n3];
                if (i.equals(selItem)) {
                    status.setLevel1SelectionIdx(level1Idx);
                    break;
                }
                ++level1Idx;
                ++n3;
            }
        }
        return status;
    }

    public static ISelection getSuggestedSelection(TreeViewer elementsTV, ElementsTreeStatus status) {
        int level1Idx = status.getLevel1SelectionIdx();
        int level2Idx = status.getLevel2SelectionIdx();
        if (level1Idx >= 0 && level1Idx < elementsTV.getTree().getItemCount()) {
            TreeItem level1Item = elementsTV.getTree().getItem(level1Idx);
            if (level2Idx >= 0 && status.getLastOperationPerformed() != LAST_OPERATION.REMOVE) {
                switch (status.getLastOperationPerformed()) {
                    case MOVEUP: {
                        level2Idx = Math.max(0, level2Idx - 1);
                        break;
                    }
                    case MOVEDOWN: {
                        level2Idx = Math.min(level1Item.getItemCount() - 1, level2Idx + 1);
                        break;
                    }
                }
                return ElementsTreeStatus.getSuggestedSelection(level1Item, level2Idx);
            }
            return level1Item.getData() != null ? new StructuredSelection(level1Item.getData()) : StructuredSelection.EMPTY;
        }
        return StructuredSelection.EMPTY;
    }

    private static ISelection getSuggestedSelection(TreeItem item, int level) {
        TreeItem childItem;
        if (level >= 0 && (childItem = item.getItem(level)).getData() != null) {
            return new StructuredSelection(childItem.getData());
        }
        return StructuredSelection.EMPTY;
    }

    public static enum LAST_OPERATION {
        ADD,
        EDIT,
        REMOVE,
        MOVEUP,
        MOVEDOWN,
        REFRESH;

    }
}

