/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata.dialog;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.itemdata.ElementDataHelper;
import com.jaspersoft.studio.components.map.model.itemdata.ElementsListWidgetConfiguration;
import com.jaspersoft.studio.components.map.model.itemdata.dialog.ItemPropertyDialog;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementItemDTO;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ElementItemDialog
extends PersistentLocationDialog {
    private TableViewer propertiesTV;
    private Button btnAddProperty;
    private Button btnModifyProperty;
    private Button btnRemoveProperty;
    private MapDataElementItemDTO itemDTO;
    private StandardItem item;
    private ExpressionContext expContext;
    private List<String> mandatoryPropertyNames;
    private String[] allDatasetNames;
    private Combo datasetCombo;
    private Button datasetRBtn;
    private Button staticRBtn;
    private Map<String, String> elementDatasetsMap;
    private JasperReportsConfiguration jconfig;
    private ExpressionContext defaultExpressionContext;
    private ElementsListWidgetConfiguration wconfig;

    public ElementItemDialog(Shell parentShell, MapDataElementItemDTO itemDTO, ElementsListWidgetConfiguration wconfig, Map<String, String> elementDatasetsMap, JasperReportsConfiguration jconfig) {
        super(parentShell);
        this.itemDTO = itemDTO;
        this.item = (StandardItem)this.itemDTO.getItem();
        this.wconfig = wconfig;
        this.mandatoryPropertyNames = new ArrayList<String>();
        this.elementDatasetsMap = elementDatasetsMap;
        this.allDatasetNames = this.elementDatasetsMap.keySet().toArray(new String[0]);
        this.jconfig = jconfig;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout(1, false));
        Group itemKindGrp = new Group(dialogArea, 0);
        itemKindGrp.setText(NLS.bind((String)Messages.ElementItemDialog_ItemKind, (Object)this.wconfig.getElementTxt()));
        itemKindGrp.setLayout((Layout)new GridLayout(1, false));
        itemKindGrp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.staticRBtn = new Button((Composite)itemKindGrp, 16);
        this.staticRBtn.setText(Messages.ElementItemDialog_Static);
        this.staticRBtn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.datasetRBtn = new Button((Composite)itemKindGrp, 16);
        this.datasetRBtn.setText(Messages.ElementItemDialog_DatasetBased);
        this.datasetRBtn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.datasetCombo = new Combo((Composite)itemKindGrp, 8);
        GridData datasetComboGD = new GridData(16384, 4, false, false);
        datasetComboGD.widthHint = 200;
        datasetComboGD.horizontalIndent = 15;
        this.datasetCombo.setLayoutData((Object)datasetComboGD);
        Group propertiesGrp = new Group(dialogArea, 0);
        propertiesGrp.setText(Messages.ElementItemDialog_Properties);
        propertiesGrp.setLayout((Layout)new GridLayout(2, false));
        propertiesGrp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesTV = this.createPropertiesTable((Composite)propertiesGrp);
        this.propertiesTV.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.btnAddProperty = new Button((Composite)propertiesGrp, 8);
        this.btnAddProperty.setText(Messages.ElementItemDialog_Add);
        this.btnAddProperty.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnModifyProperty = new Button((Composite)propertiesGrp, 8);
        this.btnModifyProperty.setText(Messages.ElementItemDialog_Modify);
        this.btnModifyProperty.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnRemoveProperty = new Button((Composite)propertiesGrp, 8);
        this.btnRemoveProperty.setText(Messages.ElementItemDialog_Remove);
        this.btnRemoveProperty.setLayoutData((Object)new GridData(4, 128, false, false));
        this.initWidgets();
        this.attachListeners();
        this.enableDefaultButtons();
        return dialogArea;
    }

    private void initWidgets() {
        boolean staticItem = this.itemDTO.isStatic();
        this.staticRBtn.setSelection(staticItem);
        this.datasetRBtn.setSelection(!staticItem);
        this.datasetCombo.setEnabled(!staticItem);
        this.datasetCombo.setItems(this.allDatasetNames);
        if (!staticItem) {
            int index = Arrays.asList(this.allDatasetNames).indexOf(this.itemDTO.getDatasetName());
            this.datasetCombo.select(index);
        }
        this.propertiesTV.setInput((Object)this.item.getProperties());
    }

    private void attachListeners() {
        this.btnAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementItemDialog.this.addPropertyBtnPressed();
            }
        });
        this.btnModifyProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementItemDialog.this.modifyPropertyBtnPressed();
            }
        });
        this.btnRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementItemDialog.this.removePropertyBtnPressed();
            }
        });
        this.propertiesTV.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementItemDialog.this.modifyPropertyBtnPressed();
            }
        });
        this.propertiesTV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementItemDialog.this.enableDefaultButtons();
            }
        });
        this.staticRBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementItemDialog.this.datasetCombo.setEnabled(false);
                ElementItemDialog.this.datasetCombo.setItems(new String[0]);
                ElementItemDialog.this.itemDTO.setDatasetName(null);
                ElementItemDialog.this.computeExpressionContext();
            }
        });
        this.datasetRBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementItemDialog.this.datasetCombo.setEnabled(true);
                ElementItemDialog.this.datasetCombo.setItems(ElementItemDialog.this.allDatasetNames);
            }
        });
        this.datasetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementItemDialog.this.itemDTO.setDatasetName(ElementItemDialog.this.datasetCombo.getText());
                ElementItemDialog.this.computeExpressionContext();
            }
        });
    }

    private TableViewer createPropertiesTable(Composite parent) {
        Composite cmpItemPropertiesTableViewer = new Composite(parent, 0);
        cmpItemPropertiesTableViewer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        TableColumnLayout tl_itemPropertiesTableViewer = new TableColumnLayout();
        cmpItemPropertiesTableViewer.setLayout((Layout)tl_itemPropertiesTableViewer);
        TableViewer tv = new TableViewer(cmpItemPropertiesTableViewer, 68100);
        tv.getTable().setHeaderVisible(true);
        tv.getTable().setLinesVisible(true);
        TableViewerColumn tvcName = new TableViewerColumn(tv, 0);
        tvcName.getColumn().setText(Messages.ElementItemDialog_NameColumn);
        tvcName.setLabelProvider(this.getItemPropertyNameLabelProvider());
        tl_itemPropertiesTableViewer.setColumnData((Widget)tvcName.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        TableViewerColumn tvcValue = new TableViewerColumn(tv, 0);
        tvcValue.getColumn().setText(Messages.ElementItemDialog_ValueColumn);
        tvcValue.setLabelProvider(this.getItemPropertyValueLabelProvider());
        tl_itemPropertiesTableViewer.setColumnData((Widget)tvcValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        return tv;
    }

    private CellLabelProvider getItemPropertyValueLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ItemProperty) {
                    String value = ElementDataHelper.getItemPropertyValueAsString((ItemProperty)element);
                    return Misc.nvl((String)value);
                }
                return super.getText(element);
            }
        };
    }

    private CellLabelProvider getItemPropertyNameLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ItemProperty) {
                    return ((ItemProperty)element).getName();
                }
                return super.getText(element);
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)Messages.ElementItemDialog_DialogTitle, (Object)this.wconfig.getElementTxt()));
        UIUtils.resizeAndCenterShell((Shell)newShell, (int)500, (int)550);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    public boolean close() {
        return super.close();
    }

    public void setMandatoryPropertyNames(List<String> names) {
        this.mandatoryPropertyNames = names;
    }

    private void addPropertyBtnPressed() {
        ItemPropertyDialog dialog = new ItemPropertyDialog(UIUtils.getShell(), null, this.wconfig.getElementPropertiesResourceLocation());
        dialog.setExpressionContext(this.expContext);
        if (dialog.open() == 0) {
            this.item.addItemProperty(dialog.getItemProperty());
            this.refreshTable();
        }
    }

    private void modifyPropertyBtnPressed() {
        ItemProperty property = this.getCurrentSelectedProperty();
        if (property != null) {
            ItemProperty clonedP = (ItemProperty)property.clone();
            ItemPropertyDialog dialog = new ItemPropertyDialog(UIUtils.getShell(), clonedP, this.wconfig.getElementPropertiesResourceLocation());
            dialog.setExpressionContext(this.expContext);
            if (dialog.open() == 0) {
                this.item.removeItemProperty(property);
                this.item.addItemProperty(dialog.getItemProperty());
                this.refreshTable();
            }
        }
    }

    private void removePropertyBtnPressed() {
        ItemProperty property = this.getCurrentSelectedProperty();
        if (property != null) {
            if (this.isMandatoryProperty(property.getName())) {
                MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.ElementItemDialog_ErrorDialogTitle, (String)NLS.bind((String)Messages.ElementItemDialog_ErrorDialogMandatoryNameMsg, (Object)property.getName()));
            } else {
                this.item.removeItemProperty(property);
                this.refreshTable();
            }
        }
    }

    private void refreshTable() {
        this.propertiesTV.setInput((Object)this.item.getProperties());
        this.enableDefaultButtons();
    }

    private void enableDefaultButtons() {
        ItemProperty selP = this.getCurrentSelectedProperty();
        this.btnAddProperty.setEnabled(true);
        this.btnModifyProperty.setEnabled(selP != null);
        this.btnRemoveProperty.setEnabled(selP != null && !this.isMandatoryProperty(selP.getName()));
    }

    private boolean isMandatoryProperty(String pname) {
        for (String n : this.mandatoryPropertyNames) {
            if (!pname.equals(n)) continue;
            return true;
        }
        return false;
    }

    private ItemProperty getCurrentSelectedProperty() {
        Object selEl = ((IStructuredSelection)this.propertiesTV.getSelection()).getFirstElement();
        if (selEl instanceof ItemProperty) {
            return (ItemProperty)selEl;
        }
        return null;
    }

    public MapDataElementItemDTO getItemDTO() {
        return this.itemDTO;
    }

    public void setDefaultExpressionContext(ExpressionContext defaultExpressionContext) {
        this.defaultExpressionContext = defaultExpressionContext;
    }

    private void computeExpressionContext() {
        if (this.staticRBtn.getSelection()) {
            this.expContext = this.defaultExpressionContext;
        } else {
            String dsSelected = this.datasetCombo.getText();
            String dn = this.elementDatasetsMap.get(dsSelected);
            JRDesignDataset designDS = null;
            if (dn == null) {
                this.jconfig.getJasperDesign().getMainDesignDataset();
            } else {
                designDS = ModelUtils.getDesignDatasetByName((JasperDesign)this.jconfig.getJasperDesign(), (String)dn);
            }
            this.expContext = new ExpressionContext(designDS, this.jconfig);
        }
    }

    protected void okPressed() {
        if (this.datasetRBtn.getSelection() && this.datasetCombo.getText().isEmpty()) {
            MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.ElementItemDialog_ErrorDialogTitle, (String)Messages.ElementItemDialog_ErrorDialogNoDatasetMsg);
        } else {
            super.okPressed();
        }
    }
}

