/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata.dialog;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.itemdata.ElementsListWidgetConfiguration;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MapElementDialog
extends PersistentLocationDialog
implements IExpressionContextSetter {
    private Button useExpressionCheckbox;
    private Text propertyValue;
    private WTextExpression propertyValueExpression;
    private ExpressionContext expContext;
    private StandardItemProperty pname;
    private Composite dialogArea;
    private ElementsListWidgetConfiguration wconfig;

    public MapElementDialog(Shell parentShell, ItemProperty pname, ElementsListWidgetConfiguration wconfig) {
        super(parentShell);
        this.pname = (StandardItemProperty)pname;
        this.wconfig = wconfig;
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = (Composite)super.createDialogArea(parent);
        this.dialogArea.setLayout((Layout)new GridLayout(1, false));
        this.useExpressionCheckbox = new Button(this.dialogArea, 32);
        this.useExpressionCheckbox.setText(Messages.MapElementDialog_UseExpression);
        this.useExpressionCheckbox.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblPropertyValue = new Label(this.dialogArea, 0);
        lblPropertyValue.setText(Messages.MapElementDialog_PropertyValue);
        lblPropertyValue.setLayoutData((Object)new GridData(4, 4, true, false));
        this.propertyValue = new Text(this.dialogArea, 2048);
        GridData gd_propertyValue = new GridData(4, 4, true, false);
        this.propertyValue.setLayoutData((Object)gd_propertyValue);
        this.propertyValueExpression = new WTextExpression(this.dialogArea, 0);
        GridData gd_propertyValueExpression = new GridData(4, 4, true, true);
        gd_propertyValueExpression.heightHint = 50;
        gd_propertyValueExpression.widthHint = 250;
        this.propertyValueExpression.setLayoutData((Object)gd_propertyValueExpression);
        this.propertyValueExpression.setExpressionContext(this.expContext);
        this.initWidgets();
        this.addListeners();
        return this.dialogArea;
    }

    private void initWidgets() {
        if (this.pname.getValue() != null) {
            this.useExpressionCheckbox.setSelection(false);
            this.propertyValue.setText(this.pname.getValue());
            this.propertyValueExpression.setVisible(false);
            this.propertyValueExpression.setEnabled(false);
            this.propertyValueExpression.setExpression(null);
            ((GridData)this.propertyValueExpression.getLayoutData()).exclude = true;
        } else {
            this.useExpressionCheckbox.setSelection(true);
            this.propertyValueExpression.setExpression((JRDesignExpression)this.pname.getValueExpression());
            this.propertyValue.setVisible(false);
            this.propertyValue.setEnabled(false);
            ((GridData)this.propertyValue.getLayoutData()).exclude = true;
        }
    }

    private void addListeners() {
        this.propertyValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapElementDialog.this.pname.setValue(MapElementDialog.this.propertyValue.getText());
            }
        });
        this.propertyValueExpression.addModifyListener(new ExpressionModifiedListener(){

            public void expressionModified(ExpressionModifiedEvent event) {
                MapElementDialog.this.pname.setValueExpression(event.modifiedExpression);
            }
        });
        this.useExpressionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MapElementDialog.this.useExpressionCheckbox.getSelection()) {
                    MapElementDialog.this.propertyValue.setText("");
                    MapElementDialog.this.pname.setValue(null);
                    MapElementDialog.this.propertyValue.setVisible(false);
                    MapElementDialog.this.propertyValue.setEnabled(false);
                    ((GridData)MapElementDialog.this.propertyValue.getLayoutData()).exclude = true;
                    MapElementDialog.this.propertyValueExpression.setVisible(true);
                    MapElementDialog.this.propertyValueExpression.setEnabled(true);
                    ((GridData)MapElementDialog.this.propertyValueExpression.getLayoutData()).exclude = false;
                } else {
                    MapElementDialog.this.propertyValueExpression.setVisible(false);
                    MapElementDialog.this.propertyValueExpression.setEnabled(false);
                    MapElementDialog.this.propertyValueExpression.setExpression(null);
                    ((GridData)MapElementDialog.this.propertyValueExpression.getLayoutData()).exclude = true;
                    MapElementDialog.this.propertyValue.setText("");
                    MapElementDialog.this.propertyValue.setVisible(true);
                    MapElementDialog.this.propertyValue.setEnabled(true);
                    ((GridData)MapElementDialog.this.propertyValue.getLayoutData()).exclude = false;
                }
                MapElementDialog.this.dialogArea.layout();
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)Messages.MapElementDialog_DialogTitle, (Object)this.wconfig.getElementTxt()));
        UIUtils.resizeAndCenterShell((Shell)newShell, (int)450, (int)270);
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public ItemProperty getElementName() {
        return this.pname;
    }

    protected void okPressed() {
        if (this.wconfig.isElementNameMandatory()) {
            String value = this.pname.getValue();
            JRExpression valueExpression = this.pname.getValueExpression();
            if ((value == null || value.isEmpty()) && (valueExpression == null || valueExpression.getText() == null || valueExpression.getText().isEmpty())) {
                MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.MapElementDialog_ErrorDialogTitle, (String)NLS.bind((String)Messages.MapElementDialog_ErrorDialogMsg, (Object)this.wconfig.getElementTxt()));
                return;
            }
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

