/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.marker.dialog;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.property.infoList.ElementDescription;
import com.jaspersoft.studio.property.infoList.SelectableComposite;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import java.util.List;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MarkerPropertyDialog
extends Dialog {
    private StandardItemProperty value;
    private Composite vexp;
    private Composite vcmp;
    private StackLayout stackLayout;
    private Text tvalue;
    private Button buseexpr;
    private WTextExpression evalue;
    private Text cprop;
    private ExpressionContext expContext;
    private String propsDescFile;
    private boolean isMandatory = false;
    private boolean isRefresh = false;
    private Composite stackComposite;

    public MarkerPropertyDialog(Shell parentShell, String propsDescFile) {
        super(parentShell);
        this.propsDescFile = propsDescFile;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MarkerPropertyDialog_DialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.MarkerPropertyDialog_PropertyName);
        this.cprop = new Text(composite, 2048);
        this.cprop.setLayoutData((Object)new GridData(768));
        this.cprop.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MarkerPropertyDialog.this.value.setName(MarkerPropertyDialog.this.cprop.getText());
            }
        });
        this.buseexpr = new Button(composite, 32);
        this.buseexpr.setText(Messages.MarkerPropertyDialog_UseExpression);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.buseexpr.setLayoutData((Object)gd);
        this.stackComposite = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.stackComposite.setLayoutData((Object)gd);
        this.vcmp = this.createValueControl(this.stackComposite);
        this.vexp = this.createValueExpressionControl(this.stackComposite);
        this.stackLayout.topControl = this.vcmp;
        this.buseexpr.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPropertyDialog.this.changeValueOrExpression();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        List propertyDescriptions = ElementDescription.getPropertiesInformation((String)this.propsDescFile);
        if (!propertyDescriptions.isEmpty()) {
            final SelectableComposite infoPanel = new SelectableComposite(composite);
            infoPanel.setItems(propertyDescriptions);
            GridData infoGD = new GridData(4, 4, true, true, 2, 1);
            infoGD.heightHint = 200;
            infoGD.widthHint = 500;
            infoGD.verticalIndent = 5;
            infoPanel.setLayoutData((Object)infoGD);
            infoPanel.SetDoubleClickListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MarkerPropertyDialog.this.cprop.setText(infoPanel.getSelectedElement().getName());
                }
            });
        }
        this.fillValue(this.value);
        return composite;
    }

    private Composite createValueExpressionControl(Composite cmp) {
        Composite composite = new Composite(cmp, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(Messages.MarkerPropertyDialog_ValueExpression);
        this.evalue = new WTextExpression(composite, 0, 1);
        this.evalue.setLayoutData((Object)new GridData(768));
        this.evalue.addModifyListener(new ExpressionModifiedListener(){

            public void expressionModified(ExpressionModifiedEvent event) {
                if (!MarkerPropertyDialog.this.isRefresh) {
                    MarkerPropertyDialog.this.value.setValueExpression((JRExpression)MarkerPropertyDialog.this.evalue.getExpression());
                }
            }
        });
        return composite;
    }

    private Composite createValueControl(Composite cmp) {
        Composite composite = new Composite(cmp, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(Messages.MarkerPropertyDialog_Value);
        this.tvalue = new Text(composite, 2048);
        this.tvalue.setLayoutData((Object)new GridData(768));
        this.tvalue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MarkerPropertyDialog.this.isRefresh) {
                    MarkerPropertyDialog.this.value.setValue(MarkerPropertyDialog.this.tvalue.getText());
                    MarkerPropertyDialog.this.value.setValueExpression(null);
                }
            }
        });
        return composite;
    }

    public void setValue(StandardItemProperty value, ExpressionContext expContext, boolean isMandatory) {
        this.value = value;
        this.expContext = expContext;
        this.isMandatory = isMandatory;
    }

    private void fillValue(StandardItemProperty value) {
        this.isRefresh = true;
        if (this.isMandatory) {
            this.cprop.setEnabled(false);
        }
        this.evalue.setExpressionContext(this.expContext);
        this.cprop.setText(Misc.nvl((String)value.getName()));
        if (value.getValueExpression() != null) {
            this.buseexpr.setSelection(true);
            this.evalue.setExpression((JRDesignExpression)value.getValueExpression());
        } else {
            this.buseexpr.setSelection(false);
            this.tvalue.setText(Misc.nvl((String)value.getValue()));
        }
        this.changeValueOrExpression();
        this.isRefresh = false;
    }

    public void changeValueOrExpression() {
        this.stackLayout.topControl = this.buseexpr.getSelection() ? this.vexp : this.vcmp;
        this.stackComposite.layout();
        if (this.buseexpr.getSelection()) {
            this.value.setValueExpression((JRExpression)this.evalue.getExpression());
        } else {
            this.value.setValue(this.tvalue.getText());
        }
    }
}

