/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.figure;

import com.jaspersoft.studio.components.table.figure.TableRestrictedTransferType;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.components.table.model.table.command.UpdateStyleCommand;
import com.jaspersoft.studio.components.table.part.TableEditPart;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.utils.IOUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class TableStyleTransferDropListener
extends AbstractTransferDropTargetListener {
    public TableStyleTransferDropListener(EditPartViewer viewer) {
        super(viewer);
        this.setTransfer((Transfer)TableRestrictedTransferType.getInstance());
    }

    protected void updateTargetEditPart() {
        this.setTargetEditPart(this.calculateTargetEditPart());
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentEvent(event);
    }

    protected void handleDrop() {
        if (this.getTargetEditPart() instanceof TableEditPart) {
            MTable tableModel = (MTable)((Object)this.getTargetEditPart().getModel());
            TemplateStyle style = (TemplateStyle)IOUtils.readFromByteArray((byte[])((byte[])this.getCurrentEvent().data));
            if (style != null && style instanceof TableStyle) {
                Shell shell;
                MessageDialog question;
                int response;
                TableStyle selectedStyle = (TableStyle)style;
                if (tableModel != null && ((response = (question = new MessageDialog(shell = PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.EditStyleAction_dialogTitle, null, Messages.EditStyleAction_dialogText, 3, new String[]{Messages.EditStyleAction_dialogUpdateButton, Messages.EditStyleAction_dialogNewButton, Messages.EditStyleAction_dialogCancelButton}, 0)).open()) == 0 || response == 1)) {
                    UpdateStyleCommand updateCommand = new UpdateStyleCommand(tableModel, selectedStyle, response == 0);
                    CommandStack cs = this.getCommandStack();
                    if (cs != null) {
                        cs.execute((Command)updateCommand);
                    } else {
                        updateCommand.execute();
                    }
                }
            }
        }
    }

    protected EditPart calculateTargetEditPart() {
        EditPart ep = this.getViewer().findObjectAt(this.getDropLocation());
        if (ep instanceof TableEditPart) {
            return ep;
        }
        return null;
    }

    protected CommandStack getCommandStack() {
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof JrxmlEditor) {
            JrxmlEditor editor = (JrxmlEditor)activeJRXMLEditor;
            return (CommandStack)editor.getAdapter(CommandStack.class);
        }
        return null;
    }

    protected void updateTargetRequest() {
    }
}

