/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.figure;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.commonstyles.CommonViewProvider;
import com.jaspersoft.studio.components.table.figure.TableRestrictedTransferType;
import com.jaspersoft.studio.components.table.figure.TableStyleTransferDropListener;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableStyleWizard;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public class TableStyleView
extends CommonViewProvider {
    private static final int GALLERY_HEIGHT = 100;
    private static final int GALLERY_WIDTH = 100;
    private GalleryItem tableGroup;

    public void createControls(Composite parent) {
        super.createControls(parent, 100, 100, Messages.TableStyleView_labelText);
        this.addDragSupport();
    }

    @Override
    public List<TemplateStyle> getStylesList() {
        ArrayList<TemplateStyle> result = new ArrayList<TemplateStyle>();
        Collection savedStyles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors("tableStyle");
        if (savedStyles != null) {
            for (TemplateStyle style : savedStyles) {
                result.add(style);
            }
        }
        return result;
    }

    @Override
    protected void doCreate() {
        TableStyleWizard wizard = new TableStyleWizard(true, null);
        WizardDialog dialog = this.getEditorDialog(wizard);
        if (dialog.open() == 0) {
            TableStyle newStyle = wizard.getTableStyle();
            TemplateStyleView.getTemplateStylesStorage().addStyle((TemplateStyle)newStyle);
        }
    }

    @Override
    protected void doEdit() {
        GalleryItem selectedItem = this.checkedGallery.getSelection()[0];
        TemplateStyle oldStyle = (TemplateStyle)selectedItem.getData();
        TableStyleWizard wizard = new TableStyleWizard(true, oldStyle);
        WizardDialog dialog = this.getEditorDialog(wizard);
        if (dialog.open() == 0) {
            TableStyle newStyle = wizard.getTableStyle();
            TemplateStyleView.getTemplateStylesStorage().editStyle(oldStyle, (TemplateStyle)newStyle);
        }
    }

    public String getTabName() {
        return "Table Styles";
    }

    public void fillStyles() {
        this.tableGroup = new GalleryItem(this.checkedGallery, 0);
        this.checkedGallery.setRedraw(false);
        Collection styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors("tableStyle");
        if (styles != null) {
            for (TemplateStyle style : styles) {
                this.getItem(style, this.tableGroup);
            }
        }
        this.checkedGallery.setRedraw(true);
    }

    private void addDragSupport() {
        int operations = 2;
        Transfer[] types = new Transfer[]{TableRestrictedTransferType.getInstance()};
        DragSource source = new DragSource((Control)this.checkedGallery, operations);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new CommonViewProvider.StyleDragListener());
    }

    @Override
    public Image generatePreviewFigure(TemplateStyle style) {
        String key = "tableTemplates_" + style.toString();
        Image image = ResourceManager.getImage((String)key);
        if (image == null && style instanceof TableStyle) {
            TableStyle tableStyle = (TableStyle)style;
            image = new Image(null, new org.eclipse.swt.graphics.Rectangle(0, 0, 100, 100));
            GC graphics = new GC((Drawable)image);
            try {
                int y = 1;
                int x = 1;
                int w = 94;
                int h = 94;
                int rowHeight = h / 7;
                Rectangle bounds = new Rectangle(x, y, w, h);
                TableStyleView.fillRoundRectangleDropShadow(graphics, bounds, 6, 4, 4);
                Rectangle row_bounds = new Rectangle(x, y + rowHeight * 2, w, rowHeight);
                Display disp = PlatformUI.getWorkbench().getDisplay();
                AlfaRGB alfaRGB = style.getColor("color_detail_standard");
                graphics.setAlpha(alfaRGB.getAlfa());
                Color swtColorDetail = new Color((Device)disp, alfaRGB.getRgb());
                graphics.setBackground(swtColorDetail);
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                row_bounds = new Rectangle(x, y + rowHeight * 3, w, rowHeight);
                RGB c = null;
                Color swtColor = null;
                if (tableStyle.hasAlternateColor().booleanValue()) {
                    alfaRGB = style.getColor("color_detail");
                    graphics.setAlpha(alfaRGB.getAlfa());
                    c = alfaRGB.getRgb();
                    swtColor = new Color((Device)disp, c);
                    graphics.setBackground(swtColor);
                }
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                row_bounds = new Rectangle(x, y + rowHeight * 4, w, rowHeight);
                if (swtColor != null) {
                    swtColor.dispose();
                }
                graphics.setBackground(swtColorDetail);
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                swtColorDetail.dispose();
                row_bounds = new Rectangle(x, y + rowHeight * 0, w, rowHeight);
                alfaRGB = style.getColor("color_table_header");
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                row_bounds = new Rectangle(x, y + rowHeight * 6, w, rowHeight);
                swtColor.dispose();
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                row_bounds = new Rectangle(x, y + rowHeight * 1, w, rowHeight);
                swtColor.dispose();
                alfaRGB = style.getColor("color_column_header");
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                row_bounds = new Rectangle(x, y + rowHeight * 5, w, rowHeight);
                swtColor.dispose();
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                swtColor.dispose();
                alfaRGB = tableStyle.getRGBBorderColor();
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                swtColor = new Color((Device)disp, c);
                graphics.setForeground(swtColor);
                int i = 0;
                while (i < 8) {
                    graphics.drawLine(x, y + rowHeight * i, x + w, y + rowHeight * i);
                    ++i;
                }
                h = rowHeight * 7;
                if (tableStyle.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
                    i = 0;
                    while (i < 3) {
                        graphics.drawLine(x + i * (w / 3), y, x + i * (w / 3), y + h);
                        ++i;
                    }
                    graphics.drawLine(x + w, y, x + w, y + h - 1);
                }
                if (tableStyle.getBorderStyle() == TableStyle.BorderStyleEnum.ONLY_HORIZONTAL) {
                    graphics.drawLine(x, y, x, y + h);
                    graphics.drawLine(x + w, y, x + w, y + h - 1);
                }
                swtColor.dispose();
            }
            finally {
                graphics.dispose();
            }
            ResourceManager.addImage((String)key, (Image)image);
        }
        return image;
    }

    public AbstractTransferDropTargetListener getDropListener(EditPartViewer viewer) {
        return new TableStyleTransferDropListener(viewer);
    }

    public TemplateStyle getBuilder() {
        return new TableStyle();
    }

    public Image getTabImage() {
        Image image = ResourceManager.getImage((String)"table-style-16");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/table-style-16.png").createImage();
            ResourceManager.addImage((String)"table-style-16", (Image)image);
        }
        return image;
    }

    @Override
    public List<TemplateStyle> getStylesList(List<TemplateStyle> mixedList) {
        ArrayList<TemplateStyle> result = new ArrayList<TemplateStyle>();
        for (TemplateStyle style : mixedList) {
            if (!(style instanceof TableStyle)) continue;
            result.add(style);
        }
        return result;
    }

    public void notifyChange(PropertyChangeEvent e) {
        if (e.getNewValue() instanceof TableStyle) {
            this.refreshStyles();
        }
    }

    public void refreshStyles() {
        if (this.checkedGallery != null) {
            this.checkedGallery.clearAll();
            this.tableGroup = new GalleryItem(this.checkedGallery, 0);
            this.checkedGallery.setRedraw(false);
            for (TemplateStyle style : this.getStylesList()) {
                if (!(style instanceof TableStyle)) continue;
                this.getItem(style, this.tableGroup);
            }
            this.checkedGallery.setRedraw(true);
        }
    }
}

