/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.action;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.SetColumnWidthCommand;
import com.jaspersoft.studio.components.table.part.editpolicy.JSSCompoundTableCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class ColumnsEqualWidthAction
extends ACachedSelectionAction {
    public static final String ID = "com.jaspersoft.studio.components.table.action.columnsEqualWidth";

    public ColumnsEqualWidthAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.ColumnsEqualWidthAction_actionName);
        this.setId(ID);
        this.setToolTipText(Messages.ColumnsEqualWidthAction_actionTooltip);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/resources/equal.gif"));
    }

    protected boolean calculateEnabled() {
        return this.canExecute(this.editor.getSelectionCache().getLastRawSelection());
    }

    public boolean canExecute(ISelection selectionSet) {
        return this.getSelectionSet(selectionSet).size() > 1;
    }

    private List<MColumn> getSelectionSet(ISelection selection) {
        HashMap<StandardBaseColumn, MColumn> result = new HashMap<StandardBaseColumn, MColumn>();
        StructuredSelection structSelection = (StructuredSelection)selection;
        if (structSelection != null) {
            for (Object element : structSelection.toList()) {
                MColumn colModel;
                EditPart part;
                if (!(element instanceof EditPart) || !((part = (EditPart)element).getModel() instanceof MColumn) || (colModel = (MColumn)((Object)part.getModel())).getValue() == null || result.containsKey(colModel.getValue())) continue;
                result.put(colModel.getValue(), colModel);
            }
        }
        return new ArrayList<MColumn>(result.values());
    }

    public void run(ISelection selecition) {
        List<MColumn> columns = this.getSelectionSet(selecition);
        MTable table = TableManager.getTableNode((ANode)columns.get(0));
        int selectedColumnsWidth = 0;
        for (MColumn column : columns) {
            APropertyNode node = column;
            int colWidth = (Integer)node.getPropertyValue((Object)"width");
            selectedColumnsWidth += colWidth;
        }
        int selectedColumnsNewWidth = selectedColumnsWidth / columns.size();
        int remains = selectedColumnsWidth % columns.size();
        JSSCompoundTableCommand cmd = new JSSCompoundTableCommand(table);
        cmd.setLayoutTableContent(true);
        HashSet<BaseColumn> fixedColumns = new HashSet<BaseColumn>();
        for (MColumn column : columns) {
            int newWidth = selectedColumnsNewWidth;
            if (remains > 0) {
                ++newWidth;
                --remains;
            }
            SetColumnWidthCommand setCommand = new SetColumnWidthCommand(column, newWidth);
            fixedColumns.add((BaseColumn)column.getValue());
            cmd.add(setCommand);
        }
        cmd.setFixedColumns(fixedColumns);
        this.execute((Command)cmd);
    }

    public void run() {
        this.run(this.getSelection());
    }
}

