/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableColumnFooter;
import com.jaspersoft.studio.components.table.model.MTableColumnHeader;
import com.jaspersoft.studio.components.table.model.MTableDetail;
import com.jaspersoft.studio.components.table.model.MTableFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.MTableHeader;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.command.AddCellDeltaHeightCommand;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardGroupCell;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JasperDesign;

public class CreateColumnGroupCellCommand
extends JSSCompoundCommand {
    private StandardBaseColumn jrColumn;
    private String groupName;
    private Cell jrCell;
    private int height = 0;
    private ANode section;
    private Class<AMCollection> type;
    private MTable tableNode;
    private ANode groupColumnParent;

    public CreateColumnGroupCellCommand(AMCollection section, MColumnGroup srcNode) {
        this(section, srcNode.getParent(), srcNode.getValue());
    }

    public CreateColumnGroupCellCommand(AMCollection section, ANode groupColumnParent, StandardColumnGroup groupColumn) {
        super((ANode)section);
        this.tableNode = (MTable)section.getParent();
        this.type = ((Object)((Object)section)).getClass();
        this.jrColumn = groupColumn;
        this.section = section;
        this.groupColumnParent = groupColumnParent;
        if (section instanceof MTableGroupHeader) {
            this.groupName = ((MTableGroupHeader)section).getJrDesignGroup().getName();
        }
        if (section instanceof MTableGroupFooter) {
            this.groupName = ((MTableGroupFooter)section).getJrDesignGroup().getName();
        }
    }

    private int getGroupIndex(ANode groupNode) {
        if (groupNode instanceof MTableGroupHeader) {
            int startIndex = -1;
            for (INode node : groupNode.getParent().getChildren()) {
                if (startIndex == -1 && node instanceof MTableGroupHeader) {
                    startIndex = 0;
                }
                if (node == groupNode) break;
                if (startIndex <= -1) continue;
                ++startIndex;
            }
            return startIndex;
        }
        if (groupNode instanceof MTableGroupFooter) {
            int startIndex = -1;
            for (INode node : groupNode.getParent().getChildren()) {
                if (startIndex == -1 && node instanceof MTableGroupFooter) {
                    startIndex = 0;
                }
                if (node == groupNode) break;
                if (startIndex <= -1) continue;
                ++startIndex;
            }
            return startIndex;
        }
        return -1;
    }

    private List<Cell> getAllCells(BaseColumn column) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        if (column instanceof StandardColumnGroup) {
            StandardColumnGroup group = (StandardColumnGroup)column;
            for (BaseColumn subCol : group.getColumns()) {
                result.addAll(this.getAllCells(subCol));
            }
        } else {
            Cell currentCell = null;
            if (this.type.isAssignableFrom(MTableHeader.class)) {
                currentCell = column.getTableHeader();
            } else if (this.type.isAssignableFrom(MTableFooter.class)) {
                currentCell = column.getTableFooter();
            } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
                currentCell = column.getColumnHeader();
            } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
                currentCell = column.getColumnFooter();
            } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
                int groupIndex = this.getGroupIndex(this.section);
                List groupHeaders = column.getGroupHeaders();
                if (groupIndex != -1 && groupHeaders.size() > groupIndex) {
                    for (GroupCell groupHeader : groupHeaders) {
                        if (groupHeader.getCell() == null) continue;
                        result.add(groupHeader.getCell());
                    }
                }
            } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
                int groupIndex = this.getGroupIndex(this.section);
                List groupFooters = column.getGroupFooters();
                if (groupIndex != -1 && groupFooters.size() > groupIndex) {
                    for (GroupCell groupFooter : groupFooters) {
                        if (groupFooter.getCell() == null) continue;
                        result.add(groupFooter.getCell());
                    }
                }
            }
            if (currentCell != null) {
                result.add(currentCell);
            }
        }
        return result;
    }

    private void setCellToIncrease(List<INode> children, StandardBaseColumn exclusion, int newHeightDelta) {
        for (INode child : children) {
            if (child.getValue() == exclusion) continue;
            if (child.getClass().equals(MCell.class)) {
                this.add(new AddCellDeltaHeightCommand((Cell)((MCell)child).getCell(), newHeightDelta));
            }
            this.setCellToIncrease(child.getChildren(), exclusion, newHeightDelta);
        }
    }

    private void setCellHeightDelta(List<Cell> children, int newHeightDelta) {
        for (Cell child : children) {
            this.add(new AddCellDeltaHeightCommand(child, newHeightDelta));
        }
    }

    public boolean canExecute() {
        return this.getCommands().size() == 0 || super.canExecute();
    }

    private int getMinCellHeight(List<Cell> children, int actualMin) {
        for (Cell child : children) {
            int cellHehight = child.getHeight();
            if (actualMin <= cellHehight) continue;
            actualMin = cellHehight;
        }
        return actualMin;
    }

    private int searchSuggestedHeight(ANode parent) {
        for (INode child : parent.getChildren()) {
            MColumnGroupCell groupCell;
            if (!(child instanceof MColumnGroupCell) || (groupCell = (MColumnGroupCell)child).getCell() == null) continue;
            return groupCell.getCell().getHeight();
        }
        return -1;
    }

    protected void computeHeight() {
        this.height = this.searchSuggestedHeight(this.groupColumnParent);
        if (this.height == -1) {
            this.height = MColumnGroup.DEFAULT_CELL_HEIGHT;
            this.setCellToIncrease(this.section.getChildren(), this.jrColumn, this.height);
        } else {
            List<Cell> columnCells = this.getAllCells((BaseColumn)this.jrColumn);
            this.height = this.getMinCellHeight(columnCells, this.height);
            this.setCellHeightDelta(columnCells, -this.height);
        }
    }

    protected void createGroupCell() {
        if (this.jrCell == null) {
            this.jrCell = this.createCell();
        }
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            this.jrColumn.setTableHeader(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            this.jrColumn.setTableFooter(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            this.jrColumn.setColumnHeader(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            this.jrColumn.setColumnFooter(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            int groupIndex = this.getGroupIndex(this.section);
            List groupHeaders = this.jrColumn.getGroupHeaders();
            if (groupIndex != -1 && groupHeaders.size() > groupIndex) {
                StandardGroupCell groupCell = new StandardGroupCell(this.groupName, this.jrCell);
                groupHeaders.add(groupIndex, groupCell);
                this.jrColumn.getEventSupport().fireCollectionElementAddedEvent("groupHeaders", (Object)groupCell, groupIndex);
            } else {
                this.jrColumn.setGroupHeader(this.groupName, this.jrCell);
            }
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            int groupIndex = this.getGroupIndex(this.section);
            List groupFooters = this.jrColumn.getGroupFooters();
            if (groupIndex != -1 && groupFooters.size() > groupIndex) {
                StandardGroupCell groupCell = new StandardGroupCell(this.groupName, this.jrCell);
                groupFooters.add(groupIndex, groupCell);
                this.jrColumn.getEventSupport().fireCollectionElementAddedEvent("groupFooters", (Object)groupCell, groupIndex);
            } else {
                this.jrColumn.setGroupFooter(this.groupName, this.jrCell);
            }
        }
        super.execute();
        this.tableNode.getTableManager().updateTableSpans();
    }

    public void execute() {
        this.computeHeight();
        this.createGroupCell();
    }

    public boolean canUndo() {
        return true;
    }

    public void redo() {
        this.createGroupCell();
    }

    protected Cell createCell() {
        DesignCell cell = new DesignCell();
        cell.setHeight(Integer.valueOf(this.height));
        String styleName = this.getStyleName(this.tableNode.getPropertiesMap());
        if (styleName != null) {
            JasperDesign jd = this.tableNode.getJasperDesign();
            JRStyle internalStyle = (JRStyle)jd.getStylesMap().get(styleName);
            if (internalStyle != null) {
                cell.setStyle(internalStyle);
            } else {
                cell.setStyleNameReference(styleName);
            }
        }
        return cell;
    }

    public void undo() {
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            this.jrColumn.setTableHeader(null);
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            this.jrColumn.setTableFooter(null);
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            this.jrColumn.setColumnHeader(null);
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            this.jrColumn.setColumnFooter(null);
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            this.jrColumn.setGroupHeader(this.groupName, null);
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            this.jrColumn.setGroupFooter(this.groupName, null);
        }
        super.undo();
        this.tableNode.getTableManager().updateTableSpans();
    }

    protected String getStyleName(JRPropertiesMap tableMap) {
        if (this.type.isAssignableFrom(MTableHeader.class) || this.type.isAssignableFrom(MTableFooter.class)) {
            return tableMap.getProperty("com.jaspersoft.studio.table.style.table_header");
        }
        if (this.type.isAssignableFrom(MTableColumnHeader.class) || this.type.isAssignableFrom(MTableColumnFooter.class) || this.type.isAssignableFrom(MTableGroupHeader.class) || this.type.isAssignableFrom(MTableGroupFooter.class)) {
            return tableMap.getProperty("com.jaspersoft.studio.table.style.column_header");
        }
        if (this.type.isAssignableFrom(MTableDetail.class)) {
            return tableMap.getProperty("com.jaspersoft.studio.table.style.detail");
        }
        return null;
    }
}

