/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.ColumnCell;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.TableMatrix;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.util.TableUtil;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class FixCellHeightsCommand
extends Command {
    private TableManager tbManager;
    private Map<DesignCell, Integer> hmap;
    private Map<StandardColumnGroup, Integer> wmap;

    public FixCellHeightsCommand(MColumn mcolumn) {
        this(mcolumn.getMTable().getTableManager());
    }

    public FixCellHeightsCommand(TableManager manager) {
        super("Fix Table Cells Height");
        this.tbManager = manager;
    }

    public void execute() {
        this.tbManager.initMaps();
        if (this.hmap == null) {
            this.hmap = new HashMap<DesignCell, Integer>();
        }
        this.hmap.clear();
        if (this.wmap == null) {
            this.wmap = new HashMap<StandardColumnGroup, Integer>();
        }
        this.wmap.clear();
        TableMatrix mh = this.tbManager.getMatrixHelper();
        Map<ColumnCell, Rectangle> map = mh.getCells();
        for (ColumnCell cc : map.keySet()) {
            Rectangle b = cc.getBounds();
            if (cc.column instanceof StandardColumnGroup) {
                if (b.width == cc.column.getWidth()) continue;
                this.wmap.put((StandardColumnGroup)cc.column, cc.column.getWidth());
                ((StandardColumnGroup)cc.column).setWidth(Integer.valueOf(b.width));
                continue;
            }
            Cell dc = TableUtil.getCell((BaseColumn)cc.column, (int)cc.type, (String)cc.grName);
            if (dc == null) continue;
            int oldh = dc.getHeight();
            if (b.height == dc.getHeight()) continue;
            ((DesignCell)dc).setHeight(Integer.valueOf(b.height));
            this.hmap.put((DesignCell)dc, oldh);
        }
        this.tbManager.initMaps();
        this.tbManager.refresh();
    }

    public void undo() {
        for (DesignCell dc : this.hmap.keySet()) {
            dc.setHeight(this.hmap.get(dc));
        }
        for (StandardColumnGroup bc : this.wmap.keySet()) {
            bc.setWidth(this.wmap.get(bc));
        }
        this.tbManager.initMaps();
        this.tbManager.refresh();
    }
}

