/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import org.eclipse.gef.commands.Command;

public class SetColumnWidthCommand
extends Command {
    private StandardTable table;
    private BaseColumn column;
    private int newWidth;
    private HashMap<StandardBaseColumn, Integer> undoWidths = new HashMap();

    public SetColumnWidthCommand(MColumn column, int newWidth) {
        this.newWidth = newWidth;
        this.column = column.getValue();
        this.table = column.getTable().getStandardTable();
    }

    protected void setWidth() {
        int delta = this.newWidth - this.column.getWidth();
        this.setColumnWidth((StandardBaseColumn)this.column, this.newWidth);
        if (this.column instanceof StandardColumnGroup) {
            this.setWidthOnChildren((StandardColumnGroup)this.column, this.newWidth);
        }
        BaseColumn currentCol = this.column;
        StandardColumnGroup currentParent = TableManager.getParent(this.table, currentCol);
        while (currentParent != null) {
            this.setColumnWidth((StandardBaseColumn)currentParent, currentParent.getWidth() + delta);
            currentCol = currentParent;
            currentParent = TableManager.getParent(this.table, currentCol);
        }
    }

    protected void setColumnWidth(StandardBaseColumn col, int width) {
        this.undoWidths.put(col, col.getWidth());
        col.setWidth(Integer.valueOf(width));
    }

    protected void setWidthOnChildren(StandardColumnGroup group, int newSize) {
        int[] childrenNewWidths = this.getColumnsProportionalWidth(group.getColumns(), newSize);
        int index = 0;
        for (BaseColumn child : group.getColumns()) {
            int newChildWidth = childrenNewWidths[index];
            if (child instanceof StandardColumnGroup) {
                this.setWidthOnChildren((StandardColumnGroup)child, newChildWidth);
            }
            this.setColumnWidth((StandardBaseColumn)child, newChildWidth);
            ++index;
        }
    }

    private int[] getColumnsProportionalWidth(List<BaseColumn> columns, int newWidth) {
        int[] proportionalWidths = new int[columns.size()];
        int index = 0;
        int currentColumnsWidth = 0;
        for (BaseColumn col : columns) {
            currentColumnsWidth += col.getWidth().intValue();
        }
        int columnsTotalWidth = 0;
        for (BaseColumn col : columns) {
            int proportionalWidth;
            float proportionalFactor = (float)col.getWidth().intValue() / (float)currentColumnsWidth;
            proportionalWidths[index] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
            columnsTotalWidth += proportionalWidth;
            ++index;
        }
        int remains = newWidth - columnsTotalWidth;
        index = 0;
        while (remains > 0 && proportionalWidths.length > 0) {
            int n = index++;
            proportionalWidths[n] = proportionalWidths[n] + 1;
            --remains;
            if (index != proportionalWidths.length) continue;
            index = 0;
        }
        return proportionalWidths;
    }

    public void undo() {
        for (Map.Entry<StandardBaseColumn, Integer> undoEntry : this.undoWidths.entrySet()) {
            undoEntry.getKey().setWidth(undoEntry.getValue());
        }
    }

    public void execute() {
        this.undoWidths.clear();
        this.setWidth();
    }

    public boolean canExecute() {
        return this.newWidth >= 0 && this.column != null && this.table != null;
    }
}

