/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup.command;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import org.eclipse.gef.commands.Command;

public class MoveColumnIntoGroupCommand
extends Command {
    private HashMap<StandardColumnGroup, Integer> oldGroupsWidth = new HashMap();
    private HashMap<DesignCell, Integer> oldCellSizes = new HashMap();
    private StandardColumnGroup newParent;
    private StandardBaseColumn movedColumn;
    private MTable tableNode;
    private RefreshColumnNamesCommand refreshNameCommand;

    public MoveColumnIntoGroupCommand(StandardColumnGroup newParent, MCell movedElement) {
        super(Messages.ReorderColumnGroupCommand_reorder_column_group);
        this.newParent = newParent;
        this.movedColumn = movedElement.getValue();
        this.tableNode = movedElement.getMTable();
        this.refreshNameCommand = new RefreshColumnNamesCommand(this.tableNode, true, true);
    }

    private void moveColumn() {
        int newHeight;
        DesignCell movedCell;
        DesignCell groupCell;
        this.newParent.addColumn((BaseColumn)this.movedColumn);
        this.setGroupWidth2Top(this.tableNode.getStandardTable().getColumns(), this.movedColumn, this.movedColumn.getWidth());
        if (this.newParent.getTableHeader() != null && this.movedColumn.getTableHeader() != null) {
            groupCell = (DesignCell)this.newParent.getTableHeader();
            movedCell = (DesignCell)this.movedColumn.getTableHeader();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            newHeight = movedCell.getHeight() - groupCell.getHeight();
            if (newHeight < 0) {
                newHeight = 0;
            }
            movedCell.setHeight(Integer.valueOf(newHeight));
        }
        if (this.newParent.getTableFooter() != null && this.movedColumn.getTableFooter() != null) {
            groupCell = (DesignCell)this.newParent.getTableFooter();
            movedCell = (DesignCell)this.movedColumn.getTableFooter();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            newHeight = movedCell.getHeight() - groupCell.getHeight();
            if (newHeight < 0) {
                newHeight = 0;
            }
            movedCell.setHeight(Integer.valueOf(newHeight));
        }
        if (this.newParent.getColumnHeader() != null && this.movedColumn.getColumnHeader() != null) {
            groupCell = (DesignCell)this.newParent.getColumnHeader();
            movedCell = (DesignCell)this.movedColumn.getColumnHeader();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            newHeight = movedCell.getHeight() - groupCell.getHeight();
            if (newHeight < 0) {
                newHeight = 0;
            }
            movedCell.setHeight(Integer.valueOf(newHeight));
        }
        if (this.newParent.getColumnFooter() != null && this.movedColumn.getColumnFooter() != null) {
            groupCell = (DesignCell)this.newParent.getColumnFooter();
            movedCell = (DesignCell)this.movedColumn.getColumnFooter();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            newHeight = movedCell.getHeight() - groupCell.getHeight();
            if (newHeight < 0) {
                newHeight = 0;
            }
            movedCell.setHeight(Integer.valueOf(newHeight));
        }
        this.tableNode.getTableManager().updateTableSpans();
        this.refreshNameCommand.execute();
    }

    private void restoreColumn() {
        this.newParent.removeColumn((BaseColumn)this.movedColumn);
        for (Map.Entry<StandardColumnGroup, Integer> entry : this.oldGroupsWidth.entrySet()) {
            entry.getKey().setWidth(entry.getValue());
        }
        for (Map.Entry<StandardColumnGroup, Integer> entry : this.oldCellSizes.entrySet()) {
            ((DesignCell)entry.getKey()).setHeight(entry.getValue());
        }
        this.oldGroupsWidth.clear();
        this.oldCellSizes.clear();
        this.tableNode.getTableManager().updateTableSpans();
        this.refreshNameCommand.undo();
    }

    protected boolean setGroupWidth2Top(List<BaseColumn> cols, StandardBaseColumn searchedColumn, int delta) {
        for (BaseColumn bc : cols) {
            StandardColumnGroup group;
            boolean columnFound;
            if (bc == searchedColumn) {
                return true;
            }
            if (!(bc instanceof StandardColumnGroup) || !(columnFound = this.setGroupWidth2Top((group = (StandardColumnGroup)bc).getColumns(), searchedColumn, delta))) continue;
            this.oldGroupsWidth.put(group, group.getWidth());
            group.setWidth(Integer.valueOf(group.getWidth() + delta));
            return true;
        }
        return false;
    }

    public boolean canExecute() {
        return this.newParent != null && this.tableNode != null;
    }

    public boolean canUndo() {
        return this.newParent != null && this.tableNode != null;
    }

    public void execute() {
        if (this.tableNode.hasColumnsAutoresizeProportional()) {
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", false);
            this.moveColumn();
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", true);
        } else {
            this.moveColumn();
        }
    }

    public void undo() {
        if (this.tableNode.hasColumnsAutoresizeProportional()) {
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", false);
            this.restoreColumn();
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", true);
        } else {
            this.restoreColumn();
        }
    }
}

