/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.table.command;

import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.dialog.ApplyTableStyleAction;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.commands.Command;

public class UpdateStyleCommand
extends Command {
    private MTable table;
    private JRDesignStyle[] oldStyles;
    private TableStyle newStyleTemplate;
    private boolean updateOldStyles;

    public UpdateStyleCommand(MTable table, TableStyle newStyle, boolean updateOldStyles) {
        this.table = table;
        this.newStyleTemplate = newStyle;
        this.oldStyles = null;
        this.updateOldStyles = updateOldStyles;
    }

    public void execute() {
        ApplyTableStyleAction applyAction = new ApplyTableStyleAction(this.newStyleTemplate, (JRElement)this.table.getValue());
        JRDesignStyle[] tableStyles = applyAction.getStylesFromTable(this.table.getJasperDesign());
        this.oldStyles = new JRDesignStyle[tableStyles.length];
        int i = 0;
        while (i < tableStyles.length) {
            JRDesignStyle currentStyle = tableStyles[i];
            if (currentStyle != null) {
                this.oldStyles[i] = (JRDesignStyle)currentStyle.clone();
            }
            ++i;
        }
        applyAction.updateStyle(this.table.getJasperDesign(), this.newStyleTemplate, this.updateOldStyles, false);
        this.table.setChangedProperty(true);
    }

    public void undo() {
        ArrayList<JRDesignStyle> styles = new ArrayList<JRDesignStyle>(Arrays.asList(this.oldStyles));
        ApplyTableStyleAction applyAction = new ApplyTableStyleAction(styles, (JRElement)this.table.getValue());
        applyAction.updateStyle(this.table.getJasperDesign(), styles, this.updateOldStyles, true);
        this.oldStyles = null;
        this.table.setChangedProperty(true);
    }

    public boolean canUndo() {
        return this.table != null && this.oldStyles != null;
    }
}

