/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part.editpolicy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import org.eclipse.gef.commands.Command;

public class SetTableAutoresizeProperty
extends Command {
    private MTable table;
    private boolean setAutoresize = false;
    private boolean valueChanged = false;
    private HashMap<BaseColumn, Integer> originalColumnsSize = null;

    public SetTableAutoresizeProperty(MTable table, boolean setAutoresize) {
        super("Set Table Autoresize");
        this.table = table;
        this.setAutoresize = setAutoresize;
    }

    public void execute() {
        if (!ModelUtils.safeEquals((Object)this.setAutoresize, (Object)this.table.hasColumnsAutoresizeProportional())) {
            this.valueChanged = true;
            if (this.setAutoresize) {
                this.storeColumnsSize();
                this.table.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", true);
                this.table.getTableManager().fillSpace(this.table.getValue().getWidth(), true, new HashSet<BaseColumn>());
            } else {
                this.table.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", false);
            }
        }
    }

    public void undo() {
        if (this.valueChanged) {
            if (this.setAutoresize) {
                this.table.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", false);
                this.restoreColumnsSize(this.table.getStandardTable().getColumns());
                JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                layoutCommands.execute();
            } else {
                this.restoreColumnsSize(this.table.getStandardTable().getColumns());
                this.table.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", true);
                boolean changed = this.table.getTableManager().fillSpace(this.table.getValue().getWidth(), true, new HashSet<BaseColumn>());
                if (!changed) {
                    JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                    layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                    layoutCommands.execute();
                }
            }
        }
    }

    protected void storeColumnsSize() {
        List<BaseColumn> columns = this.getAllColumns(this.table.getStandardTable().getColumns());
        this.originalColumnsSize = new HashMap();
        for (BaseColumn column : columns) {
            this.originalColumnsSize.put(column, column.getWidth());
        }
    }

    protected void restoreColumnsSize(List<BaseColumn> columns) {
        if (this.originalColumnsSize != null) {
            for (BaseColumn column : columns) {
                Integer originalWidth;
                if (column instanceof StandardColumnGroup) {
                    StandardColumnGroup groupColumn = (StandardColumnGroup)column;
                    this.restoreColumnsSize(groupColumn.getColumns());
                }
                if ((originalWidth = this.originalColumnsSize.get(column)) == null) continue;
                ((StandardBaseColumn)column).setWidth(originalWidth);
            }
        }
    }

    protected List<BaseColumn> getAllColumns(List<BaseColumn> cols) {
        ArrayList<BaseColumn> lst = new ArrayList<BaseColumn>();
        for (BaseColumn bc : cols) {
            if (bc instanceof ColumnGroup) {
                lst.addAll(this.getAllColumns(((ColumnGroup)bc).getColumns()));
            }
            lst.add(bc);
        }
        return lst;
    }

    public boolean canExecute() {
        return this.table != null;
    }

    public boolean canUndo() {
        return this.table != null;
    }
}

