/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.widgets.framework.ui.dialogs;

import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.customizers.shape.Point;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SidesWizardPage
extends JSSHelpWizardPage {
    private Integer sidesNumber = 3;

    public SidesWizardPage() {
        super("polygonDefinitionPage");
        this.setTitle("Polygon sides");
        this.setMessage("Define a number equals or greater of 3 to be used as the number of sides of the polygon");
    }

    public SidesWizardPage(List<Point> points) {
        this();
        if (points != null) {
            this.sidesNumber = points.size();
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText("Sides");
        final NumericText sides = new NumericText(container, 2048, 0, 0);
        sides.setLayoutData((Object)new GridData(768));
        sides.setValues((Number)this.sidesNumber, (Number)3, (Number)Integer.MAX_VALUE);
        sides.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SidesWizardPage.this.sidesNumber = sides.getValueAsInteger();
                SidesWizardPage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)container);
    }

    protected String getContextName() {
        return null;
    }

    public boolean isPageComplete() {
        return this.sidesNumber != null && this.sidesNumber > 2;
    }

    public List<Point> getPoints() {
        ArrayList<Point> result = new ArrayList<Point>();
        int radius = 1000;
        Integer minX = null;
        Integer minY = null;
        int i = 0;
        while (i < this.sidesNumber) {
            int x = (int)((double)radius * Math.cos(Math.PI * 2 * (double)((float)i / (float)this.sidesNumber.intValue())));
            int y = (int)((double)radius * Math.sin(Math.PI * 2 * (double)((float)i / (float)this.sidesNumber.intValue())));
            result.add(new Point(x, y));
            if (minX == null || minX > x) {
                minX = x;
            }
            if (minY == null || minY > y) {
                minY = y;
            }
            ++i;
        }
        int xOffset = minX < 0 ? Math.abs(minX) : 0;
        int yOffset = minY < 0 ? Math.abs(minY) : 0;
        for (Point point : result) {
            point.setX(point.getX() + xOffset);
            point.setY(point.getY() + yOffset);
        }
        return result;
    }
}

