/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.eclipse.builder.CompatibilityManager;
import net.sf.jasperreports.eclipse.builder.ConsoleExecuter;
import net.sf.jasperreports.eclipse.builder.JasperReportErrorHandler;
import net.sf.jasperreports.eclipse.builder.jdt.JRJdtCompiler;
import net.sf.jasperreports.eclipse.builder.jdt.NameEnvironement;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.FileExtension;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.xml.SourceLocation;
import net.sf.jasperreports.eclipse.util.xml.SourceTraceDigester;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRReportSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.xml.sax.SAXException;

public class JasperReportCompiler {
    private IProject project;
    private JasperReportErrorHandler errorHandler;
    private JRSaxParserFactory parserFactory;
    private SourceTraceDigester digester;
    private Map<String, JRCompiler> map = new HashMap<String, JRCompiler>();
    private Map<String, Boolean> mpack = new HashMap<String, Boolean>();
    private Map<String, byte[]> mtype = new HashMap<String, byte[]>();
    private JasperReportsContext jasperReportsContext;
    public static final String JSS_COMPATIBILITY_COMPILER_VERSION = "com.jaspersoft.studio.jr.compile.version";

    public JasperReport compileReport(JasperReportsContext jasperReportsContext, IFile jrxml, IProgressMonitor monitor) throws CoreException {
        block17: {
            String p;
            block18: {
                try {
                    CompatibilityManager cm;
                    String str;
                    if (this.jasperReportsContext != jasperReportsContext) {
                        this.clean();
                        this.jasperReportsContext = jasperReportsContext;
                    }
                    if ((str = jasperReportsContext.getProperty(JSS_COMPATIBILITY_COMPILER_VERSION)) == null || str.isEmpty() || str.equals("last") || str.equals(JasperDesign.class.getPackage().getImplementationVersion()) || (p = (cm = CompatibilityManager.getInstance()).getJRPath(str)) == null) break block17;
                    ClassLoader cl = cm.getClassLoader(str, jrxml.getProject());
                    if (cl == null) break block18;
                    try {
                        String fjrxml = jrxml.getRawLocation().toOSString();
                        String fjasper = FileExtension.getCompiledFileName(fjrxml);
                        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(cl);
                            Class<?> cjcm = cl.loadClass(JasperCompileManager.class.getName());
                            if (this.tryCompilationWithNewerMode(cjcm)) {
                                Method m = cjcm.getDeclaredMethod("getDefaultInstance", new Class[0]);
                                m.setAccessible(true);
                                Object obj = m.invoke(cjcm, new Object[0]);
                                m = cjcm.getDeclaredMethod("compileToFile", String.class, String.class);
                                m.invoke(obj, fjrxml, fjasper);
                            } else {
                                Method oldM = cjcm.getMethod("compileReportToFile", String.class);
                                oldM.invoke(null, fjrxml);
                            }
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldLoader);
                        }
                        jrxml.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        IPath jasperFilePath = jrxml.getFullPath().removeFileExtension().addFileExtension("jasper");
                        IFile jasperFile = ResourcesPlugin.getWorkspace().getRoot().getFile(jasperFilePath);
                        jasperFile.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
                        return (JasperReport)JRLoader.loadObjectFromFile((String)fjasper);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                        this.errorHandler.addMarker(new RuntimeException("Problem compiling the report, please check the console view for details"));
                    }
                    catch (InvocationTargetException e) {
                        Throwable ex = e.getTargetException();
                        if (ex.getClass().getName().equals(JRValidationException.class.getName())) {
                            JasperDesign jasperDesign = this.loadJasperDesign(jasperReportsContext, jrxml);
                            this.setValidationMarkers(JasperReportCompiler.convertJRValidationException(ex), jasperDesign);
                        } else if (ex.getClass().getName().equals(JRException.class.getName())) {
                            this.errorHandler.addMarker(JasperReportCompiler.convertJRException(ex));
                        } else {
                            throw new RuntimeException(ex);
                        }
                        return null;
                    }
                }
                catch (Exception e) {
                    this.errorHandler.addMarker(e);
                    return null;
                }
            }
            ConsoleExecuter consoleExecuter = new ConsoleExecuter(jrxml, p, jrxml.getParent().getLocation().toOSString());
            consoleExecuter.runCompilation();
            return null;
        }
        this.setProject(jrxml.getProject());
        JasperDesign jasperDesign = this.loadJasperDesign(jasperReportsContext, jrxml);
        return this.compileReport(jasperReportsContext, jasperDesign, monitor);
    }

    private boolean tryCompilationWithNewerMode(Class<?> jasperCompilerManager) {
        try {
            jasperCompilerManager.getDeclaredMethod("getDefaultInstance", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    private static JRValidationException convertJRValidationException(Throwable e) {
        JRValidationException jrex = null;
        try {
            String msg = e.getMessage();
            Collection arg = (Collection)e.getClass().getMethod("getFaults", new Class[0]).invoke((Object)e, new Object[0]);
            jrex = new JRValidationException(msg, arg);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        if (jrex == null) {
            jrex = new JRValidationException(e.getMessage(), new ArrayList());
        }
        return jrex;
    }

    private static JRException convertJRException(Throwable e) {
        JRException jrex = null;
        try {
            String msg = e.getMessage();
            Object[] arg = (Object[])e.getClass().getMethod("getArgs", new Class[0]).invoke((Object)e, new Object[0]);
            Throwable t = (Throwable)e.getClass().getMethod("getCause", new Class[0]).invoke((Object)e, new Object[0]);
            jrex = new JRException(msg, arg, t);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        if (jrex == null) {
            jrex = new JRException(e.getMessage());
        }
        return jrex;
    }

    public JasperReport compileReport(JasperReportsContext jasperReportsContext, JasperDesign jasperDesign, IProgressMonitor monitor) throws CoreException {
        long start;
        if (this.jasperReportsContext != jasperReportsContext) {
            this.clean();
            this.jasperReportsContext = jasperReportsContext;
        }
        long bcomp = start = System.currentTimeMillis();
        JasperReport report = null;
        String language = jasperDesign.getLanguage();
        try {
            Object compiler;
            this.createDigester();
            if (language == null || language.isEmpty()) {
                jasperDesign.setLanguage("groovy");
                language = "groovy";
            }
            if ((compiler = this.map.get(language)) == null) {
                if ("java".equals(language)) {
                    compiler = new JRJdtCompiler(jasperReportsContext){

                        @Override
                        protected JRJdtCompiler.CompilerRequestor getCompilerRequestor(JRCompilationUnit[] units) {
                            return new LocalCompilerRequestor(this.jasperReportsContext, this, units);
                        }

                        @Override
                        protected INameEnvironment getNameEnvironment(JRCompilationUnit[] units) {
                            return new NameEnvironement(this, units){

                                @Override
                                protected boolean isPackage(String result) {
                                    if (result.isEmpty()) {
                                        return true;
                                    }
                                    Boolean isPack = (this).JasperReportCompiler.this.mpack.get(result);
                                    if (isPack == null) {
                                        isPack = super.isPackage(result);
                                        (this).JasperReportCompiler.this.mpack.put(result, isPack);
                                    }
                                    return isPack;
                                }

                                @Override
                                protected byte[] getResource(String name) throws JRException {
                                    if ((this).JasperReportCompiler.this.mtype.containsKey(name)) {
                                        return (this).JasperReportCompiler.this.mtype.get(name);
                                    }
                                    byte[] bt = super.getResource(name);
                                    (this).JasperReportCompiler.this.mtype.put(name, bt);
                                    return bt;
                                }
                            };
                        }
                    };
                } else {
                    String compilerClassName = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).getProperty("net.sf.jasperreports.compiler." + language);
                    try {
                        Class<?> clazz = null;
                        ClassLoader cl = (ClassLoader)jasperReportsContext.getValue("CURRENT_CLASS_LOADER");
                        clazz = cl != null ? cl.loadClass(compilerClassName) : JRClassLoader.loadClassForName((String)compilerClassName);
                        try {
                            Constructor<?> c = clazz.getDeclaredConstructor(JasperReportsContext.class, Boolean.TYPE);
                            compiler = (JRCompiler)c.newInstance(jasperReportsContext, false);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            try {
                                Constructor<?> c = clazz.getDeclaredConstructor(JasperReportsContext.class);
                                compiler = (JRCompiler)c.newInstance(jasperReportsContext);
                            }
                            catch (NoSuchMechanismException noSuchMechanismException) {
                                compiler = (JRCompiler)clazz.newInstance();
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new JRException(String.valueOf(Messages.JasperReportCompiler_ErrorInitializationReportCompiler) + compilerClassName, (Throwable)e);
                    }
                }
                this.map.put(language, (JRCompiler)compiler);
            }
            bcomp = System.currentTimeMillis();
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = null;
                if (jasperReportsContext != null) {
                    cl = (ClassLoader)jasperReportsContext.getValue("javaProjectClassLoader");
                }
                if (jasperReportsContext != null && cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                report = compiler.compileReport(jasperDesign);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        catch (JRValidationException e) {
            this.setValidationMarkers(e, jasperDesign);
        }
        catch (JRException e) {
            this.errorHandler.addMarker(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        long end = System.currentTimeMillis();
        System.out.println("Compiled: " + language + " " + (bcomp - start) + " ms " + (end - start) + " ms");
        return report;
    }

    protected void setValidationMarkers(JRValidationException e, JasperDesign design) {
        for (JRValidationFault fault : e.getFaults()) {
            JRDesignElement componentElement;
            String message = fault.getMessage();
            SourceLocation location = null;
            Object source = fault.getSource();
            if (source != null && (location = this.digester.getLocation(source)) == null) {
                message = String.valueOf(message) + " --- " + source.toString();
            }
            if (source instanceof StandardTable && (componentElement = this.getElementFromTable((JRChild[])design.getAllBands(), (StandardTable)source)) != null) {
                source = componentElement;
            }
            if (location == null && source instanceof JRDesignElement) {
                this.errorHandler.addMarker(message, location, (JRDesignElement)source);
                continue;
            }
            this.errorHandler.addMarker(message, location);
        }
    }

    private JRDesignElement getElementFromTable(JRChild[] childs, StandardTable table) {
        JRChild[] jRChildArray = childs;
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            JRElementGroup group;
            JRDesignElement value;
            JRChild child = jRChildArray[n2];
            if (child instanceof JRDesignComponentElement && ((JRDesignComponentElement)child).getComponent() == table) {
                return (JRDesignElement)child;
            }
            if (child instanceof JRElementGroup && (value = this.getElementFromTable((JRChild[])(group = (JRElementGroup)child).getElements(), table)) != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    protected JasperDesign loadJasperDesign(JasperReportsContext jasperReportsContext, IFile file) throws JRException, CoreException {
        InputStream in = file.getContents();
        try {
            JasperDesign jasperDesign = new JRXmlLoader(jasperReportsContext, (Digester)this.createDigester()).loadXML(in);
            return jasperDesign;
        }
        finally {
            FileUtils.closeStream(in);
        }
    }

    protected SourceTraceDigester createDigester() throws JRException {
        if (this.digester == null) {
            if (this.parserFactory == null) {
                this.parserFactory = new JRReportSaxParserFactory(this.jasperReportsContext);
            }
            SAXParser parser = this.parserFactory.createParser();
            this.digester = new SourceTraceDigester(parser);
            try {
                JRXmlDigesterFactory.setComponentsInternalEntityResources((JasperReportsContext)this.jasperReportsContext, (JRXmlDigester)this.digester);
                JRXmlDigesterFactory.configureDigester((JasperReportsContext)this.jasperReportsContext, (Digester)this.digester);
            }
            catch (SAXException e) {
                throw new JRException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new JRException((Throwable)e);
            }
        }
        return this.digester;
    }

    public JasperReportErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(JasperReportErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setProject(IProject project) {
        if (this.project != project) {
            this.clean();
        }
        this.project = project;
    }

    public void clean() {
        this.map = new HashMap<String, JRCompiler>();
        this.mtype = new HashMap<String, byte[]>();
        this.mpack = new HashMap<String, Boolean>();
    }

    protected class LocalCompilerRequestor
    extends JRJdtCompiler.CompilerRequestor {
        private Set expressions;

        protected LocalCompilerRequestor(JasperReportsContext jasperReportsContext, JRJdtCompiler compiler, JRCompilationUnit[] units) {
            super(jasperReportsContext, compiler, units);
            this.expressions = new HashSet();
        }

        @Override
        public void processProblems() {
            int i = 0;
            while (i < this.units.length) {
                JRCompilationSourceCode sourceCode = this.units[i].getCompilationSource();
                IProblem[] problems = this.unitResults[i].getProblems();
                if (problems != null) {
                    String lastMessage = null;
                    int j = 0;
                    while (j < problems.length) {
                        IProblem problem = problems[j];
                        int line = problem.getSourceLineNumber();
                        JRExpression expression = sourceCode.getExpressionAtLine(line);
                        if (expression != null || lastMessage == null || !lastMessage.equals(problem.getMessage())) {
                            if (expression == null) {
                                JasperReportCompiler.this.errorHandler.addMarker(problem, null);
                            } else if (!this.addExpressionError(expression)) {
                                JasperReportCompiler.this.errorHandler.addMarker(problem, JasperReportCompiler.this.digester.getLocation(expression), expression);
                            }
                            lastMessage = problem.getMessage();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        protected boolean addExpressionError(JRExpression expression) {
            boolean b = this.expressions.contains(expression);
            if (!b) {
                this.expressions.add(expression);
            }
            return b;
        }
    }
}

