/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXParseException;

public class Markers {
    public static final String MARKER_TYPE = "net.sf.jasperreports.jrxmlProblem.marker";

    public static IMarker addMarker(IResource file, Throwable e) throws CoreException {
        if (e instanceof JRException && e.getCause() instanceof SAXParseException) {
            e = e.getCause();
        }
        if (e instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)e;
            return Markers.addMarker(file, e.getMessage(), se.getLineNumber(), se.getColumnNumber(), 2);
        }
        if (e instanceof JRException && e.getCause() != null) {
            Markers.addMarker(file, e.getCause());
        } else if (e instanceof JRException && ((JRException)e).getArgs() != null) {
            Object[] objectArray = ((JRException)e).getArgs();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                HashSet<String> set = new HashSet<String>();
                String[] errors = ((String)arg).split("\\d+\\.");
                Object object = errors;
                int n3 = errors.length;
                int n4 = 0;
                while (n4 < n3) {
                    String er = object[n4];
                    if (!er.isEmpty()) {
                        int indx = (er = StringUtils.normalizeSpace((String)er)).indexOf("<-");
                        if (indx >= 0) {
                            er = er.substring(0, er.indexOf("<-"));
                        }
                        set.add(er);
                    }
                    ++n4;
                }
                IMarker fMarker = null;
                Pattern p = Pattern.compile("//\\$JR_EXPR_ID=\\d+\\$");
                object = set.iterator();
                while (object.hasNext()) {
                    String s;
                    String msg = s = (String)object.next();
                    int indx = s.indexOf("//$JR_EXPR_ID=");
                    if (indx >= 0) {
                        msg = msg.substring(0, indx);
                    }
                    IMarker m = Markers.addMarker(file, msg, 0, 0, 2);
                    Matcher match = p.matcher(s);
                    while (match.find()) {
                        String gr = match.group();
                        gr = gr.substring("//$JR_EXPR_ID=".length());
                        m.setAttribute("MARKER_ERROR_JREXPRESSION", (Object)gr.substring(0, gr.length() - 1));
                    }
                    if (fMarker != null) continue;
                    fMarker = m;
                }
                if (fMarker != null) {
                    return fMarker;
                }
                ++n2;
            }
        }
        return Markers.addMarker(file, e.getMessage() != null ? e.getMessage().replace("\n", "") : e.getClass().getName(), 0, 0, 2);
    }

    public static IMarker addMarker(IResource file, String message, int lineNumber, int severity) throws CoreException {
        return Markers.addMarker(file, message, lineNumber, 0, severity);
    }

    public static IMarker addMarker(IResource file, String message, int lineNumber, int colNumber, int severity) throws CoreException {
        IMarker marker = file.createMarker(MARKER_TYPE);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", severity);
        marker.setAttribute("userEditable", false);
        marker.setAttribute("lineNumber", Math.max(0, lineNumber));
        marker.setAttribute("charEnd", Math.max(0, colNumber));
        Markers.createProjectMarker(file.getProject(), file);
        return marker;
    }

    public static void createProjectMarker(IProject project, IResource resource) {
        try {
            IMarker marker;
            boolean found = false;
            IMarker[] iMarkerArray = resource.getProject().findMarkers(MARKER_TYPE, false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                if (marker.getAttribute("sourceId", "").equals(resource.getFullPath().toOSString())) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                marker = project.createMarker(MARKER_TYPE);
                marker.setAttribute("message", (Object)MessageFormat.format(Messages.Markers_projectErrorMarker, resource.getName()));
                marker.setAttribute("sourceId", (Object)resource.getFullPath().toOSString());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void deleteMarkers(IResource resource) throws CoreException {
        if (resource != null) {
            resource.deleteMarkers(MARKER_TYPE, false, 0);
            ArrayList<IMarker> projectMarkerToDelete = new ArrayList<IMarker>();
            IMarker[] iMarkerArray = resource.getProject().findMarkers(MARKER_TYPE, false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Object source_id = marker.getAttribute("sourceId");
                if (source_id == null || source_id.equals(resource.getFullPath().toOSString())) {
                    projectMarkerToDelete.add(marker);
                }
                ++n2;
            }
            for (IMarker marker : projectMarkerToDelete) {
                marker.delete();
            }
        }
    }
}

