/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder.jdt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.extensions.DefaultExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections4.map.ReferenceMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertyShowInContext;

public final class JDTUtils {
    public static final IWorkspaceRoot WS_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static boolean P_LINKED_RESOURCES_STATUS = false;
    private static boolean LINKED_RESOURCES_STATUS_GUARD = false;

    private JDTUtils() {
    }

    public static void clearJRRegistry(ClassLoader jConfigClassLoader) {
        try {
            Field privateStringField = DefaultExtensionsRegistry.class.getDeclaredField("registrySetCache");
            privateStringField.setAccessible(true);
            ReferenceMap privateObject = (ReferenceMap)privateStringField.get(ExtensionsEnvironment.getExtensionsRegistry());
            privateObject.remove((Object)jConfigClassLoader);
        }
        catch (Exception e) {
            JasperReportsPlugin.getDefault().logError(Messages.JDTUtils_ErrorRefreshingExtensions, e);
            e.printStackTrace();
        }
    }

    public static IProject getCurrentProjectForOpenEditor() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            IEditorInput editorInput;
            IFile file;
            ShowInContext showInContext;
            IWorkbenchPart activePart;
            IEditorPart p = activeWorkbenchWindow.getActivePage().getActiveEditor();
            if (p == null && (activePart = activeWorkbenchWindow.getActivePage().getActivePart()) instanceof PropertySheet && (showInContext = ((PropertySheet)activePart).getShowInContext()) instanceof PropertyShowInContext) {
                IWorkbenchPart part = ((PropertyShowInContext)showInContext).getPart();
                if (part instanceof IEditorPart) {
                    p = (IEditorPart)part;
                } else {
                    JasperReportsPlugin.getDefault().logWarning(Messages.JDTUtils_NoProjectFromCurrentEditorErr);
                    return null;
                }
            }
            if (p != null && (file = JDTUtils.getFile(editorInput = p.getEditorInput())) != null) {
                return file.getProject();
            }
        }
        return null;
    }

    public static IFile getFile(IEditorInput editorInput) {
        IFile file = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            file = fileEditorInput.getFile();
        } else if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathInput = (IPathEditorInput)editorInput;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (wsRoot.getLocation().isPrefixOf(pathInput.getPath())) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(pathInput.getPath());
            }
        } else if (editorInput instanceof IStorageEditorInput) {
            file = null;
        } else if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            URI uri = uriEditorInput.getURI();
            String path = uri.getPath();
            if (uri.getScheme().equals("file") && (uri.getHost() == null || uri.getHost().equals("localhost")) && !path.startsWith(wsRoot.getLocation().toOSString())) {
                file = wsRoot.getFile((IPath)new Path(path));
            }
        }
        return file;
    }

    public static void formatUnitSourceCode(ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
        ISourceRange range = unit.getSourceRange();
        TextEdit formatEdit = formatter.format(8, unit.getSource(), range.getOffset(), range.getLength(), 0, null);
        if (formatEdit != null && formatEdit.hasChildren()) {
            unit.applyTextEdit(formatEdit, monitor);
        } else {
            monitor.done();
        }
    }

    public static boolean isOrCanAdaptTo(IAdaptable adaptable, Class<?> clazz) {
        Assert.isNotNull(clazz);
        if (clazz.isInstance(adaptable)) {
            return true;
        }
        return adaptable != null && adaptable.getAdapter(clazz) != null;
    }

    public static <T> T getAdaptedObject(IAdaptable adaptable, Class<T> clazz) {
        Assert.isNotNull(clazz);
        if (clazz.isInstance(adaptable)) {
            return (T)adaptable;
        }
        Object adaptedObj = null;
        if (adaptable != null) {
            adaptedObj = adaptable.getAdapter(clazz);
        }
        return (T)adaptedObj;
    }

    public static void organizeImport(ICompilationUnit unit) {
        OrganizeImportsAction org = new OrganizeImportsAction((IWorkbenchSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
        StructuredSelection selection = new StructuredSelection((Object)unit);
        org.run((IStructuredSelection)selection);
    }

    public static void formatAndOrganizeImports(ICompilationUnit[] units) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            JDTUtils.organizeImport(unit);
            try {
                JDTUtils.formatUnitSourceCode(unit, (IProgressMonitor)monitor);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static void formatAndOrganizeImports(IFile[] units) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile[] iFileArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IFile unitFile = iFileArray[n2];
            ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)unitFile);
            JDTUtils.organizeImport(unit);
            try {
                JDTUtils.formatUnitSourceCode(unit, (IProgressMonitor)monitor);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static boolean isVirtualResource(IPath path) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        return res != null && res.isVirtual();
    }

    public static synchronized void deactivateLinkedResourcesSupport() {
        if (LINKED_RESOURCES_STATUS_GUARD) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        P_LINKED_RESOURCES_STATUS = preferences.getBoolean("description.disableLinking", false);
        preferences.putBoolean("description.disableLinking", true);
        LINKED_RESOURCES_STATUS_GUARD = true;
    }

    public static synchronized void activateLinkedResourcesSupport() {
        if (LINKED_RESOURCES_STATUS_GUARD) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        P_LINKED_RESOURCES_STATUS = preferences.getBoolean("description.disableLinking", false);
        preferences.putBoolean("description.disableLinking", false);
        LINKED_RESOURCES_STATUS_GUARD = true;
    }

    public static synchronized void restoreLinkedResourcesSupport() {
        if (!LINKED_RESOURCES_STATUS_GUARD) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        preferences.putBoolean("description.disableLinking", P_LINKED_RESOURCES_STATUS);
        LINKED_RESOURCES_STATUS_GUARD = false;
    }

    public static synchronized boolean isAllowdLinkedResourcesSupport() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        return !preferences.getBoolean("description.disableLinking", false);
    }

    public static synchronized void setLinkedResourcesSupport(boolean value) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        preferences.putBoolean("description.disableLinking", !value);
    }

    public static synchronized void deactivateLinkedResourcesSupport(boolean disableSupport) {
        if (disableSupport) {
            JDTUtils.deactivateLinkedResourcesSupport();
        } else {
            JDTUtils.restoreLinkedResourcesSupport();
        }
    }

    public static synchronized void forceWorkspaceCompilerSettings(String javaVersion) {
        Hashtable currentOptions = JavaCore.getOptions();
        String compilerCompliance = (String)currentOptions.get("org.eclipse.jdt.core.compiler.compliance");
        String compilerCodegenTargetPlatform = (String)currentOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
        String compilerSource = (String)currentOptions.get("org.eclipse.jdt.core.compiler.source");
        if (compilerCompliance != null && "1.6".compareTo(compilerCompliance) > 0) {
            currentOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
        }
        if (compilerSource != null && "1.6".compareTo(compilerSource) > 0) {
            currentOptions.put("org.eclipse.jdt.core.compiler.source", "1.6");
        }
        if (compilerCodegenTargetPlatform != null && "1.6".compareTo(compilerCodegenTargetPlatform) > 0) {
            currentOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        }
    }

    public static synchronized void forceJRProjectCompilerSettings(IJavaProject project, String javaVersion) {
        Map projectOptions = project.getOptions(false);
        if (projectOptions != null && !projectOptions.isEmpty()) {
            String compilerCompliance = (String)projectOptions.get("org.eclipse.jdt.core.compiler.compliance");
            String compilerCodegenTargetPlatform = (String)projectOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            String compilerSource = (String)projectOptions.get("org.eclipse.jdt.core.compiler.source");
            if (compilerCompliance != null && "1.6".compareTo(compilerCompliance) > 0) {
                projectOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            }
            if (compilerSource != null && "1.6".compareTo(compilerSource) > 0) {
                projectOptions.put("org.eclipse.jdt.core.compiler.source", "1.6");
            }
            if (compilerCodegenTargetPlatform != null && "1.6".compareTo(compilerCodegenTargetPlatform) > 0) {
                projectOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            }
        }
    }

    public static void copyDirectoryToWorkspace(File source, IContainer destination, boolean createFolder) throws CoreException, FileNotFoundException {
        if (source == null || !source.isDirectory()) {
            return;
        }
        if (createFolder) {
            IFolder newFolder = destination.getFolder((IPath)new Path(source.getName()));
            newFolder.create(true, true, null);
            destination = newFolder;
        }
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                IFolder newFolder = destination.getFolder((IPath)new Path(f.getName()));
                newFolder.create(true, true, null);
                JDTUtils.copyDirectoryToWorkspace(f, (IContainer)newFolder, false);
            } else {
                IFile newFile = destination.getFile((IPath)new Path(f.getName()));
                newFile.create((InputStream)new FileInputStream(f), true, null);
            }
            ++n2;
        }
    }

    public static void copyFileToWorkspace(File source, IContainer destination) throws FileNotFoundException, CoreException {
        if (source == null || source.isDirectory()) {
            return;
        }
        IFile newFile = destination.getFile((IPath)new Path(source.getName()));
        newFile.create((InputStream)new FileInputStream(source), true, null);
    }

    public static void deleteAllJRProjectMarkers() {
        IProject[] iProjectArray = WS_ROOT.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            try {
                if (prj.hasNature("net.sf.jasperreports.nature")) {
                    prj.deleteMarkers("net.sf.jasperreports.jrxmlProblem.marker", true, 2);
                }
            }
            catch (CoreException e) {
                JasperReportsPlugin.getDefault().logError(NLS.bind((String)Messages.JDTUtils_ProblemDeletingErrorMarkers, (Object)prj.getName()), e);
            }
            ++n2;
        }
    }
}

