/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.classpath.container;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class JRDependenciesClasspathContainer
implements IClasspathContainer {
    public static final IPath ID = new Path("net.sf.jasperreports.JR_DEPENDENCIES_CONTAINER");
    private static final List<String> bundlesList = new ArrayList<String>();
    private IPath path;
    private List<IClasspathEntry> entriesList;

    static {
        bundlesList.add("org.apache.commons.commons-io");
        bundlesList.add("groovy");
        bundlesList.add("org.krysalis.barcode4j");
        bundlesList.add("org.w3c.dom.svg");
        bundlesList.add("org.jfree.chart-osgi");
        bundlesList.add("org.jfree.jcommon-osgi");
        bundlesList.add("jaxen");
        bundlesList.add("org.apache.servicemix.bundles.rhino");
        bundlesList.add("org.apache.servicemix.bundles.xmlbeans");
        bundlesList.add("org.apache.servicemix.bundles.antlr");
        bundlesList.add("org.apache.commons.collections");
        bundlesList.add("org.apache.commons.collections4");
        bundlesList.add("org.apache.commons.lang3");
        bundlesList.add("org.apache.commons.logging");
        bundlesList.add("com.jaspersoft.studio.bundles.barbecue");
        bundlesList.add("com.jaspersoft.studio.bundles.commons-beanutils");
        bundlesList.add("com.jaspersoft.studio.bundles.commons-digester");
        bundlesList.add("com.jaspersoft.studio.bundles.batik");
        bundlesList.add("com.jaspersoft.studio.bundles.beanshell");
        bundlesList.add("com.jaspersoft.studio.bundles.poi");
        bundlesList.add("com.jaspersoft.studio.bundles.jackson");
        bundlesList.add("org.apache.logging.log4j.api");
        bundlesList.add("bcprov");
        bundlesList.add("bcpg");
        bundlesList.add("org.apache.httpcomponents.httpcore");
        bundlesList.add("org.apache.httpcomponents.httpclient");
        bundlesList.add("com.github.librepdf.openpdf");
    }

    public JRDependenciesClasspathContainer(IPath containerPath) {
        this.path = containerPath;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.entriesList == null) {
            this.entriesList = new ArrayList<IClasspathEntry>();
            this.addRequiredBundles(this.entriesList);
            this.addRequiredJars(this.entriesList);
        }
        return this.entriesList.toArray(new IClasspathEntry[this.entriesList.size()]);
    }

    private void addRequiredBundles(List<IClasspathEntry> entries) {
        for (String id : bundlesList) {
            Bundle bundle = BundleCommonUtils.getBundle(id);
            if (bundle == null) {
                JasperReportsPlugin.getDefault().logError(new RuntimeException(NLS.bind((String)"Unable to find the bundle {0}", (Object)id)));
                continue;
            }
            String location = BundleCommonUtils.getBundleAbsoluteLocation(bundle);
            if (location == null) continue;
            entries.add(JavaCore.newLibraryEntry((IPath)new Path(location), null, null));
            List<File> extractedJars = BundleCommonUtils.extractAllJarsFromBundle(bundle);
            for (File f : extractedJars) {
                entries.add(JavaCore.newLibraryEntry((IPath)new Path(f.getAbsolutePath()), null, null));
            }
        }
    }

    private void addRequiredJars(List<IClasspathEntry> entries) {
        ArrayList<URL> jarURLS = new ArrayList<URL>();
        Bundle jrBundle = BundleCommonUtils.getBundle("net.sf.jasperreports");
        jarURLS.add(jrBundle.getEntry("lib/castor-core-1.4.1.jar"));
        jarURLS.add(jrBundle.getEntry("lib/castor-xml-1.4.1.jar"));
        jarURLS.add(jrBundle.getEntry("lib/spring/spring-core-5.3.27.jar"));
        jarURLS.add(jrBundle.getEntry("lib/spring/spring-beans-5.3.27.jar"));
        jarURLS.add(jrBundle.getEntry("lib/spring/spring-expression-5.3.27.jar"));
        jarURLS.add(jrBundle.getEntry("lib/fastexcel/aalto-xml-1.3.2.jar"));
        jarURLS.add(jrBundle.getEntry("lib/fastexcel/fastexcel-reader-0.15.6.jar"));
        Bundle jssBundle = BundleCommonUtils.getBundle("com.jaspersoft.studio");
        jarURLS.add(jssBundle.getEntry("lib/velocity-1.7-dep.jar"));
        for (URL url : jarURLS) {
            try {
                URL fileURL = FileLocator.toFileURL((URL)url);
                URI uri = new URI(fileURL.getProtocol(), fileURL.getUserInfo(), fileURL.getHost(), fileURL.getPort(), fileURL.getPath(), fileURL.getQuery(), null);
                Path binpath = new Path(new File(uri).getAbsolutePath());
                entries.add(JavaCore.newLibraryEntry((IPath)binpath, null, null));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public String getDescription() {
        return Messages.JRDependenciesClasspathContainer_Description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }
}

