/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.preferences.IPreferencePageExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class PreferencesExtensionsManager {
    private static HashMap<String, List<IPreferencePageExtension>> contributedPreferencePages = null;

    private static void initContributedPreferencesPages() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("net.sf.jasperreports", "preferencePageExtension");
        contributedPreferencePages = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                Object defaultSupportClazz = el.createExecutableExtension("class");
                if (defaultSupportClazz instanceof IPreferencePageExtension) {
                    IPreferencePageExtension handler = (IPreferencePageExtension)defaultSupportClazz;
                    String extendedPage = el.getAttribute("extendedPageId");
                    if (extendedPage != null) {
                        List<IPreferencePageExtension> pagesExtension = contributedPreferencePages.get(extendedPage);
                        if (pagesExtension == null) {
                            pagesExtension = new ArrayList<IPreferencePageExtension>();
                            pagesExtension.add(handler);
                            contributedPreferencePages.put(extendedPage, pagesExtension);
                        } else {
                            pagesExtension.add(handler);
                        }
                    }
                }
            }
            catch (CoreException e) {
                JasperReportsPlugin.getDefault().log((IStatus)new Status(4, "net.sf.jasperreports", "An error occurred while trying to create the new class.", (Throwable)e));
            }
            ++n2;
        }
    }

    public static List<IPreferencePageExtension> getContributedPreferencePages(String extendedPageId) {
        if (contributedPreferencePages == null) {
            PreferencesExtensionsManager.initContributedPreferencesPages();
        }
        List<IPreferencePageExtension> pages = contributedPreferencePages.get(extendedPageId);
        return pages;
    }

    public static List<IPreferencePageExtension> getContributedPreferencePages() {
        if (contributedPreferencePages == null) {
            PreferencesExtensionsManager.initContributedPreferencesPages();
        }
        ArrayList<IPreferencePageExtension> pages = new ArrayList<IPreferencePageExtension>();
        for (Map.Entry<String, List<IPreferencePageExtension>> entry : contributedPreferencePages.entrySet()) {
            pages.addAll((Collection<IPreferencePageExtension>)entry.getValue());
        }
        return pages;
    }
}

