/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public class ATitledDialog
extends PersistentLocationDialog {
    private String description;
    protected String errormsg;
    protected String title;
    private Label lDesc;
    private CLabel lError;
    private Image errImg;
    private Image warnImg;
    private boolean canClose = true;
    protected Composite tcmp;
    private Map<Control, Boolean> statemap = new HashMap<Control, Boolean>();

    protected ATitledDialog(Shell parentShell) {
        super(parentShell);
    }

    protected ATitledDialog(Shell parentShell, boolean saveSettings) {
        super(parentShell);
        this.setSaveSettings(saveSettings);
    }

    protected ATitledDialog(Shell parentShell, int style, boolean saveSettings) {
        this(parentShell, saveSettings);
        this.setShellStyle(style);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        if (this.description != null && this.description.equals(description)) {
            return;
        }
        this.description = description == null ? "" : description;
        this.setBackground();
        if (this.lDesc != null) {
            this.lDesc.setText(this.description);
            ((GridData)this.lDesc.getLayoutData()).exclude = description == null || description.isEmpty();
            this.tcmp.getParent().update();
            this.tcmp.getParent().layout(true);
        }
    }

    public void setError(String errormsg) {
        if (this.errormsg == null && errormsg == null || this.errormsg != null && this.errormsg.isEmpty() && errormsg == null || this.errormsg == null && errormsg.isEmpty() || this.errormsg != null && errormsg != null && this.errormsg.equals(errormsg)) {
            return;
        }
        this.errormsg = errormsg == null ? "" : errormsg;
        this.setBackground();
        if (this.lError != null) {
            this.lError.setImage(this.errImg);
            this.lError.setText(this.errormsg);
            ((GridData)this.lError.getLayoutData()).exclude = errormsg == null || errormsg.isEmpty();
            this.tcmp.getParent().update();
            this.tcmp.getParent().layout(true);
            UIUtils.relayoutDialogHeight(this.getShell(), this.defheight);
        }
    }

    public void setWarning(String errormsg) {
        if (this.errormsg == null && errormsg == null || this.errormsg != null && this.errormsg.isEmpty() && errormsg == null || this.errormsg == null && errormsg.isEmpty() || this.errormsg != null && errormsg != null && this.errormsg.equals(errormsg)) {
            return;
        }
        this.errormsg = errormsg == null ? "" : errormsg;
        this.setBackground();
        if (this.lError != null) {
            ImageDescriptor id;
            if (this.warnImg == null && (id = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.fieldassist.IMG_DEC_FIELD_WARNING")) != null) {
                this.warnImg = id.createImage();
            }
            this.lError.setImage(this.warnImg);
            this.lError.setText(this.errormsg);
            ((GridData)this.lError.getLayoutData()).exclude = errormsg == null || errormsg.isEmpty();
            this.tcmp.getParent().update();
            this.tcmp.getParent().layout(true);
            UIUtils.relayoutDialogHeight(this.getShell(), this.defheight);
        }
    }

    private void setBackground() {
        if (this.tcmp != null) {
            if (this.description != null && !this.description.isEmpty() || this.errormsg != null && !this.errormsg.isEmpty()) {
                this.tcmp.setBackground(SWTResourceManager.getColor(1));
            } else {
                this.tcmp.setBackground(SWTResourceManager.getColor(22));
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.tcmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        this.tcmp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.tcmp.setLayoutData((Object)gd);
        this.tcmp.setBackgroundMode(1);
        this.setBackground();
        this.lDesc = new Label(this.tcmp, 64);
        this.lDesc.setText(this.description != null ? this.description : "");
        gd = new GridData(1808);
        if (this.defwidth > 0) {
            gd.widthHint = this.defwidth - 10;
        }
        this.lDesc.setLayoutData((Object)gd);
        ((GridData)this.lDesc.getLayoutData()).exclude = this.description == null || this.description.isEmpty();
        this.lError = new CLabel(this.tcmp, 64);
        this.lError.setText(this.errormsg != null ? this.errormsg : "");
        gd = new GridData(1808);
        this.lError.setLayoutData((Object)gd);
        ImageDescriptor id = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.fieldassist.IMG_DEC_FIELD_ERROR");
        if (id != null) {
            this.errImg = id.createImage();
            this.lError.setImage(this.errImg);
        }
        ((GridData)this.lError.getLayoutData()).exclude = this.errormsg == null || this.errormsg.isEmpty();
        return super.createDialogArea(parent);
    }

    @Override
    public boolean close() {
        if (this.errImg != null) {
            this.errImg.dispose();
        }
        if (this.warnImg != null) {
            this.warnImg.dispose();
        }
        return super.close();
    }

    public int openChildDialog(Dialog child) {
        UIUtils.setEnabled(this.dialogArea, this.statemap, false);
        this.canClose = false;
        int result = 1;
        try {
            result = child.open();
        }
        finally {
            UIUtils.setEnabled(this.dialogArea, this.statemap, true);
            this.canClose = true;
        }
        return result;
    }

    protected void okPressed() {
        if (this.canClose) {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.canClose) {
            super.cancelPressed();
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return this.canClose;
    }

    public static void canFinish(Dialog d, boolean finish) {
        try {
            Method m = Dialog.class.getDeclaredMethod("getButton", Integer.TYPE);
            m.setAccessible(true);
            Button b = (Button)m.invoke((Object)d, 0);
            if (b != null) {
                b.setEnabled(finish);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

