/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ValueChangedEvent;
import net.sf.jasperreports.eclipse.ui.ValueChangedListener;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.wb.swt.ResourceManager;

public class JSSTableCombo
extends Composite {
    public static final int NO_IMAGE = 2;
    public static final int STRIGHT_CORNER = 4;
    protected static final int CORNER_SIZE = 5;
    protected static final int ARROW_WIDTH = 7;
    protected static final int ARROW_HEIGHT = 4;
    private Shell popup;
    private Canvas arrow;
    private Label imageLabel;
    private StyledText text;
    private Table table;
    private Font font;
    private boolean hasFocus;
    private int visibleItemCount = 7;
    private Listener listener;
    private Listener focusFilter;
    private int displayColumnIndex = 0;
    private int[] columnWidths;
    private String[] columnHeaders;
    private int totalColumns;
    private int tableWidthPercentage = 100;
    private boolean showColorWithinSelection = true;
    private boolean showFontWithinSelection = true;
    private Color defaultBackgroundColor;
    protected static final int ARROW_AREA_WIDTH = 15;
    private Image displayedImage;
    private List<ValueChangedListener> modifyListeners = null;
    private Point cachedImageSize = null;
    private boolean isInherited = false;
    protected Color inheritedColor = UIUtils.INHERITED_COLOR;
    private Color standardColor;
    private boolean fullSelectionHappened = false;
    private LinkedHashMap<Listener, Pair<Integer, Listener>> textListeners = new LinkedHashMap();
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (JSSTableCombo.this.modifyListeners == null || JSSTableCombo.this.modifyListeners.isEmpty()) {
                return;
            }
            Point selection = JSSTableCombo.this.text.getSelection();
            ValueChangedEvent event = new ValueChangedEvent(JSSTableCombo.this.text.getText(), null, true);
            for (ValueChangedListener listener : JSSTableCombo.this.modifyListeners) {
                listener.valueChanged(event);
            }
            JSSTableCombo.this.text.setSelection(selection);
        }
    };
    protected MouseListener mousePressListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            JSSTableCombo.this.text.setFocus();
            JSSTableCombo.this.dropDown(!JSSTableCombo.this.isDropped());
        }
    };

    public JSSTableCombo(Composite parent, int style) {
        super(parent, style);
        boolean readOnly = (style & 8) == 8;
        this.imageLabel = new Label((Composite)this, 0);
        this.text = new StyledText(this, readOnly ? 8 : 0){

            protected void checkSubclass() {
            }

            public void addListener(int eventType, Listener listener) {
                if (!JSSTableCombo.this.textListeners.containsKey(listener)) {
                    super.addListener(eventType, listener);
                    if (eventType == 24 || eventType == 25) {
                        JSSTableCombo.this.textListeners.put(listener, new Pair<Integer, Listener>(eventType, listener));
                    }
                }
            }

            protected void removeListener(int eventType, SWTEventListener handler) {
                super.removeListener(eventType, handler);
                if (eventType == 24 || eventType == 25) {
                    JSSTableCombo.this.textListeners.remove(handler);
                }
            }

            public void removeListener(int eventType, Listener listener) {
                super.removeListener(eventType, listener);
                if (eventType == 24 || eventType == 25) {
                    JSSTableCombo.this.textListeners.remove(listener);
                }
            }
        };
        this.standardColor = this.text.getForeground();
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        this.defaultBackgroundColor = currentTheme.getColorRegistry().get("CONTENT_ASSIST_BACKGROUND_COLOR");
        this.arrow = new Canvas((Composite)this, 0);
        super.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle availableSize = composite.getClientArea();
                int xOffsetLeft = 3;
                int xOffsetRight = 1;
                int imageWidth = 0;
                int imageYOffset = 1;
                int imageHeight = 0;
                if (JSSTableCombo.this.displayedImage != null) {
                    int maxAvailableWidth = (availableSize.width + xOffsetLeft + xOffsetRight) / 2;
                    imageWidth = Math.min(JSSTableCombo.this.getImageSize().x, maxAvailableWidth);
                    if (JSSTableCombo.this.getImageSize().y > availableSize.height - 2) {
                        imageHeight = availableSize.height - 2;
                    } else {
                        imageYOffset = (availableSize.height - JSSTableCombo.this.getImageSize().y) / 2;
                        imageHeight = JSSTableCombo.this.getImageSize().y;
                    }
                }
                int textMaxWidth = availableSize.width - 15 - imageWidth - xOffsetLeft - xOffsetRight;
                List<Pair<Integer, Listener>> textListeners = JSSTableCombo.this.removeTextListeners(true);
                String oldString = JSSTableCombo.this.text.getText();
                JSSTableCombo.this.text.setText(JSSTableCombo.this.getLongestText());
                Point textAreaSize = JSSTableCombo.this.text.computeSize(textMaxWidth, availableSize.height - 2);
                textAreaSize.x = Math.min(textMaxWidth, textAreaSize.x);
                JSSTableCombo.this.text.setText(oldString);
                JSSTableCombo.this.restoreTextListeners(textListeners);
                JSSTableCombo.this.imageLabel.setBounds(xOffsetLeft, imageYOffset, imageWidth, imageHeight);
                JSSTableCombo.this.text.setBounds(xOffsetLeft += imageWidth, 1, textAreaSize.x, availableSize.height - 2);
                JSSTableCombo.this.arrow.setBounds(textMaxWidth + xOffsetLeft, 1, 15 - xOffsetRight, availableSize.height - 2);
                Color background = JSSTableCombo.this.getWidgetsBackground(JSSTableCombo.this.getDisplay());
                JSSTableCombo.this.setCompositeBackgroundColor(background);
                JSSTableCombo.this.imageLabel.setBackground(background);
                JSSTableCombo.this.text.setBackground(background);
                JSSTableCombo.this.redraw();
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point textAreaSize = null;
                List<Pair<Integer, Listener>> textListeners = JSSTableCombo.this.removeTextListeners(true);
                String oldString = JSSTableCombo.this.text.getText();
                JSSTableCombo.this.text.setText(JSSTableCombo.this.getLongestText());
                textAreaSize = JSSTableCombo.this.text.computeSize(wHint, hHint);
                JSSTableCombo.this.text.setText(oldString);
                JSSTableCombo.this.restoreTextListeners(textListeners);
                int xOffsetLeft = 3;
                int xOffsetRight = 1;
                textAreaSize.x += 15 + xOffsetLeft + xOffsetRight;
                if (JSSTableCombo.this.displayedImage != null) {
                    textAreaSize.x += JSSTableCombo.this.getImageSize().x;
                    textAreaSize.y += JSSTableCombo.this.getImageSize().y;
                }
                if (textAreaSize.y < 20) {
                    textAreaSize.y = 20;
                }
                Point tableSize = JSSTableCombo.this.table != null ? JSSTableCombo.this.table.computeSize(-1, -1, flushCache) : new Point(0, 0);
                return new Point(Math.max(tableSize.x, textAreaSize.x), textAreaSize.y);
            }
        });
        this.arrow.addMouseListener(this.mousePressListener);
        this.arrow.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Color wb;
                Rectangle bounds = JSSTableCombo.this.arrow.getBounds();
                if (e.display != null && (wb = JSSTableCombo.this.getWidgetsBackground(e.display)) != null) {
                    e.gc.setBackground(wb);
                }
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setBackground(ResourceManager.getColor(0, 0, 0));
                int y = bounds.height / 2;
                int x = bounds.width / 2;
                int y1 = y - 2;
                int y2 = y + 2;
                int x3 = x;
                int x1 = x - 3;
                int x2 = x + 3;
                e.gc.fillPolygon(new int[]{x1, y1, x2, y1, x3, y2});
            }
        });
        this.createBorderPaintListener();
        this.text.addModifyListener(this.textModifyListener);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 9) {
                    boolean isShiftPressed;
                    e.doit = false;
                    boolean bl = isShiftPressed = (e.stateMask & 0x20000) != 0;
                    if (isShiftPressed) {
                        JSSTableCombo.this.focusPreviousControl((Control)JSSTableCombo.this);
                    } else {
                        JSSTableCombo.this.focusNextControl((Control)JSSTableCombo.this);
                    }
                }
            }
        });
        this.text.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.keyCode == 9) {
                    event.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (JSSTableCombo.this.isInherited && !JSSTableCombo.this.fullSelectionHappened) {
                    JSSTableCombo.this.text.selectAll();
                    JSSTableCombo.this.fullSelectionHappened = true;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                JSSTableCombo.this.fullSelectionHappened = false;
                JSSTableCombo.this.text.setSelection(0, 0);
            }
        });
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (JSSTableCombo.this.isDisposed()) {
                    return;
                }
                if (JSSTableCombo.this.popup == event.widget) {
                    JSSTableCombo.this.popupEvent(event);
                    return;
                }
                if (JSSTableCombo.this.table == event.widget) {
                    JSSTableCombo.this.tableEvent(event);
                    return;
                }
                if (JSSTableCombo.this.getShell() == event.widget) {
                    JSSTableCombo.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (JSSTableCombo.this.isDisposed()) {
                                return;
                            }
                            JSSTableCombo.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.focusFilter = new Listener(){

            public void handleEvent(Event event) {
                if (JSSTableCombo.this.isDisposed()) {
                    return;
                }
                Shell shell = ((Control)event.widget).getShell();
                if (shell == JSSTableCombo.this.getShell()) {
                    JSSTableCombo.this.handleFocus(16);
                }
            }
        };
        this.createPopup(-1);
    }

    protected List<Pair<Integer, Listener>> removeTextListeners(boolean removeVerify) {
        ArrayList<Pair<Integer, Listener>> listeners = new ArrayList<Pair<Integer, Listener>>();
        listeners.addAll(this.textListeners.values());
        for (Pair pair : listeners) {
            if (!removeVerify && (Integer)pair.getKey() == 25) continue;
            this.text.removeListener(((Integer)pair.getKey()).intValue(), (Listener)pair.getValue());
        }
        return listeners;
    }

    protected void restoreTextListeners(List<Pair<Integer, Listener>> listeners) {
        for (Pair<Integer, Listener> listener : listeners) {
            this.text.addListener(listener.getKey().intValue(), listener.getValue());
        }
    }

    private void focusPreviousControl(Control currentControl) {
        Object[] children = currentControl.getParent().getChildren();
        int index = ArrayUtils.indexOf((Object[])children, (Object)currentControl);
        if (index > 0) {
            boolean hasFocused = children[index - 1].forceFocus();
            if (!hasFocused) {
                this.focusPreviousControl((Control)currentControl.getParent());
            }
        } else {
            this.focusPreviousControl((Control)currentControl.getParent());
        }
    }

    private void focusNextControl(Control currentControl) {
        Object[] children = currentControl.getParent().getChildren();
        int index = ArrayUtils.indexOf((Object[])children, (Object)currentControl);
        if (index != -1 && index < children.length - 1) {
            boolean hasFocused = children[index + 1].forceFocus();
            if (!hasFocused) {
                this.focusNextControl((Control)currentControl.getParent());
            }
        } else {
            this.focusNextControl((Control)currentControl.getParent());
        }
    }

    protected void setCompositeBackgroundColor(Color color) {
        super.setBackground(color);
    }

    protected Color getWidgetsBackground(Display display) {
        return this.defaultBackgroundColor;
    }

    public void addListener(int eventType, Listener listener) {
        if (eventType == 9) {
            super.addListener(eventType, listener);
        } else {
            this.text.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (eventType == 9) {
            super.removeListener(eventType, listener);
        } else {
            this.text.removeListener(eventType, listener);
        }
    }

    public void addModifyListener(ValueChangedListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ArrayList<ValueChangedListener>();
        }
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ValueChangedListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ArrayList<ValueChangedListener>();
        }
        this.modifyListeners.remove(listener);
    }

    public boolean hasImage() {
        return this.displayedImage != null && (this.getStyle() & 2) == 0;
    }

    public boolean hasStrightCorner() {
        return (this.getStyle() & 4) != 0;
    }

    protected Point getImageSize() {
        if (this.cachedImageSize == null) {
            this.cachedImageSize = this.calcImageSize();
        }
        return this.cachedImageSize;
    }

    protected Point calcImageSize() {
        Point size = new Point(0, 0);
        if (this.hasImage()) {
            Rectangle bounds = this.displayedImage.getBounds();
            size.x = Math.max(size.x, bounds.width);
            size.y = Math.max(size.y, bounds.height);
        }
        return size;
    }

    protected Color getBorderForeground(Display display, boolean focused) {
        if (focused) {
            return display.getSystemColor(23);
        }
        return display.getSystemColor(18);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.defaultBackgroundColor = color;
        this.layout();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.standardColor = color;
        if (!this.isInherited) {
            this.text.setForeground(color);
        }
    }

    public Color getForeground() {
        this.checkWidget();
        return this.text.getForeground();
    }

    public void addFocusListener(FocusListener listener) {
        this.text.addFocusListener(listener);
    }

    public Menu getMenu() {
        return this.text.getMenu();
    }

    public void setMenu(Menu menu) {
        this.text.setMenu(menu);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.text.addVerifyListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.text.removeVerifyListener(listener);
    }

    public synchronized void setText(String textValue) {
        int index = this.indexOf(textValue);
        if (index == -1) {
            if (this.table != null) {
                this.table.deselectAll();
            }
            List<Pair<Integer, Listener>> textListeners = this.removeTextListeners(true);
            this.text.setText(textValue);
            this.restoreTextListeners(textListeners);
        } else {
            List<Pair<Integer, Listener>> textListeners = this.removeTextListeners(true);
            this.text.setText(textValue);
            this.select(index, false, true);
            this.restoreTextListeners(textListeners);
        }
    }

    public void insert(String textValue) {
        this.text.removeModifyListener(this.textModifyListener);
        this.text.insert(textValue);
        this.text.addModifyListener(this.textModifyListener);
    }

    protected void createBorderPaintListener() {
        PaintListener borderPainter = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = JSSTableCombo.this.getBounds();
                int w = bounds.width - 1;
                int h = bounds.height - 1;
                e.gc.setForeground(JSSTableCombo.this.getBorderForeground(e.display, false));
                if (JSSTableCombo.this.hasStrightCorner()) {
                    e.gc.drawRectangle(0, 0, w, h);
                } else {
                    e.gc.drawRoundRectangle(0, 0, w, h, 5, 5);
                }
            }
        };
        this.addPaintListener(borderPainter);
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.setSelection(0);
        this.table.deselectAll();
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    protected void createPopup(int selectionIndex) {
        this.popup = new Shell(this.getShell(), 16392);
        this.table = new Table((Composite)this.popup, 65540);
        if (this.font != null) {
            this.table.setFont(this.font);
        }
        if (this.defaultBackgroundColor != null) {
            this.table.setBackground(this.defaultBackgroundColor);
        }
        int[] popupEvents = new int[]{21, 9, 27, 28};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        int[] tableEvents = new int[]{4, 13, 31, 1, 2, 15, 12};
        int i2 = 0;
        while (i2 < tableEvents.length) {
            this.table.addListener(tableEvents[i2], this.listener);
            ++i2;
        }
        this.defineColumnsInternal(this.columnHeaders, this.columnWidths, this.totalColumns);
        this.setTableData(this.table);
        if (selectionIndex != -1) {
            this.table.setSelection(selectionIndex);
        }
    }

    protected void setTableData(Table table) {
    }

    protected String getLongestText() {
        return this.text.getText();
    }

    protected int getTopItem(Table table) {
        return -1;
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public void refreshItems() {
        int selectionIndex = this.table.getSelectionIndex();
        this.table.removeListener(12, this.listener);
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.dispose();
        }
        this.popup = null;
        this.table = null;
        this.createPopup(selectionIndex);
    }

    protected void dropDown(boolean drop) {
        TableColumn[] tableColumns;
        int totalColumns;
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop && this.popup != null && !this.popup.isDisposed()) {
            if (this.popup.getDisplay() != null) {
                this.popup.setVisible(false);
            }
            if (!this.isDisposed() && this.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.popup == null || this.getShell() != this.popup.getParent()) {
            int selectionIndex = this.table.getSelectionIndex();
            this.table.removeListener(12, this.listener);
            if (this.popup != null && !this.popup.isDisposed()) {
                this.popup.dispose();
            }
            this.popup = null;
            this.table = null;
            this.createPopup(selectionIndex);
        }
        Point tableComboSize = this.getSize();
        int itemCount = this.table.getItemCount();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount) - 1;
        int itemHeight = this.table.getItemHeight() * itemCount;
        if (this.table.getItemCount() <= this.visibleItemCount) {
            ++itemHeight;
        }
        if (this.table.getHeaderVisible()) {
            itemHeight += this.table.getHeaderHeight();
        }
        int n = totalColumns = (tableColumns = this.table.getColumns()) == null ? 0 : tableColumns.length;
        if (this.table.getColumnCount() == 0) {
            new TableColumn(this.table, 0);
            totalColumns = 1;
            tableColumns = this.table.getColumns();
        }
        int totalColumnWidth = 0;
        int colIndex = 0;
        while (colIndex < totalColumns) {
            if (!this.wasColumnWidthSpecified(colIndex)) {
                tableColumns[colIndex].pack();
            }
            totalColumnWidth += tableColumns[colIndex].getWidth();
            ++colIndex;
        }
        int lastColIndex = totalColumns - 1;
        if (this.wasColumnWidthSpecified(lastColIndex)) {
            tableColumns[lastColIndex].setWidth(this.columnWidths[lastColIndex]);
        }
        Point tableSize = this.table.computeSize(-1, itemHeight, false);
        double pct = (double)this.tableWidthPercentage / 100.0;
        int tableWidth = (int)((double)Math.max(tableComboSize.x - 2, tableSize.x) * pct);
        int tableHeight = tableSize.y;
        if (this.tableWidthPercentage < 100) {
            tableHeight += this.table.getHorizontalBar().getSize().y;
        }
        this.table.setBounds(1, 1, tableWidth, tableHeight);
        if (!this.table.getVerticalBar().getVisible() && tableSize.x - this.table.getVerticalBar().getSize().x >= tableComboSize.x - 2) {
            this.table.setBounds(1, 1, tableWidth -= this.table.getVerticalBar().getSize().x, tableHeight);
        }
        this.autoAdjustColumnWidthsIfNeeded(tableColumns, tableWidth, totalColumnWidth);
        int index = this.table.getSelectionIndex();
        if (index != -1) {
            this.table.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle tableRect = this.table.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int overallWidth = 0;
        overallWidth = this.tableWidthPercentage < 100 ? tableRect.width + 2 : Math.max(comboSize.x, tableRect.width + 2);
        int overallHeight = tableRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + overallHeight > displayRect.y + displayRect.height) {
            y = parentRect.y - overallHeight;
        }
        if (x + overallWidth > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - tableRect.width;
        }
        this.popup.setBounds(x, y, overallWidth, overallHeight);
        this.popup.setVisible(true);
        this.table.setFocus();
        int topItem = this.getTopItem(this.table);
        if (topItem != -1) {
            this.table.setTopIndex(topItem);
        }
    }

    public void dispose() {
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
        if (this.table != null) {
            this.table.dispose();
            this.table = null;
        }
        super.dispose();
        this.standardColor = null;
        this.inheritedColor = null;
    }

    private Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.table.getItem(index).getText(this.getDisplayColumnIndex());
    }

    public int getItemCount() {
        this.checkWidget();
        return this.table.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        TableItem[] tableItems = this.table.getItems();
        int totalItems = tableItems == null ? 0 : tableItems.length;
        String[] stringItems = new String[totalItems];
        int colIndex = this.getDisplayColumnIndex();
        int index = 0;
        while (index < totalItems) {
            stringItems[index] = tableItems[index].getText(colIndex);
            ++index;
        }
        return stringItems;
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.table.getSelectionIndex();
    }

    public int getStyle() {
        this.checkWidget();
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    private void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.focusFilter);
                display.addFilter(15, this.focusFilter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.table) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.focusFilter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if (this.table == null) {
            return -1;
        }
        TableItem[] tableItems = this.table.getItems();
        int totalItems = tableItems == null ? 0 : tableItems.length;
        int colIndex = this.getDisplayColumnIndex();
        int index = 0;
        while (index < totalItems) {
            if (string.equals(tableItems[index].getText(colIndex))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int indexOf(String string, int start) {
        TableItem[] tableItems;
        int totalItems;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int n = totalItems = (tableItems = this.table.getItems()) == null ? 0 : tableItems.length;
        if (start < totalItems) {
            int colIndex = this.getDisplayColumnIndex();
            int index = start;
            while (index < totalItems) {
                if (string.equals(tableItems[index].getText(colIndex))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public int getCaretPosition() {
        return this.text.getSelection().x;
    }

    public void setShowTableLines(boolean showTableLines) {
        this.checkWidget();
        if (this.table != null) {
            this.table.setLinesVisible(showTableLines);
        }
    }

    public void setShowTableHeader(boolean showTableHeader) {
        this.checkWidget();
        if (this.table != null) {
            this.table.setHeaderVisible(showTableHeader);
        }
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = JSSTableCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = JSSTableCombo.this.stripMnemonic(JSSTableCombo.this.text.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = JSSTableCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = JSSTableCombo.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = JSSTableCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = JSSTableCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = JSSTableCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = JSSTableCombo.this.text.getSelection().y;
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                Point sel = JSSTableCombo.this.text.getSelection();
                e.offset = sel.x;
                e.length = sel.y - sel.x;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = JSSTableCombo.this.toControl(e.x, e.y);
                if (JSSTableCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = JSSTableCombo.this.getBounds();
                Point pt = JSSTableCombo.this.getParent().toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = JSSTableCombo.this.text.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = JSSTableCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = JSSTableCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    private boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        if (this.isDisposed()) {
            return false;
        }
        if (this.arrow.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    private void tableEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && this.getShell() == this.popup.getParent()) break;
                int selectionIndex = this.table.getSelectionIndex();
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                this.popup = null;
                this.table = null;
                this.createPopup(selectionIndex);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int index = this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.refreshText(index, true, true);
                this.table.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    private void popupEvent(Event event) {
        block0 : switch (event.type) {
            case 9: {
                Rectangle tableRect = this.table.getBounds();
                event.gc.setForeground(this.getDisplay().getSystemColor(26));
                event.gc.drawRectangle(0, 0, tableRect.width + 1, tableRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (this.isDisposed()) break;
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point point = this.arrow.toControl(this.getDisplay().getCursorLocation());
                    Point size = this.arrow.getSize();
                    Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                    if (rect.contains(point)) break;
                    this.dropDown(false);
                    break;
                }
                this.dropDown(false);
                break;
            }
            case 28: {
                if (this.isDropped()) {
                    this.dropDown(false);
                }
                JSSTableCombo comp = this;
                do {
                    if (comp.getListeners(event.type) == null || comp.getListeners(event.type).length <= 0) continue;
                    comp.notifyListeners(event.type, event);
                    break block0;
                } while ((comp = comp.getParent()) != null);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup != null && this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void select(int index) {
        this.select(index, false, true);
    }

    protected void select(int index, boolean fireEvent, boolean disableTextEvent) {
        this.checkWidget();
        if (index == -1) {
            this.table.deselectAll();
            this.text.setText("");
            this.imageLabel.setImage(null);
            return;
        }
        if (index >= 0 && index < this.table.getItemCount() && index != this.getSelectionIndex()) {
            this.refreshText(index, fireEvent, disableTextEvent);
            this.table.setSelection(index);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.imageLabel != null) {
            this.imageLabel.setEnabled(enabled);
        }
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.text.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.text.forceFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.table.setFont(font);
        this.layout(true, true);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setTableVisible(boolean visible) {
        this.checkWidget();
        this.dropDown(visible);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void selectAll() {
        this.checkWidget();
        this.text.selectAll();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String tipText) {
        this.checkWidget();
        super.setToolTipText(tipText);
        if (this.imageLabel != null) {
            this.imageLabel.setToolTipText(tipText);
        }
        if (this.text != null) {
            this.text.setToolTipText(tipText);
        }
        if (this.arrow != null) {
            this.arrow.setToolTipText(tipText);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed()) {
            return;
        }
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count > 0) {
            this.visibleItemCount = count;
        }
    }

    private String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    public void defineColumns(int numberOfColumnsToCreate) {
        if (numberOfColumnsToCreate > 0) {
            this.totalColumns = numberOfColumnsToCreate;
            this.columnHeaders = null;
            this.columnWidths = null;
            this.defineColumnsInternal(null, null, numberOfColumnsToCreate);
        }
    }

    public void defineColumns(String[] columnHeaders, int[] columnBounds) {
        if (columnHeaders != null || columnBounds != null) {
            int total;
            int n = total = columnHeaders == null ? 0 : columnHeaders.length;
            if (columnBounds != null && columnBounds.length > total) {
                total = columnBounds.length;
            }
            this.columnWidths = columnBounds;
            this.columnHeaders = columnHeaders;
            this.totalColumns = total;
            this.defineColumnsInternal(columnHeaders, columnBounds, total);
        }
    }

    private void defineColumnsInternal(String[] columnHeaders, int[] columnBounds, int totalColumnsToBeCreated) {
        int totalColBounds;
        if (this.table == null) {
            return;
        }
        this.checkWidget();
        int totalColumnHeaders = columnHeaders == null ? 0 : columnHeaders.length;
        int n = totalColBounds = columnBounds == null ? 0 : columnBounds.length;
        if (totalColumnsToBeCreated > 0) {
            int index = 0;
            while (index < totalColumnsToBeCreated) {
                TableColumn column = new TableColumn(this.table, 0);
                if (index < totalColumnHeaders) {
                    column.setText(columnHeaders[index]);
                }
                if (index < totalColBounds) {
                    column.setWidth(columnBounds[index]);
                }
                column.setResizable(true);
                column.setMoveable(true);
                ++index;
            }
        }
    }

    public void setTableWidthPercentage(int ddWidthPct) {
        this.checkWidget();
        if (ddWidthPct > 0 && ddWidthPct <= 100) {
            this.tableWidthPercentage = ddWidthPct;
        }
    }

    public void setDisplayColumnIndex(int displayColumnIndex) {
        this.checkWidget();
        if (displayColumnIndex >= 0) {
            this.displayColumnIndex = displayColumnIndex;
        }
    }

    private int getDisplayColumnIndex() {
        return this.displayColumnIndex <= this.table.getColumnCount() - 1 ? this.displayColumnIndex : 0;
    }

    private char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    private synchronized void refreshText(int index, boolean fireEvent, boolean disableTextEvent) {
        TableItem tableItem = this.table.getItem(index);
        int colIndexToUse = this.getDisplayColumnIndex();
        if (this.showColorWithinSelection && !this.isInherited) {
            this.text.setForeground(tableItem.getForeground(colIndexToUse));
        }
        if (this.showFontWithinSelection) {
            this.text.setFont(tableItem.getFont(colIndexToUse));
        }
        List<Pair<Integer, Listener>> textListeners = null;
        if (disableTextEvent) {
            textListeners = this.removeTextListeners(false);
        }
        String textualValue = tableItem.getText(colIndexToUse);
        this.text.setText(textualValue);
        if (disableTextEvent) {
            this.restoreTextListeners(textListeners);
        }
        if (fireEvent) {
            ValueChangedEvent event = new ValueChangedEvent(textualValue, tableItem, false);
            for (ValueChangedListener listener : this.modifyListeners) {
                listener.valueChanged(event);
            }
        }
    }

    public void setShowColorWithinSelection(boolean showColorWithinSelection) {
        this.checkWidget();
        this.showColorWithinSelection = showColorWithinSelection;
    }

    public void setShowFontWithinSelection(boolean showFontWithinSelection) {
        this.checkWidget();
        this.showFontWithinSelection = showFontWithinSelection;
    }

    public Table getTable() {
        this.checkWidget();
        return this.table;
    }

    public void setInherithed(boolean isInherited) {
        this.isInherited = isInherited;
        if (isInherited) {
            this.text.setForeground(this.inheritedColor);
        } else {
            this.text.setForeground(this.standardColor);
        }
    }

    private boolean wasColumnWidthSpecified(int columnIndex) {
        return this.columnWidths != null && this.columnWidths.length > columnIndex && this.columnWidths[columnIndex] != -1;
    }

    private void autoAdjustColumnWidthsIfNeeded(TableColumn[] tableColumns, int totalAvailWidth, int totalColumnWidthUsage) {
        int totalAmtToBeAllocated;
        int totalColumns;
        int scrollBarSize = 0;
        int n = totalColumns = tableColumns == null ? 0 : tableColumns.length;
        if (this.table.getVerticalBar().getVisible()) {
            int n2 = scrollBarSize = this.table.getVerticalBar() == null ? 0 : this.table.getVerticalBar().getSize().x;
        }
        if (totalAvailWidth > totalColumnWidthUsage + scrollBarSize && (totalAmtToBeAllocated = totalAvailWidth - totalColumnWidthUsage - scrollBarSize) > 0) {
            tableColumns[totalColumns - 1].setWidth(tableColumns[totalColumns - 1].getWidth() + totalAmtToBeAllocated);
        }
    }

    public StyledText getTextControl() {
        this.checkWidget();
        return this.text;
    }
}

