/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui;

import net.sf.jasperreports.eclipse.builder.JSSReportContext;
import net.sf.jasperreports.eclipse.ui.ReportPreviewUtil;
import net.sf.jasperreports.eclipse.viewer.DefaultHyperlinkHandler;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.ReportViewer;
import net.sf.jasperreports.eclipse.viewer.action.ZoomActualSizeAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomComboContributionItem;
import net.sf.jasperreports.eclipse.viewer.action.ZoomFitPageAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomFitPageWidthAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomInAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomOutAction;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ReportPreviewView
extends ViewPart {
    public static final String ID = "net.sf.jasperreports.views.reportPreview";
    private Composite container = null;
    private ReportViewer reportViewer = new ReportViewer(526336, (JasperReportsContext)JSSReportContext.getDefaultInstance());
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object sel;
            IStructuredSelection strSel;
            boolean unset = true;
            if (selection instanceof IStructuredSelection && (strSel = (IStructuredSelection)selection).size() == 1 && (sel = strSel.getFirstElement()) instanceof IFile) {
                ReportPreviewUtil.loadFileIntoViewer((IFile)sel, ReportPreviewView.this.getReportViewer(), ReportPreviewView.this.getSite().getShell().getDisplay());
                unset = false;
            }
            if (unset) {
                ReportPreviewView.this.getReportViewer().setReport(null);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.jaspersoft.studio.doc.view_preview");
        Control reportViewerControl = this.reportViewer.createControl(this.container);
        reportViewerControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initToolBar();
        this.reportViewer.addHyperlinkListener(new DefaultHyperlinkHandler());
        this.getSite().getPage().addSelectionListener(this.selectionListener);
    }

    public IReportViewer getReportViewer() {
        return this.reportViewer;
    }

    public void setFocus() {
        this.container.setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
    }

    private void initToolBar() {
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.add((IContributionItem)new Separator());
        tbManager.add((IAction)new ZoomActualSizeAction(this.reportViewer));
        tbManager.add((IAction)new ZoomFitPageAction(this.reportViewer));
        tbManager.add((IAction)new ZoomFitPageWidthAction(this.reportViewer));
        tbManager.add((IContributionItem)new Separator());
        tbManager.add((IAction)new ZoomOutAction(this.reportViewer));
        tbManager.add((IContributionItem)new ZoomComboContributionItem(this.reportViewer));
        tbManager.add((IAction)new ZoomInAction(this.reportViewer));
    }
}

