/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui.util;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExtendedMessageDialog
extends MessageDialog {
    private String checkMessage = null;
    private boolean checkboxResult = false;
    private boolean result = false;

    public ExtendedMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String checkboxMessage) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.checkMessage = checkboxMessage;
    }

    protected Control createCustomArea(Composite parent) {
        if (this.checkMessage == null) {
            return null;
        }
        Button checkBox = new Button(parent, 32);
        checkBox.setText(this.checkMessage);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedMessageDialog.this.checkboxResult = ((Button)e.widget).getSelection();
            }
        });
        return checkBox;
    }

    protected boolean hasExternalLink(String message) {
        Pattern p = Pattern.compile("href=\"(.*?)\"");
        Matcher m = p.matcher(message);
        return m.find();
    }

    protected Control createMessageArea(Composite composite) {
        if (this.message != null && this.hasExternalLink(this.message)) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            Link link = new Link(composite, this.getMessageLabelStyle());
            link.setText(this.message);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
            return composite;
        }
        return super.createMessageArea(composite);
    }

    public boolean getCheckboxResult() {
        return this.checkboxResult;
    }

    public boolean getResult() {
        return this.result;
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000 | 0x8000 | 0x860);
        this.setBlockOnOpen(true);
        int exitCode = super.open();
        this.result = exitCode == -1 ? false : exitCode == 0;
        return exitCode;
    }
}

