/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui.validator;

import net.sf.jasperreports.eclipse.messages.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IDStringValidator
implements IValidator<String> {
    private static final char[] allowed = "_.".toCharArray();

    public IStatus validate(String v) {
        if (v == null || v.isEmpty()) {
            return ValidationStatus.error((String)Messages.IDStringValidator_EmptyError);
        }
        if (v.length() > 100) {
            return ValidationStatus.error((String)"ID size between 0 and 100");
        }
        char[] cArray = v.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c)) {
                boolean isAllowed = false;
                char[] cArray2 = allowed;
                int n3 = allowed.length;
                int n4 = 0;
                while (n4 < n3) {
                    char a = cArray2[n4];
                    if (c == a) {
                        isAllowed = true;
                        break;
                    }
                    ++n4;
                }
                if (!isAllowed) {
                    return ValidationStatus.error((String)Messages.IDStringValidator_InvalidChars);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public static String safeChar(String input) {
        char[] charArray = input.toString().toCharArray();
        StringBuilder result = new StringBuilder();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character newc = null;
            if (Character.isLetterOrDigit(c)) {
                newc = Character.valueOf(c);
            } else {
                char[] cArray2 = allowed;
                int n3 = allowed.length;
                int n4 = 0;
                while (n4 < n3) {
                    char a = cArray2[n4];
                    if (c == a) {
                        newc = Character.valueOf(c);
                        break;
                    }
                    ++n4;
                }
            }
            if (newc == null) {
                newc = Character.valueOf('_');
            }
            result.append(newc);
            ++n2;
        }
        return result.toString();
    }
}

