/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui.validator;

import java.io.File;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.CacheMap;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NotEmptyFileValidator
implements IValidator {
    private static final IStatus ERROR_STATUS = ValidationStatus.warning((String)Messages.NotEmptyFileValidator_filenotexists);
    private RepositoryUtil rutil;
    private Binding binding;
    private CacheMap<String, IStatus> cacheMap = new CacheMap(1000);
    private boolean empty = false;
    private Thread thread;
    private Validate validator;

    public NotEmptyFileValidator(JasperReportsContext jrContext) {
        this.rutil = RepositoryUtil.getInstance((JasperReportsContext)jrContext);
    }

    public NotEmptyFileValidator(JasperReportsContext jrContext, boolean empty) {
        this(jrContext);
        this.empty = empty;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    /*
     * Enabled aggressive block sorting
     */
    public IStatus validate(Object value) {
        IStatus s = Status.OK_STATUS;
        if (!(value instanceof String)) {
            IStatus iStatus;
            if (this.empty) {
                iStatus = s;
                return iStatus;
            }
            iStatus = ValidationStatus.error((String)Messages.NotEmptyFileValidator_0);
            return iStatus;
        }
        String v = ((String)value).trim();
        if (v.isEmpty()) {
            IStatus iStatus;
            if (this.empty) {
                iStatus = s;
                return iStatus;
            }
            iStatus = ValidationStatus.error((String)Messages.NotEmptyFileValidator_0);
            return iStatus;
        }
        if (this.rutil == null) {
            File f = new File(v);
            if (!f.exists()) return ERROR_STATUS;
            if (f.isFile()) return s;
            return ERROR_STATUS;
        }
        if (this.binding == null) {
            this.runValidator(v);
            return s;
        }
        IStatus status = this.cacheMap.get(v);
        if (status != null) {
            return status;
        }
        this.runValidator(v);
        return ERROR_STATUS;
    }

    protected void runValidator(String v) {
        if (this.validator != null) {
            this.validator.setCanceled(true);
        }
        this.validator = new Validate(v);
        if (this.thread != null && !this.thread.isAlive() && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        try {
            this.thread = new Thread(this.validator);
            this.thread.start();
        }
        catch (Throwable throwable) {}
    }

    class Validate
    implements Runnable {
        private boolean canceled = false;
        private String v;

        public Validate(String v) {
            this.v = v;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        @Override
        public void run() {
            IStatus s = this.validate2Repository(this.v);
            if (!this.canceled) {
                NotEmptyFileValidator.this.cacheMap.put(this.v, s);
                if (NotEmptyFileValidator.this.binding != null && NotEmptyFileValidator.this.binding.getTarget() != null && NotEmptyFileValidator.this.binding.getModel() != null) {
                    NotEmptyFileValidator.this.binding.validateTargetToModel();
                }
                NotEmptyFileValidator.this.thread = null;
            }
        }

        private IStatus validate2Repository(String v) {
            IStatus s;
            block6: {
                s = Status.OK_STATUS;
                InputStream is = null;
                try {
                    try {
                        is = NotEmptyFileValidator.this.rutil.getInputStreamFromLocation(v);
                        if (is == null) {
                            s = ERROR_STATUS;
                        }
                    }
                    catch (Exception exception) {
                        s = ERROR_STATUS;
                        FileUtils.closeStream(is);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(is);
                    throw throwable;
                }
                FileUtils.closeStream(is);
            }
            return s;
        }
    }
}

