/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanUtils {
    public static PropertyDescriptor[] getAllPropertyDescriptors(Class<?> clazz) {
        if (clazz.isInterface()) {
            return BeanUtils.getInterfacePropertyDescriptors(clazz);
        }
        return PropertyUtils.getPropertyDescriptors(clazz);
    }

    private static PropertyDescriptor[] getInterfacePropertyDescriptors(Class<?> interfaceClazz) {
        ArrayList<PropertyDescriptor> interfaceDescriptors = new ArrayList<PropertyDescriptor>();
        interfaceDescriptors.addAll(Arrays.asList(PropertyUtils.getPropertyDescriptors(interfaceClazz)));
        Class<?>[] implementedInterfaces = interfaceClazz.getInterfaces();
        if (implementedInterfaces != null) {
            Class<?>[] classArray = implementedInterfaces;
            int n = implementedInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                List<PropertyDescriptor> tmpDescriptors = Arrays.asList(BeanUtils.getAllPropertyDescriptors(c));
                for (PropertyDescriptor superPropDescriptor : tmpDescriptors) {
                    PropertyDescriptor existingPropDescriptor = BeanUtils.findPropDescriptorByName(interfaceDescriptors, superPropDescriptor.getName());
                    if (existingPropDescriptor == null) {
                        interfaceDescriptors.add(superPropDescriptor);
                        continue;
                    }
                    try {
                        if (existingPropDescriptor.getReadMethod() == null) {
                            existingPropDescriptor.setReadMethod(superPropDescriptor.getReadMethod());
                        }
                        if (existingPropDescriptor.getWriteMethod() != null) continue;
                        existingPropDescriptor.setWriteMethod(superPropDescriptor.getWriteMethod());
                    }
                    catch (IntrospectionException e) {
                        JasperReportsPlugin.getDefault().logError(e);
                    }
                }
                ++n2;
            }
        }
        return interfaceDescriptors.toArray(new PropertyDescriptor[interfaceDescriptors.size()]);
    }

    private static PropertyDescriptor findPropDescriptorByName(List<PropertyDescriptor> descriptors, String name) {
        if (descriptors != null && name != null) {
            for (PropertyDescriptor pd : descriptors) {
                if (!name.equals(pd.getName())) continue;
                return pd;
            }
        }
        return null;
    }
}

