/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class FileExtension {
    public static final String JRXML = "jrxml";
    public static final String PointJRXML = ".jrxml";
    public static final String JASPER = "jasper";
    public static final String PointJASPER = ".jasper";
    public static final String JRPRINT = "jrprint";
    public static final String JRCTX = "jrctx";
    public static final String PointJRCTX = ".jrctx";
    public static final String JRTX = "jrtx";
    public static final String PointJRTX = ".jrtx";
    private static Set<String> imgExt = new HashSet<String>();
    private static Set<String> fontExt;

    static {
        imgExt.add(".png");
        imgExt.add(".jpeg");
        imgExt.add(".jpg");
        imgExt.add(".jpg2000");
        imgExt.add(".bmp");
        imgExt.add(".tiff");
        imgExt.add(".gif");
        imgExt.add(".ico");
        imgExt.add(".cur");
        fontExt = new HashSet<String>();
        fontExt.add(".ttf");
        fontExt.add(".eot");
        fontExt.add(".wot");
    }

    public static IFile getCompiledFile(IFile file) {
        String name = FileExtension.getCompiledFileName(file.getName(), file.getFileExtension());
        return file.getParent().getFile((IPath)new Path(name));
    }

    public static String getCompiledFileName(String name) {
        String ext = null;
        int ind = name.lastIndexOf(46);
        if (ind >= 0) {
            ext = name.substring(ind);
        }
        return FileExtension.getCompiledFileName(name, ext);
    }

    public static String getCompiledFileName(String name, String ext) {
        name = ext != null ? StringUtils.replaceAllIns(name, ".jrxml$", PointJASPER) : String.valueOf(name) + PointJASPER;
        return name;
    }

    public static String getJRXMLFileName(String name) {
        return StringUtils.replaceAllIns(name, ".jasper$", PointJRXML);
    }

    public static IFile getSourceFile(IFile file) {
        String name = file.getName();
        String ext = file.getFileExtension();
        name = ext != null ? StringUtils.replaceAllIns(name, ".jasper$", PointJRXML) : String.valueOf(name) + PointJRXML;
        return file.getParent().getFile((IPath)new Path(name));
    }

    public static boolean isImage(String fname) {
        int ind = fname.lastIndexOf(46);
        if (ind > 0) {
            fname = fname.substring(ind);
        }
        return imgExt.contains(fname);
    }

    public static boolean isFont(String fname) {
        int ind = fname.lastIndexOf(46);
        if (ind > 0) {
            fname = fname.substring(ind);
        }
        return fontExt.contains(fname);
    }
}

