/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.ZipFilter;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FileUtils {
    public static final String DEFAULT_PROJECT = "MyReports";
    public static final String DEFAULT_PROJECT_PROPERTY = "com.jaspersoft.studio.myreports.created";
    public static final String KEY_FILE = "ifile";
    public static final String KEY_IPROJECT = "iproject";
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String LATIN1_ENCODING = "ISO-8859-1";
    public static final String TMPCOPY_FILE_PREFIX = "___$$tmpcopy";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String findRelativePath(String base, String path) throws IOException {
        int slash;
        if (base == null) {
            throw new IOException("NullOriginalPath");
        }
        if (path == null) {
            throw new IOException("NullRelativePath");
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if (path.startsWith("../")) {
            slash = base.lastIndexOf(47);
            base = base.substring(0, slash);
            path = path.substring(3);
        }
        if ((slash = base.lastIndexOf(47)) < 0) {
            return path;
        }
        String dir = base.substring(0, slash + 1);
        return String.valueOf(dir) + path;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists() && destFile.createNewFile()) {
            org.apache.commons.io.FileUtils.copyFile((File)sourceFile, (File)destFile);
        }
    }

    public static File createTempFile(String prefix, String sufix) throws IOException {
        File f = File.createTempFile(prefix, sufix);
        f.deleteOnExit();
        return f;
    }

    public static File createTempDir() throws IOException {
        return FileUtils.createTempDir("");
    }

    public static File createTempDir(String prefix) throws IOException {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException(NLS.bind((String)Messages.FileUtils_ImpossibleToCreateTempDirectory, (Object)9));
        } while ((newTempDir = new File(sysTempDir, dirName = String.valueOf(prefix) + System.currentTimeMillis())).exists());
        if (newTempDir.mkdirs()) {
            newTempDir.deleteOnExit();
            newTempDir.setWritable(true, false);
            newTempDir.setReadable(true, false);
            return newTempDir;
        }
        throw new IOException(NLS.bind((String)Messages.FileUtils_UnableToCreateDirectory, (Object)newTempDir.getAbsolutePath()));
    }

    public static boolean recursiveDelete(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            File[] fileArray = fileOrDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File innerFile = fileArray[n2];
                if (!FileUtils.recursiveDelete(innerFile)) {
                    return false;
                }
                ++n2;
            }
        }
        return fileOrDir.delete();
    }

    public static byte[] getBytes(File file) throws IOException {
        return IOUtils.toByteArray((InputStream)new FileInputStream(file));
    }

    public static byte[] getBytes(IFile file) throws IOException, CoreException {
        return IOUtils.toByteArray((InputStream)file.getContents());
    }

    public static String readFileAsAString(File file) throws IOException {
        return new String(FileUtils.getBytesFromFile(file));
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream is = new FileInputStream(file);){
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(Messages.FileUtils_FileTooLargeError);
            }
            byte[] bytes = new byte[(int)length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                throw new IOException(NLS.bind((String)Messages.FileUtils_UnableToReadFile, (Object)file.getName()));
            }
            return bytes;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File fileRenamed(File file, String strFilename, String ext) throws CoreException {
        return FileUtils.fileRenamed(file, strFilename, ext, true);
    }

    public static File fileRenamed(File file, String strFilename, String ext, boolean showWarning) throws CoreException {
        String fname = String.valueOf(strFilename) + ext;
        if (fname.equals(file.getAbsolutePath())) {
            return file;
        }
        FileUtils.deleteFileIfExists(null, fname);
        file.renameTo(new File(fname));
        if (showWarning) {
            UIUtils.showWarning(NLS.bind((String)Messages.FileUtils_DifferentFileTypeWarning, (Object)fname));
        }
        return new File(fname);
    }

    public static IFile fileRenamed(IFile file, String strFilename, String ext, boolean showWarning, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root;
        IResource r;
        String fname = String.valueOf(strFilename) + ext;
        if (fname.equals(file.getFullPath().toOSString())) {
            return file;
        }
        FileUtils.deleteFileIfExists(monitor, fname);
        try {
            file.move((IPath)new Path(fname), true, monitor);
        }
        catch (Exception ex) {
            file.getLocation().toFile().delete();
            JasperReportsPlugin.getDefault().logWarning(Messages.FileUtils_4, ex);
        }
        if (showWarning) {
            UIUtils.showWarning(NLS.bind((String)Messages.FileUtils_DifferentFileTypeWarning, (Object)fname));
        }
        if ((r = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(fname)) != null && r.exists() && r instanceof IFile) {
            return (IFile)r;
        }
        return file;
    }

    protected static void deleteFileIfExists(IProgressMonitor monitor, String fname) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource r = root.findMember(fname);
        if (r != null && r.exists()) {
            r.delete(true, monitor);
        }
    }

    public static String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    public static void writeFile(File f, String content) throws IOException {
        org.apache.commons.io.FileUtils.write((File)f, (CharSequence)content, (String)UTF8_ENCODING);
    }

    public static String getPropertyAsString(Properties prop) {
        StringBuilder str = new StringBuilder();
        for (String key : prop.stringPropertyNames()) {
            str.append(key).append("=").append(FileUtils.stringConvert(prop.getProperty(key), false, true)).append("\n");
        }
        return str.toString();
    }

    public static Properties load(String propertiesString) throws IOException {
        Properties properties = new Properties();
        if (propertiesString != null) {
            properties.load(new StringReader(propertiesString));
        }
        return properties;
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        FileUtils.closeStream(in);
        FileUtils.closeStream(out);
    }

    public static IFile getInProjectFile(URI uri, IProgressMonitor monitor) throws CoreException {
        String fileName;
        Path location = new Path(uri.getPath());
        IProject project = FileUtils.getProject(monitor);
        IFile file = project.getFile(fileName = location.lastSegment());
        if (file.exists()) {
            file = FileUtils.getValidNewIFile(project, fileName);
        }
        file.createLink((IPath)location, 256, monitor);
        return file;
    }

    public static IFolder getInProjectFolder(URI uri, IProgressMonitor monitor) throws CoreException {
        String folderName;
        Path location = new Path(uri.getPath());
        IProject project = FileUtils.getProject(monitor);
        IFolder folder = project.getFolder(folderName = location.lastSegment());
        if (folder.exists()) {
            folder = FileUtils.getValidNewIFolder(project, folderName);
        }
        folder.createLink((IPath)location, 256, monitor);
        return folder;
    }

    public static void prepareFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent != null && parent instanceof IFolder) {
            FileUtils.prepareFolder((IFolder)parent, monitor);
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    public static IProject getProject(IProgressMonitor monitor) throws CoreException {
        IProject project = null;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            if (prj.isOpen()) {
                if (project == null) {
                    project = prj;
                } else if (prj.getNature("net.sf.jasperreports.nature") != null) {
                    project = prj;
                }
                if (project.getName().equals(DEFAULT_PROJECT)) break;
            }
            ++n2;
        }
        if (project == null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(DEFAULT_PROJECT);
        }
        if (!project.exists()) {
            project.create(monitor);
            project.open(monitor);
            ProjectUtil.createJRProject(monitor, project);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        return project;
    }

    public static IEditorInput checkAndConvertEditorInput(IEditorInput editorInput, IProgressMonitor monitor) throws PartInitException {
        if (editorInput instanceof FileStoreEditorInput) {
            try {
                FileStoreEditorInput fsei = (FileStoreEditorInput)editorInput;
                IFile file = FileUtils.getInProjectFile(fsei.getURI(), monitor);
                editorInput = new FileEditorInput(file);
            }
            catch (CoreException e) {
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
        }
        return editorInput;
    }

    public static String stringConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(FileUtils.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(FileUtils.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(FileUtils.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(FileUtils.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static File findFile(IFile file, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        IContainer parent = file.getParent();
        return FileUtils.resolveFile(str, Arrays.asList(new File(parent.getLocationURI()), file.getRawLocation().toFile().getParentFile(), new File(file.getProject().getLocationURI())), true);
    }

    public static File resolveFile(String fileName, List<File> folders, boolean isResolveAbsolutePath) {
        if (fileName != null) {
            File file;
            for (File folder : folders) {
                File file2 = new File(folder, fileName);
                if (!file2.exists() || !file2.isFile()) continue;
                return file2;
            }
            if (isResolveAbsolutePath && (file = new File(fileName)).exists() && file.isFile()) {
                return file;
            }
        }
        return null;
    }

    public static File resolveFileUrl(String fileName, List<File> folders, boolean isResolveAbsolutePath) {
        File fileToBeOpened = FileUtils.resolveFile(fileName, folders, isResolveAbsolutePath);
        if (fileToBeOpened == null) {
            try {
                URL fileURL = new URL(fileName);
                File f = new File(fileURL.toURI());
                if (f.exists()) {
                    fileToBeOpened = f;
                }
            }
            catch (Exception exception) {}
        }
        return fileToBeOpened;
    }

    public static File findFile(IFile file, String str, JasperReportsContext jrConfig) {
        block5: {
            File file2;
            InputStream is = RepositoryUtil.getInstance((JasperReportsContext)jrConfig).getInputStreamFromLocation(str);
            if (is == null) break block5;
            File f = FileUtils.getTmpFile(str);
            FileOutputStream fos = new FileOutputStream(f);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                file2 = f;
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.closeStream(is);
                    FileUtils.closeStream(fos);
                    throw throwable;
                }
                catch (IOException | JRException e) {
                    e.printStackTrace();
                }
            }
            FileUtils.closeStream(is);
            FileUtils.closeStream(fos);
            return file2;
        }
        return FileUtils.findFile(file, str);
    }

    public static File getTmpFile(String str) throws IOException {
        String fname = FilenameUtils.separatorsToSystem((String)str);
        fname = FilenameUtils.getName((String)fname);
        File f = File.createTempFile(String.valueOf(fname) + TMPCOPY_FILE_PREFIX, "");
        f.deleteOnExit();
        return f;
    }

    public static boolean isValidURL(String value) {
        try {
            new URL(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isValidFilename(String file) {
        File f = new File(file);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getFileRelativePath(IFile baseFile, IFile toRelativize) {
        if (baseFile.getProject().equals((Object)toRelativize.getProject())) {
            int equalSegments = 0;
            IPath reportPath = baseFile.getFullPath();
            IPath daPath = toRelativize.getFullPath();
            int reportSegments = reportPath.segmentCount() - 1;
            int daFileSegments = daPath.segmentCount() - 1;
            int i = 0;
            while (i < reportSegments && i < daFileSegments) {
                if (!reportPath.segment(i).equals(daPath.segment(i))) break;
                ++equalSegments;
                ++i;
            }
            if (equalSegments < reportSegments) {
                StringBuilder upperLevel = new StringBuilder();
                int goUpNumber = reportSegments - equalSegments;
                int i2 = 0;
                while (i2 < goUpNumber) {
                    upperLevel.append("../");
                    ++i2;
                }
                i2 = equalSegments;
                while (i2 < daFileSegments) {
                    upperLevel.append(String.valueOf(daPath.segment(i2)) + "/");
                    ++i2;
                }
                upperLevel.append(daPath.lastSegment());
                return upperLevel.toString();
            }
            StringBuilder upperLevel = new StringBuilder();
            int i3 = equalSegments;
            while (i3 < daFileSegments) {
                upperLevel.append(String.valueOf(daPath.segment(i3)) + "/");
                ++i3;
            }
            upperLevel.append(daPath.lastSegment());
            return upperLevel.toString();
        }
        StringBuilder upperLevel = new StringBuilder();
        int i = 0;
        while (i < baseFile.getFullPath().segmentCount() - 1) {
            upperLevel.append("../");
            ++i;
        }
        upperLevel.append(String.valueOf(toRelativize.getProject().getName()) + "/");
        upperLevel.append(toRelativize.getProjectRelativePath().toPortableString());
        return upperLevel.toString();
    }

    public static void storeIFileProperty(IFile file, QualifiedName key, String value) {
        if (file != null && key != null) {
            try {
                file.setPersistentProperty(key, value);
            }
            catch (CoreException e) {
                JasperReportsPlugin.getDefault().logError(e);
            }
        }
    }

    public static String getIFileProperty(IFile file, QualifiedName key) {
        String pValue = null;
        if (file != null && key != null) {
            try {
                pValue = file.getPersistentProperty(key);
            }
            catch (CoreException e) {
                JasperReportsPlugin.getDefault().logError(e);
            }
        }
        return pValue;
    }

    public static void removeIFileProperty(IFile file, QualifiedName key) {
        if (file != null && key != null) {
            try {
                file.setPersistentProperty(key, null);
            }
            catch (CoreException e) {
                JasperReportsPlugin.getDefault().logError(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unZip(File zipFile, File outputFolder) throws IOException {
        byte[] buffer = new byte[1024];
        if (!outputFolder.exists()) {
            outputFolder.mkdir();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
                ZipEntry ze = zis.getNextEntry();
                if (ze == null) {
                    throw new IOException(Messages.FileUtils_10);
                }
                while (true) {
                    if (ze == null) {
                        zis.closeEntry();
                        return;
                    }
                    if (!ze.isDirectory()) {
                        String fileName = ze.getName();
                        File newFile = new File(outputFolder, fileName);
                        new File(newFile.getParent()).mkdirs();
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (FileOutputStream fos = new FileOutputStream(newFile);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            }
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                    ze = zis.getNextEntry();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException ex) {
            org.apache.commons.io.FileUtils.deleteDirectory((File)outputFolder);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unZip(InputStream in, File outputFolder, IProgressMonitor monitor, ZipFilter filter) throws IOException {
        byte[] buffer = new byte[1024];
        if (!outputFolder.exists()) {
            outputFolder.mkdir();
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipInputStream zis = new ZipInputStream(in);){
                ZipEntry ze = zis.getNextEntry();
                monitor.setTaskName(Messages.FileUtils_11);
                if (ze == null) {
                    throw new IOException(Messages.FileUtils_10);
                }
                while (ze != null) {
                    String[] pathComponents;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (!ze.isDirectory() && filter.isNecessary(pathComponents = ze.getName().split("/"))) {
                        File newFile = new File(outputFolder, pathComponents[pathComponents.length - 1]);
                        monitor.setTaskName(String.valueOf(Messages.FileUtils_11) + " " + newFile.getName());
                        File pfile = newFile.getParentFile();
                        if (!pfile.exists()) {
                            pfile.mkdirs();
                        }
                        Throwable throwable2 = null;
                        Object var13_17 = null;
                        try (FileOutputStream fos = new FileOutputStream(newFile);){
                            int len;
                            while ((len = zis.read(buffer)) > 0 && !monitor.isCanceled()) {
                                fos.write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            }
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                    ze = zis.getNextEntry();
                }
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException ex) {
            org.apache.commons.io.FileUtils.deleteDirectory((File)outputFolder);
            throw ex;
        }
    }

    public static Set<String> convertToLocalPath(Set<File> fileReferences) {
        if (fileReferences != null && !fileReferences.isEmpty()) {
            HashSet<String> paths = new HashSet<String>(fileReferences.size());
            for (File f : fileReferences) {
                paths.add(f.getAbsolutePath());
            }
            return paths;
        }
        return new HashSet<String>(0);
    }

    public static boolean isSameLocation(String location1, String location2) {
        File loc1 = new File(location1);
        File loc2 = new File(location2);
        return loc1.compareTo(loc2) == 0;
    }

    public static IFile getValidNewIFile(IProject project, String name) {
        IFile file = project.getFile(name);
        String newName = null;
        int i = 1;
        while (file.exists() && i < 1000) {
            newName = String.valueOf(FilenameUtils.removeExtension((String)name)) + "_" + i;
            file = project.getFile(String.valueOf(newName) + "." + FilenameUtils.getExtension((String)name));
            ++i;
        }
        return file;
    }

    public static IFolder getValidNewIFolder(IProject project, String name) {
        IFolder folder = project.getFolder(name);
        String newName = null;
        int i = 1;
        while (folder.exists() && i < 1000) {
            newName = String.valueOf(FilenameUtils.removeExtension((String)name)) + "_" + i;
            folder = project.getFolder(String.valueOf(newName) + "." + FilenameUtils.getExtension((String)name));
            ++i;
        }
        return folder;
    }

    public static int versionCompare(String str1, String str2) {
        String[] split1 = str1.split("\\.");
        String[] split2 = str2.split("\\.");
        int versionNumbers = Math.max(split1.length, split2.length);
        String[] vals1 = new String[versionNumbers];
        String[] vals2 = new String[versionNumbers];
        int i = 0;
        while (i < versionNumbers) {
            vals1[i] = i < split1.length ? split1[i] : "0";
            vals2[i] = i < split2.length ? split2[i] : "0";
            ++i;
        }
        i = 0;
        while (i < versionNumbers && vals1[i].equals(vals2[i])) {
            ++i;
        }
        if (i < versionNumbers) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public static void createResource(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            FileUtils.createResource((IResource)resource.getParent(), monitor);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
                break;
            }
            case 2: {
                ((IFolder)resource).create(0, true, monitor);
                break;
            }
            case 4: {
                ((IProject)resource).create(monitor);
                ((IProject)resource).open(monitor);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported use case: supported resource types are 1) file 2) folder 3) project");
            }
        }
    }

    public static void createFolder(IContainer resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            FileUtils.createFolder(resource.getParent(), monitor);
        }
        if (resource instanceof IFolder) {
            ((IFolder)resource).create(0, true, monitor);
        }
    }
}

